%  Frizione_poli.m
%  Sistema frizione: 
%  1) definizione dei parametri
%  2) Analisi parametrica
%  3) Risposta al gradico (simulazione) 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; 
close all;
clc; 
echo off;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Definizione dei parametri del sistema
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(1); clf
figure(2); clf
jj=0;
Pm=50;      						  % pressione di alimentazione  costante
R=0;                            % pressione di ritorno approssimata a 0
A=1;     		                 % sezione del pistone
a=1									  % Numero del gruppo
Kv=a;			                    % costante di proporzionalit della valvola
Cm0=1;                          % capacit idraulica di base del cilindro
for Cm=[1:1];			           % capacit idraulica del cilindro
for mp=[1:1];                   % massa del pistone
for b=[1:1];                    % coefficiente di attrito
for Km=[1:10];                   % rigidit della molla
x0=0;                           % condizione iniziale sulla posizione 
P10=0    ;                      % condizione iniziale sulla pressione nella camera
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Definizione del modello nello spazio degli stati
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   ML=diag([Cm mp 1]);
   MA=inv(ML)*[
   -Kv   -A    0;
     A   -b  -Km;
     0    1    0];
   MB=inv(ML)*[
     Kv; 
      0; 
      0];  
   MC=[ 0  0  Km];
   figure(1)
   if jj==0
      plot(real(roots(poly(MA))'),imag(roots(poly(MA))'),'xb'); hold on
      jj=1;   
   else
      plot(real(roots(poly(MA))'),imag(roots(poly(MA))'),'xr'); hold on
   end
   % simulazione 
   tfin=10;
   sim('friz_polimdl',tfin);           % Simula lo schema a blocchi
   % graficazione
   figure(2)
   subplot(211)
   plot(t,Fm,'b'); hold on
   subplot(212)
   plot(t,P1,'b'); hold on
   echo off
end
end
end
end
figure(1)
title('Radici del sistema. Variazione parametrica')
grid on; zoom on;
figure(2)
subplot(211)
ylabel('[ ]');
title('Forza Fm della molla');
grid on; zoom on;
subplot(212)
ylabel('[ ]');
title('Pressione P1nel cilindro');
xlabel('Time ( )');
grid on; zoom on;
return



