%  Frizione_poli.m
%  Sistema frizione: 
%  1) definizione dei parametri
%  2) Sintesi di una retroazione statica dello stato
%  3) Risposta al gradico (simulazione) 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; 
close all;
clc; 
echo off;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Specifica di controllo
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Ta=0.04;					% Tempo di assestamento richiesto
p_des=-3/Ta;			% Posizione desiderata dei poli del sistema
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Definizione dei parametri del sistema
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(1); clf
figure(2); clf
Fref=100 ;  						  % Riferimento per la forza Fm
A=1;     		                 % sezione del pistone
a=1									  % Numero del gruppo
Kv=a;			                    % costante di proporzionalit della valvola
Cm0=1;                          % capacit idraulica di base del cilindro
for Cm=[1:1];			           % capacit idraulica del cilindro
for mp=[1:1];                   % massa del pistone
for b=[1:1];                    % coefficiente di attrito
for Km=[1:1];                   % rigidit della molla
x0=0;                           % condizione iniziale sulla posizione 
P10=0    ;                      % condizione iniziale sulla pressione nella camera
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Definizione del modello nello spazio degli stati
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   ML=diag([Cm mp 1]);
   MA=inv(ML)*[
   -Kv   -A    0;
     A   -b  -Km;
     0    1    0];
   MB=inv(ML)*[
     Kv; 
      0; 
      0];  
   MC=[ 0  0  Km];
   Rpiu=[MB MA*MB MA*MA*MB];   	% Matrice di raggiungibilit\`a
   Kr=[0 0 1]*inv(Rpiu)*(MA-p_des*eye(3))*(MA-2*p_des*eye(3))*(MA-4*p_des*eye(3));  
   G0=MC*inv(-(MA-MB*Kr))*MB;					% Guadagno statico del sistema in catena chiusa
   % simulaziine 
   tfin=[0:0.001:1]*0.2;
   sim('friz_ackermdl',tfin);           % Simula lo schema a blocchi
   % graficazione
   figure(1)
   plot(t,P,'b'); hold on
   figure(2)
   subplot(211)
   plot(t,Fm,'b'); hold on
   subplot(212)
   plot(t,P1,'b'); hold on
   echo off
end
end
end
end
figure(1)
title('Segnale di pressione in ingresso')
ylabel('[ ]');
grid on; zoom on;
figure(2)
subplot(211)
ylabel('[ ]');
title('Forza Fm della molla');
grid on; zoom on;
subplot(212)
ylabel('[  ]');
title('Pressione P1 nel cilindro');
xlabel('Time ( )');
grid on; zoom on;
return



