% [T,X] = simula(A,X0)
% Calcola l'evoluzione libera dello stato del sistema linare xd=A*x a partire 
% dalla condizione iniziale X0. La durata della simulazione  pari al doppio del 
% tempo di assestamento.
%
function [T,X] = simula(A,X0)
global AAA
poli=roots(poly(A));                % Calcola i poli del sistema
pr=abs(max(real(poli)));            % Calcola la parte reale del polo dominante
Tspan=2*[0:0.005:1]*3/pr;           % Calcola la durata della simulazione (200 punti)
AAA=A;                              % Rende disponibile la matrice A alla funzione sys_a
[T,X] = ode23('simula_a',Tspan,X0); % Calcola l'evoluzione libera
