%
% Sistema non lineare:
% 
% 		x1d=beta*(2-x1)+x1^2*x2
% 		x2d=x1-x1^2*x2
%
global beta
figure(1)
clf
beta=4;									% Cambiando beta cambia il punto di lavoro 
%											% e il tipo di convergenza asintotica
x10=2*beta/(beta-1);					% Punto di equilibrio
x20=(beta-1)/(2*beta);
%
V=[[-1.5 1.5]+x10 [-1.5 1.5]+x20];						% Finestra di graficazione
In_Con=inicond(V,[5,5]);			% Definizione delle condizioni iniziali
Tspan=[0:0.005:1]*2;					% Intervallo di simulazione 
fr=10;
dx=0.05; dy=dx;
for jj=[1:size(In_Con,1)]
    [t,x]=ode23('ese_x1x2_ode',Tspan, In_Con(jj,:));		% Simulazione
    plot(x(:,1),x(:,2)); hold on      							% Graficazione
    freccia(x(fr,1),x(fr,2),x(fr+1,1),x(fr+1,2),dx,dy)   % Frecce
end            
grid on 
axis(V)
xlabel('Variabile x_1(t)') 
ylabel('Variabile x_2(t)') 
title('Traiettorie vicine al punto di lavoro')