%
% Sistema non lineare:
% 
% 		x1d=x1-x1*x2
% 		x2d=x1*x2-x2
%
% Questo esempio mostra come in un sistema non lineare conservativo le traiettorie
% non siano circolari e non siano caratterizzate dallo stesso peroido di percorrenza
% Inoltre l'esempio mostra come i piccoli errori dovuti alla simulazione determinino 
% una non perfetta chiusura delle traiettorie
%
figure(1)
clf
x10=1;					% Punto di equilibrio
x20=1;
%
V=[[-1 1]*1+x10 [-1 1]*1+x20];						% Finestra di graficazione
xx=x10+[0.1:0.1:1];
In_Con=[xx',ones(size(xx'))];			% Definizione delle condizioni iniziali
Tspan=[0:0.001:1]*6.5;					% Intervallo di simulazione 
fr=100;										% Posizione delle freccie
dx=0.035; dy=dx;
for jj=[1:size(In_Con,1)]
    [t,x]=ode23('ese_lnx_ode',Tspan, In_Con(jj,:));		% Simulazione
    plot(x(:,1),x(:,2)); hold on      							% Graficazione
    freccia(x(fr,1),x(fr,2),x(fr+1,1),x(fr+1,2),dx,dy)   % Frecce
end            
grid on 
axis(V)
xlabel('Variabile x_1(t)') 
ylabel('Variabile x_2(t)') 
title('Traiettorie vicine al punto di lavoro')