%
% Sistema non lineare:
% 
% 		x1d=x2
% 		x2d=cos(x1)-3*x1/(2*pi)-beta*x2
%
global beta
for beta=[-0.5 0:1:4];				% Intervallo di variabilit per beta  
   figure(1); clf
   										% Cambiando beta cambia il tipo di convergenza asintotica
   x10=pi/3;					 			% Punto di equilibrio
   x20=0;
   V=[[-1.5 1.5]+x10 [-1.5 1.5]+x20];						% Finestra di graficazione
   if beta>=0
      In_Con=inicond(V,[5,5]);			% Definizione delle condizioni iniziali
      Tspan=[0:0.01:1]*10;					% Intervallo di simulazione 
      fr=10;									% Posizione della freccia
   else
      xx=0.1*exp(j*[0:0.1:1]*2*pi)';
      In_Con=[real(xx)+x10 imag(xx)+x20];
      Tspan=[0:0.01:1]*10;					% Intervallo di simulazione 
      fr=80;									% Posizione della freccia   
   end
   dx=0.06; dy=dx;
   for jj=[1:size(In_Con,1)]
       [t,x]=ode23('ese_cosx_ode',Tspan, In_Con(jj,:));		% Simulazione
       plot(x(:,1),x(:,2)); hold on      							% Graficazione
       freccia(x(fr,1),x(fr,2),x(fr+1,1),x(fr+1,2),dx,dy)   % Frecce
   end            
  grid on 
  axis(V)
  xlabel('Variabile x_1(t)') 
  ylabel('Variabile x_2(t)') 
  title('Traiettorie vicine al punto di lavoro')
  pause 
end