% ese_comp.m
% 
% Esercizio sulla trasformazione di un sistema in forma compagna
% 
echo on
clc
% Generazione di un sistema dinamico SISO random di ordine "n"
n=5;
[A,B,C] = rand_ss(n,2,1)
% 
pause % premi un tasto per continuare
%
clc
% Calcolo delle  Matrici di raggiungibilit R^+ rispetto ai due ingressi
rpiu1=MatRag(A,B(:,1))
rpiu2=MatRag(A,B(:,2))
% Calcolo del  rango di tali matrici
rank(rpiu1)
rank(rpiu2)
% 
pause % premi un tasto per continuare
%
clc
% Proiezione dei due vettori A^n*B1 e A^n*B2 sulle due basi definite 
% dai vettori colonna delle due matrici di raggiungibilit R^+1 e R^+2
alpha1=inv(rpiu1)*(A^n*B(:,1))
alpha2=inv(rpiu2)*(A^n*B(:,2))
% Si noti che tali coefficienti coincidono con i coefficienti 
% del polinomio caratteristico della matrice A
poly(A)
% 
pause % premi un tasto per continuare
%
clc
% Il sistema pu essere messo in forma compagna utilizzando il comando  
[AC,BC,CC,TC]=CompFormABC(A,B(:,1),C)
% 
pause % premi un tasto per continuare
%
clc
% La matrice A non sembra essere in forma companga a causa dei piccoli 
% errori di calcolo. Se si annullano tutti i termini il cui modulo  
% minore di 1e^(-1) si ottiene
AC.*(abs(AC)>1e-10)
% cio la matrice  proprio in forma compagna

echo off
return