%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                       %
%   definizione.M                                                          	
%                                                                       
%   Definizione di un sistema nello spazio degli stati	
%                                                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
clc
echo on
% Si consideri il sistema lineare (LS) tempo continuo (TC) caratterizzato
% dalle seguenti matrici MA, MB e MC
% MA=[ 2     3     3; 
%     -4    -5    -3; 
%     -2     1    -1];
% MB=[  3; -2;  1];
% MC=[  2   1   0];
echo off
MA=[ 2     3     3; 
    -4    -5    -3; 
    -2     1    -1];
MB=[  3; -2;  1];
MC=[  2   1   0];
echo on
%
pause; % Premi un tasto per continuare
%
clc
% L'istruzione 'poly(MA)' calcola il polinomio caratteristico della matrice quadrata MA
% di ordine n:
poly(MA)
%
% In ambiente Matlab i polimoni vengono rappresentati da vettori riga le cui n+1 componenti 
% sono i coefficienti del polinomio in ordine di potenze decrescenti. 
% Per esempio, il vettore [ 1 2 3 4] rappresenta il seguente polinomio del 3^o ordine: 
% s^3 + 2*s^2 + 3*s + 4.  
%
pause; % Premi un tasto per continuare
%
clc
% I poli del sistema  coincidono con gli autovalori della matrice MA e quindi con 
% le radici del polinomio "poly(MA)"
roots(poly(MA))
%
% L'istruzione 'roots(p)' calcola numericamente le radici del polinomio p.   
%
pause; % Premi un tasto per continuare
%
clc
% La posizione dei poli del sistema pu essere visualizzata utilizzando le istruzioni 
%
figure(1);                    % Apre la figura nr. 1
clf                           % Cancella tutto ci che compare nella figura
plot(roots(poly(MA)),'rx')    % Grafica la posizione dei poli in rosso (r) con crociette (x)
% 
pause; % Premi un tasto per continuare
set(figure(1),'Visible','off')
%
clc
% Gli autovalori e gli autovettori della matrice MA si ottengono 
% utilizzando il seguente comando 
[V,D] = eig(MA)
% I primi due autovettori (cioe' le prime due colonne della matrice V)
% sono complessi coniugati perche' sono gli autovettori corrispondenti 
% ai due autovalori complessi coniugati. La matrice V  la matrice di 
% trasformazione che permette di diagonalizzare la matrice $MA$
% inv(V)*MA*V
% Trascurando i piccoli errori di calcolo si ottiene:
Approx(inv(V)*MA*V)
%
pause; % Premi un tasto per continuare
%
clc
% Per portare la matrice MA in forma reale di Jordan, occorre utilizzare 
% una matrice di trasformazione reale: gli autovettori complessi coniugati
% vengono sostituiti dai vettori parte-reale e parte-immaginaria di uno 
% dei due autovettori complessi coniugati
TM=[real(V(:,1)) imag(V(:,1)) V(:,3)]
AJ=inv(TM)*MA*TM
% Trascurando i piccoli errori di calcolo si ottiene:
Approx(inv(TM)*MA*TM)
%
pause; % Premi un tasto per continuare
%
clc
% L'evoluzione libera del sistema si ottiene simulando l'evoluzione del sistema   
% a partire dallo stato iniziale X0; X  il vettore di stato e T  il vettore dei tempi
figure(1); clf
X00=-2*V(:,3);
dx0=[0:0.1:1];
for dx=dx0
   X0=X00+[0;0;dx];
   [T,X] = simula(MA,X0); 
   plot3(X(:,1),X(:,2),X(:,3)); hold on
   echo off
end
%axis(0.5*[-1 1 -1 1 -1 1])
grid
echo on
%
% XX={};for t=T'; XX=[XX expm(MA.*t)*X0]; end 
% esponenziale di matrice
pause; % Premi un tasto per continuare
%
% Proiezione sul piano x-y
figure(1)
view(0,90)
title('Proiezione sul piano x-y')
%
pause; % Premi un tasto per continuare
%
% Proiezione sul piano y-z
figure(1)
view(0,0)
title('Proiezione sul piano y-z')
%
pause; % Premi un tasto per continuare
%
% Proiezione sul piano x-z
figure(1)
view(90,0)
title('Proiezione sul piano x-z')
%
%
pause; % Premi un tasto per continuare
%
clc
% Le stesse traiettorie nella base canonica reale di Jordan
% assumono la seguente forma:
figure(1); clf
for dx=dx0
    X0=X00+[0;0;dx];
   [T,X] = simula(AJ,X0); 
   plot3(X(:,1),X(:,2),X(:,3)); hold on
   echo off
end
%axis(0.5*[-1 1 -1 1 -1 1])
grid
echo on
%
pause; % Premi un tasto per continuare
%
% Proiezione sul piano x-y
figure(1)
view(0,90)
title('Proiezione sul piano x-y')
%
pause; % Premi un tasto per continuare
%
% Proiezione sul piano y-z
figure(1)
view(0,0)
title('Proiezione sul piano y-z')
%
pause; % Premi un tasto per continuare
%
% Proiezione sul piano x-z
figure(1)
view(90,0)
title('Proiezione sul piano x-z')
%

   
echo off

return
