%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                       %
%   definizione.M                                                          	
%                                                                       
%   Definizione di un sistema nello spazio degli stati	
%                                                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
clc
echo on
% Si consideri il sistema lineare (LS) tempo continuo (TC) caratterizzato
% dalle seguenti matrici MA, MB e MC
% MA=[ 2     3     3; 
%     -4    -5    -3; 
%     -2     1    -1];
% MB=[  3; -2;  1];
% MC=[  2   1   0];
echo off
MA=[ 2     3     3; 
    -4    -5    -3; 
    -2     1    -1];
MB=[  3; -2;  1];
MC=[  2   1   0];
echo on
%
pause; % Premi un tasto per continuare
%
clc
% Per definire un sistema tempo continuo in ambiente Matlab si utilizza il 
% comando "ss" (state space). Utilizzando l'istruzione 
SYS=ss(MA,MB,MC,0)
% Si assegna alla variabile SYS il significato di sistema dinamico lineare 
% caratterizzato dalle 3 matrici MA, MB e MC (la matrice  MD=0).
%
pause; % Premi un tasto per continuare
%
clc
% E' possibile assegnare un nome alle variabili di ingressi, di stato e di uscita 
% utilizzando il comado "set"
set(SYS,'InputName','Tensione')
set(SYS,'StateName',[   'Corrente ';  'Velocita ';      'Posizione'])
set(SYS,'OutputName','Uscita')
SYS
%
pause; % Premi un tasto per continuare
%
clc
% La funzione di trasferimento del sistema G(s) si ottiene utilizzando il comando "tf"
GS=tf(SYS)
%
pause; % Premi un tasto per continuare
%
clc
% I poli del sistema $G(s)$ 
pole(GS)
% coincidono con i poli del sistema SYS
pole(SYS)
% e coincidono con gli autovalori della matrice MA
roots(poly(MA))
%
pause; % Premi un tasto per continuare
%
clc
% La posizione dei poli e degli zeri del sistema SYS possono essere 
% visualizzati utilizzando l'istruzione 
figure(1); clf
pzmap(SYS)
%
pause; % Premi un tasto per continuare
%
% La risposta al gradino si ottiene utilizzando il comando  
figure(1); clf
step(SYS)
%
pause; % Premi un tasto per continuare
%
% La risposta all'impulso si ottiene utilizzando il comando  
figure(1); clf
impulse(SYS)
%
pause; % Premi un tasto per continuare
%
% I diagrammi di Bode si ottendono utilizzando il comando:  
figure(1); clf
bode(SYS)
%
pause; % Premi un tasto per continuare
%
% I diagrammi di Nyquist si ottendono utilizzando il comando:  
figure(1); clf
nyquist(SYS)
%
pause; % Premi un tasto per continuare
%
set(figure(1),'Visible','off')
clc
% Gli autovalori e gli autovettori della matrice MA si ottengono 
% utilizzando il seguente comando 
[V,D] = eig(MA)
% I primi due autovettori (cioe' le prime due colonne della matrice V)
% sono complessi coniugati perche' sono gli autovettori corrispondenti 
% ai due autovalori complessi coniugati. La matrice V  la matrice di 
% trasformazione che permette di diagonalizzare la matrice $MA$
inv(V)*MA*V
% Trascurando i piccoli errori di calcolo si ottiene:
approx(inv(V)*MA*V)
%
pause; % Premi un tasto per continuare
%
clc
% Per portare la matrice MA in forma reale di Jordan, occorre utilizzare 
% una matrice di trasformazione reale: gli autovettori complessi coniugati
% vengono sostituiti dai vettori parte-reale e parte-immaginaria di uno 
% dei due autovettori complessi coniugati
TM=[real(V(:,1)) imag(V(:,1)) V(:,3)]
inv(TM)*MA*TM
% Trascurando i piccoli errori di calcolo si ottiene:
approx(inv(TM)*MA*TM)
%
pause; % Premi un tasto per continuare
%
clc
% Alla stessa forma canonica reale di Jordan si poteva giungere 
% utilizzando il comando 
[CSYS,TM]=canon(SYS)
%
pause; % Premi un tasto per continuare
%
clc
% L'evoluzione libera del sistema si ottiene con il comando "initial": 
% X0 stato iniziale; X e Y vettori di stato e di uscita ; T vettore dei tempi
figure(1); clf
X00=-2*V(:,3);
dx0=[0:0.1:1];
for dx=dx0
    X0=X00+[0;0;dx];
   [Y,T,X] = initial(SYS,X0); 
   plot3(X(:,1),X(:,2),X(:,3)); hold on
   echo off
end
%axis(0.5*[-1 1 -1 1 -1 1])
grid
echo on
%
pause; % Premi un tasto per continuare
%
% Proiezione sul piano x-y
figure(1)
view(0,90)
title('Proiezione sul piano x-y')
%
pause; % Premi un tasto per continuare
%
% Proiezione sul piano y-z
figure(1)
view(0,0)
title('Proiezione sul piano y-z')
%
pause; % Premi un tasto per continuare
%
% Proiezione sul piano x-z
figure(1)
view(90,0)
title('Proiezione sul piano x-z')
%
%
pause; % Premi un tasto per continuare
%
clc
% Le stesse traiettorie nella base canonica reale di Jordan
% assumono la seguente forma:
figure(1); clf
for dx=dx0
    X0=X00+[0;0;dx];
   [Y,T,X] = initial(CSYS,-TM*X0); 
   plot3(X(:,1),X(:,2),X(:,3)); hold on
   echo off
end
%axis(0.5*[-1 1 -1 1 -1 1])
grid
echo on
%
pause; % Premi un tasto per continuare
%
% Proiezione sul piano x-y
figure(1)
view(0,90)
title('Proiezione sul piano x-y')
%
pause; % Premi un tasto per continuare
%
% Proiezione sul piano y-z
figure(1)
view(0,0)
title('Proiezione sul piano y-z')
%
pause; % Premi un tasto per continuare
%
% Proiezione sul piano x-z
figure(1)
view(90,0)
title('Proiezione sul piano x-z')
%

   
echo off

return

pause      % Strike any key to continue.
echo off
ltiview('step',SYS) 
return
