% ciclo_limite.m
%
% Sistema non lineare del secondo ordine che 
% presenta un ciclo limite di raggio unitario
%
%  dx(1,1)=-x(2)+x(1)*(1-x(1)^2-x(2)^2);
%  dx(2,1)= x(1)+x(2)*(1-x(1)^2-x(2)^2);
%
figure(1)
clf
Tspan=[0:0.005:1]*10;				% Intervallo di simulazione (200 punti)
fr=15;
dx=0.08; dy=dx;
In_Con=[ 0.0  1.0;					% Definizione delle condizioni iniziali 
         0.0 -1.0;					% Definizione delle condizioni iniziali 
         0.5  0.0;					% Definizione delle condizioni iniziali 
         1.5  0.0;					% Definizione delle condizioni iniziali 
        -0.5  0.0;					% Definizione delle condizioni iniziali 
        -1.5  0.0];
for jj=[1:size(In_Con,1)]
    [t,x]=ode23('ciclo_limite_ode',Tspan, In_Con(jj,:));		% Simulazione
    plot(x(:,1),x(:,2)); hold on      								% Graficazione
    freccia(x(fr,1),x(fr,2),x(fr+1,1),x(fr+1,2),dx,dy)   
 end            
grid on									% Griglia attiva
axis square
xlabel('Variabile x_1(t)') 
ylabel('Variabile x_2(t)') 
title('Ciclo limite a raggio unitario')