% [Ab,Bb,Cb] = Trasform(A,B,C,T)
%
% Calcola le matrici Ab,Bb e Cb del sistema trasformato che si ottiene a partire dal 
% sistema (A,B,C) applicando la trasformazione xv=T*xn dove xv  il vecchio vettore 
% e xn  il nuovo vettore, cio: 
%
%         Ab=inv(T)*A*T;      Bb=inv(T)*B; 		 Cb=C*T;
%
function [Ab,Bb,Cb] = trasform(A,B,C,T)
[nra,nca]=size(A);				% Calcola il numero di righe e di colonne 
[nrb,ncb]=size(B);				% delle matrici A, B, C e T
[nrc,ncc]=size(C);				%  
[nrt,nct]=size(T);				% 
if (size(T,1)==size(T,1))&(det(T)~=0)	% Se T  quadrata e invertibile
   Tinv=inv(T);								% si calcola la matrice T inversa
   if (nca==nrb)&(ncc==nra)
      Ab=Tinv*A*T;
      Bb=Tinv*B;
      Cb=C*T;
   else   
      help Trasform
      disp('Errore: le matrici A, B e C non sono compatibili')
   end   
else   
   help Trasform
   disp('Errore: la matrice T non  invertibile')
end 
return