% Rp=MatRag(A,B) 
% Calcola la matrice di raggiungibilit del sistema linare (A,B): 
%
%	Rp = [B A*B A*A*B ... A^(n-1)*B] 
%
function Rp=MatRag(A,B)
[nra,nca]=size(A);				% Calcola il numero di righe e di colonne 
[nrb,ncb]=size(B);				% delle matrici A e B
if (nra==nca)&(nca==nrb)
   Rp=B;
   for n=[1:nra-1]
      Rp=[Rp (A^n)*B];
   end
else
   help MatRag
   disp('Errore: la matrice A non  quadrata oppure non  compatibile con C')
end
return