% [AJ,TJ]=JordanFormA(A,tipo)
% 
% Calcola la matrice TJ che porta la matrice A in forma di Jordan AJ. 
% Se tipo='real', si fornisce la forma reale di Jordan
% 
function [AJ,TJ]=JordanFormA(A,tipo)
[nra,nca]=size(A);				% Calcola il numero di righe e di colonne della matrice A
if (nargin==2)&(isstr(tipo))
   tipo=[tipo '    '];
   tipo=tipo(1:4);
else
   tipo='comp';
end
if (nca==nra)
   [V,D] = eig(A);
   if tipo=='real'
      TJ=V;
      jj=1;
      while jj<nca
         if D(jj,jj)~=real(D(jj,jj))
            TJ(:,jj)=real(TJ(:,jj));
            TJ(:,jj+1)=imag(TJ(:,jj+1));
            jj=jj+2;
         else
      		jj=jj+1;         
         end
      end
      AJ=inv(TJ)*A*TJ;
   else
      TJ=V;
      AJ=D;
   end
else
   help JordanFormA
   disp('Errore: la matrici A non  quadrata')  
end   
