% function  X0=initcond(V, dxy)
%
% Fonisce le condizioni iniziali che si trovano su di un contorno 
% rettangolare V=[x1 x2 y1 y2] e con un numero di spaziature per lato 
% dato da dxy=[dx dy]
% 
function  X0=initcond(V, dxy)
 X0=zeros(2*(dxy(1)+dxy(2)),2);
 for ii= [1:dxy(2)]  
  X0(ii,:)=[V(1) V(3)+(ii-1)*(V(4)-V(3))/dxy(2)];
 end
 for ii= [1:dxy(1)]  
  X0(dxy(2)+ii,:)=[V(1)+(ii-1)*(V(2)-V(1))/dxy(1) V(4)];
 end
 for ii= [1:dxy(2)]  
  X0(dxy(1)+dxy(2)+ii,:)=[V(2) V(4)-(ii-1)*(V(4)-V(3))/dxy(2)];
 end
 for ii= [1:dxy(1)]  
  X0(dxy(1)+2*dxy(2)+ii,:)=[V(2)-(ii-1)*(V(2)-V(1))/dxy(1) V(3)];
 end
 return