%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                       %
%   trasmissione.M                                                      %
%                                                                       %
%   Programma per la simulazione del modello trasmissionemdl.	         %
%                                                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Definizione delle unit di misura del SI %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
m=1;
cm=0.01*m;
mm=0.001*m;
sec=1;
kg=1;
N=1;
rad=1;
gradi=pi*rad/180;
bar=1*10^5*N/m^2;   % 1 bar = 10^5 N/m^2
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Assegnazione dei valori alle costanti dello schema di simulazione %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
J = 5*kg*(20*cm)^2;           % Inerzia dell'albero di trasmissione
b1 = 5*N*m/(10*rad*sec);    	% Attrito lineare sull'albero
R = 40*cm;                    % Raggio del rullo elastico 
K1 = 100*N*m/(5*gradi); 		% Rigidit del rullo elastico 
M = 8*kg;     			         % Massa traslante
b2 = 4*N/(m/sec); 			   % Smorzamento lineare sulla massa traslante
K2 = 200*N/(5*cm);     			% Rigidit del  pneumatico
tau_in=100*N*m;				   % Coppia esterna
% Condizione iniziale integrale Int1: schiacciamento iniziale del pneumatico
Wdot_0 = -3*rad/sec;          % Velocit iniziale della massa ruotante 
Th_0 = 2*gradi;				   % Schiacciamento iniziale della molla torsionale
Xdot_0 = -1*m/sec;            % Velocit iniziale della massa traslante 
X2_0 = 8*cm;	  	            % Schiacciamento iniziale della molla traslante
X0_0=[Wdot_0; K1*Th_0; Xdot_0; X2_0];

% Disturbo
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Simulazione dello schema carrello1mdl %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tfin = 5*sec;                    % Tempo finale della simulazione
Tsim=tfin/1000;
sim('trasmissionemdl',tfin);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Descrizione del sistema nello spazio degli stati:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Am=[    -b1/J     -1/J     0       0  ;   % Velocit rotazionale Wdot dell'albero
         K1         0    -K1/R     0  ;   % Coppia tau del rullo elastico
         0       1/(R*M)  -b2/M   -K2/M;  % Velocit Xdot della massa M
         0          0      1      0 ];    % Schiacciamento X2 della molla

Bm=[1/J;0;0;0];  % Unico ingresso: Coppia tau

Cm=[ 1 0 0 0;      % Velocit rotazionale albero
     0 0 0 K2];    % Forza applicata alla molla
  
  SYS=ss(Am,Bm,Cm,0);  
  
  GS=tf(SYS); % - Create a transfer function model.
  pole(GS)
  
  % Calcolo del punto di lavoro  
  X_SS=-inv(Am)*Bm*tau_in
  
  figure(1)
  clf
  subplot(211)
  plot(t,Wdot); 
  hold on; plot([0 tfin], X_SS(1)*[1 1],':r') 
  ylabel('Velocit inerzia J [rad/sec]')  
  subplot(212)
  plot(t,tau/(K1*gradi))
  hold on; plot([0 tfin], X_SS(2)*[1 1]/(K1*gradi),':r') 
  ylabel('Schiacciamento Th [gradi]')
  xlabel('Tempo [s]')  
  
  figure(2)
  clf
  subplot(211)
  plot(t,Xdot)
  hold on; plot([0 tfin], X_SS(3)*[1 1],':r') 
  ylabel('Velocit massa M [m/sec]')  
  subplot(212)
  plot(t,X2/cm)
  hold on; plot([0 tfin], X_SS(4)*[1 1]/(cm),':r') 
  ylabel('Schiaciamnto X2 [cm]')
  xlabel('Tempo [s]')
  
  % Stima dello stato iniziale del sistema 
  
  SYSD=c2d(SYS,Tsim);  
  [Ad,Bd,Cd,Dd] = SSDATA(SYSD);
  
  figure(3)
  clf
  Uk=tau_in*ones(1,40);				% Vettore degli ingressi;
  Xk=EvForUk(Ad,Bd,Uk);				% Risposta forzata Xk all'ingresso Uk 
  for n=[4:1:20]
     Y2=K2*X2(1:n)-(Cd(2,:)*Xk(:,1:n))';	% Risposta libera dell'uscita
     Omn=MatOssK(Ad,Cd(2,:),n);				% Matrice di osservabilit a k passi  
     rand('state',0);							% Generatore di numeri casuali
     x0=inv(Omn'*Omn)*Omn'*(Y2.*(1+0.01*(rand(size(Y2))-0.5)));
     % Con disturbi di misura sull'uscita 
     subplot(411); plot(n,x0(1),'*',n,X0_0(1),'.r'); hold on
     subplot(412); plot(n,x0(2),'*',n,X0_0(2),'.r'); hold on
     subplot(413); plot(n,x0(3),'*',n,X0_0(3),'.r'); hold on
     subplot(414); plot(n,x0(4),'*',n,X0_0(4),'.r'); hold on
  end
  subplot(411); axis([4 20 X0_0(1)*([0.9 1.1]*(X0_0(1)>0)+[1.2 0.8]*(X0_0(1)<0))])
  subplot(412); axis([4 20 X0_0(2)*([0.9 1.1]*(X0_0(2)>0)+[1.2 0.8]*(X0_0(2)<0))])
  subplot(413); axis([4 20 X0_0(3)*([0.9 1.1]*(X0_0(3)>0)+[1.2 0.8]*(X0_0(3)<0))])
  subplot(414); axis([4 20 X0_0(4)*([0.9 1.1]*(X0_0(4)>0)+[1.2 0.8]*(X0_0(4)<0))])
  X0_0			% Stato iniziale vero
  x0				% stato iniziale stimato
