% Om=MatOssK(A,C,k) 
%
% Calcola la matrice di ossservabilit a k passi del sistema linare (A,C): 
%
%	Om = [C; C*A; C*A^2; ... ;C*A^(k-1)] 
%
function Om=MatOssK(A,C,k)
[nra,nca]=size(A);				% Calcola il numero di righe e di colonne 
[nrc,ncc]=size(C);				% delle matrici A e C
if (nra==nca)&(ncc==nra)
   Om=C;
   for n=[1:k-1]
      Om=[Om; C*(A^n)];
   end
else
   help MatOssK
   disp('Errore: la matrice A non  quadrata oppure non  compatibile con C')
end
return