% Xk=EvForUk(A,B,Uk) 
%
% Calcola l'evoluzione forzata del sistema linare (A,B) all'ingresso Uk: 
%
%
function Xk=EvForUk(A,B,Uk)
[nra,nca]=size(A);				% Calcola il numero di righe e di colonne 
[nrb,ncb]=size(B);				% delle matrici A, B e Uk
[nru,ncu]=size(Uk);				% 
k=max([nru,ncu]);
if (nra==nca)&(nca==nrb)&(ncb==nru)
   Xk=zeros(nra,1);
   for n=[1:k-1]
      Xk=[Xk A*Xk(:,n)+B*Uk(:,n)];
   end
else
   help EvForUk
   disp('Errore: le dimensioni delle matrici A, B e Uk non  conpatibile')
end
return