%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                       %
%   Rete_Elettrica_2006.m                                             	%
%                                                                       %
%   Controllo di una rete elettrica con 2 condensatori ed un induttore	%
%                                                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
close all
clc
echo on
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Si utilizzano le unit di misura del Sistema Internazionale SI    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
A=1; ohm=1; V=1; H=1; F=1; rad=1; sec=1;
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Parametri fisici del sistema                                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
R1 = 10*ohm;                     % Resistenza R1
R2 = 10*ohm;                     % Resistenza R2
C1 = 0.1*F;                      % Capacita' C1
C2 = 0.3*F;                      % Capacita' C2
L  = 0.2*H;                      % Induttanza L
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Condizioni iniziali del sistema                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
V10=10*V;                        % Tensione iniziale ai capi del condensatore C1
IL0= 0*A;                        % Corrente iniziale che scorre nell'induttore L
V20=10*V;                        % Tensione iniziale ai capi del condensatore C2
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Condizioni finali                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
V1f= 0*V;                        % Tensione finale ai capi del condensatore C1
ILf=10*A;                        % Corrente finale che scorre nell'induttore L
V2f= 0*V;                        % Tensione finale ai capi del condensatore C2
%
echo on
%
pause; % Premi un tasto per continuare
%
clc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Definizione delle matrici di sistema nello spazio degli stati     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Am=[     0                 1/C1               0 ;
         -1/L    -R1*R2/(L*(R1+R2)) -R1/(L*(R1+R2));
         0       R1/(C2*(R1+R2)) -1/(C2*(R1+R2)) ;
      ];
  Bm=[   0; 
         1/L;
         0];  
Cm=[ 0  R1*R2/(R1+R2) -R2/(R1+R2) ];
%
SYS=ss(Am,Bm,Cm,0)
%
pause; % Premi un tasto per continuare
%
clc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Funzione di trasferimento del sistema                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
GS=tf(SYS) 	
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Poli del sistema                                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
pole(SYS)  
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Zeri di trasmissione del sistema                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
zero(SYS)  
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Posizione dei poli e degli zeri nel piano                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(1)
pzmap(SYS) % - Pole-zero map.
%
pause; % Premi un tasto per continuare
%
clc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Forma canomica di controllo                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
SYSC=canon(SYS) % Canonical form
%
pause; % Premi un tasto per continuare
%
clc
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Matrice di controllabilit                                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ctrb(SYS)  % - Controllability matrice.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Determinante della matrice di controllabilit                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
det(ctrb(SYS))
%
pause; % Premi un tasto per continuare
%
clc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Evoluzione libera del sistema                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% ltiview('step',SYS) 
[Y,T,X] = initial(SYS,[V10 IL0 V20]);
%
figure(2)
subplot(311)
plot(T,X(:,1))
grid on
title('Tensione V1')
ylabel('V1 [V]')
%
subplot(312)
plot(T,X(:,2))
grid on
title('Corrente IL')
ylabel('IL [A]')
%
subplot(313)
plot(T,X(:,3))
grid on
title('Tensione V2')
ylabel('V2 [V]')
xlabel('Tempo [s]')
%
pause; % Premi un tasto per continuare
%
clc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Discretizzazione del sistema tempo continuo                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
Tsamp=0.5;                             % Periodo di campionamento
SYSD = c2d(SYS,Tsamp,'zoh');				% Discretizzazione del sistema
[AD,BD,CD,DD] = ssdata(SYSD)				% Sistema discreto
%
pause; % Premi un tasto per continuare
%
clc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calcolo del controllo a norma minima e simulazione                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
X0=[V10; IL0; V20];							% Stato iniziale
Xf=[V1f; ILf; V2f];							% Stato finale
u=Controllo_P2P(AD,BD,X0,Xf,3);        % Calcolo del controllo a norma minima
[YS,TS,XS] = lsim(SYSD,u,[],X0)			% Similazione con l'ingresso calcolato
t=(0:length(u)-1)*Tsamp;
[tt,uu] = stairs(t,u);
Ind=find(diff(tt)==0);
tt(Ind+1)=tt(Ind+1)+0.0000001;
tin=(0:0.0001:1)*t(end);
uin= interp1(tt,uu,tin);
[YSt,TSt,XSt] = lsim(SYS,uin,tin,X0,'zoh');			% Similazione con l'ingresso calcolato
%
pause
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Graficazione dei dati                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
figure(3)
clf
subplot(311)
plot(TS,XS(:,1),'*'); hold on
plot(TSt,XSt(:,1),'r'); hold on
grid on
stairs(TS,XS(:,1))
title('Tensione V1')
ylabel('V1 [V]')
%
subplot(312)
plot(TS,XS(:,2),'*'); hold on
plot(TSt,XSt(:,2),'r'); hold on
grid on
stairs(TS,XS(:,2))
title('Corrente IL')
ylabel('IL [A]')
%
subplot(313)
plot(TS,XS(:,3),'*'); hold on
plot(TSt,XSt(:,3),'r'); hold on
grid on
stairs(TS,XS(:,3))
title('Tensione V2')
ylabel('V2 [V]')
xlabel('Tempo [s]')
%
pause; % Premi un tasto per continuare
%
clc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calcolo delle traiettorie al variare del periodo di controllo     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
figure(4); clf
figure(5); clf
for k=[3:8]
   u=Controllo_P2P(AD,BD,X0,Xf,k);        % Calcolo del controllo a norma minima
   [YS,TS,XS] = lsim(SYSD,u,[],X0);			% Similazione con l'ingresso calcolato
   t=(0:k)*Tsamp;
   [tt,uu] = stairs(t,u);
   Ind=find(diff(tt)==0);
   tt(Ind+1)=tt(Ind+1)+0.0000001;
   tin=(0:0.0001:1)*t(end);
   uin= interp1(tt,uu,tin);
   [YSt,TSt,XSt] = lsim(SYS,uin,tin,X0,'zoh');			% Similazione con l'ingresso calcolato
   %
   figure(4)
   plot3(XS(:,1),XS(:,2),XS(:,3)); hold on
   plot3(XS(:,1),XS(:,2),XS(:,3),'*'); 
   plot3(XSt(:,1),XSt(:,2),XSt(:,3),'r'); 
   figure(5)
   [XX,YY]=stairs(TS,u)
   plot3(ones(size(XX))*k,XX,YY); hold on
   echo off   
end
echo on
% end 
figure(4)
plot3(X0(1),X0(2),X0(3),'*r'); 
plot3(Xf(1),Xf(2),Xf(3),'*r'); 
title('Traiettorie nello spazio degli stati')
xlabel('Tensione V1 [V]')
ylabel('Corrente IL [A]')
zlabel('Tensione V2 [V]')
grid on
figure(5)
grid on
title('Variabile di controllo')
ylabel('u(t) [V]')
xlabel('Tempo [s]')
return
