% Rp=MatRagK(A,B,k) 
%
% Calcola la matrice di raggiungibilit a k passi del sistema linare (A,B): 
%
%	Rp = [B A*B A*A*B ... A^(k-1)*B] 
%
function Rp=MatRagK(A,B,k)
[nra,nca]=size(A);				% Calcola il numero di righe e di colonne 
[nrb,ncb]=size(B);				% delle matrici A e B
if (nra==nca)&(nca==nrb)
   Rp=B;
   for n=[1:k-1]
      Rp=[Rp (A^n)*B];
   end
else
   help MatRagK
   disp('Errore: la matrice A non  quadrata oppure non  compatibile con B')
end
return