% function u=Controllo_P2P(AD,BD,X0,Xf,np)
%
% Fornisce in uscita l'azione di controllo a norma minima che porta il sistema 
% dallo stato iniziale X0 allo stato finale Xf, in "np" passi. Si suppone che 
% il discreto caratterizzato dalle matrici A e B sia discreto e raggingibile 
%
function u=Controllo_P2P(AD,BD,X0,Xf,np)
%
Rpiu=MatRagK(AD,BD,np);                          % Matrice di raggiungibilia'
u=Rpiu'*inv(Rpiu*Rpiu')*(Xf-(AD^np)*X0);         % Calcolo dell'ingresso di controllo
u=[fliplr(u') 0];                                % Ordinamento di u al crescere del tempo 

return