function zpplots(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8)
%ZPPLOTS  Tracciamento della mappa zeri-poli di una o piu' f.d.t. (TFI).
%   ZPPLOTS,gi - da TFI [ZPPLOTS('gi') - da Matlab] traccia la mappa
%   zeri-poli della funzione di trasferimento gi. Si possono chiamare
%   fino a quattro f.d.t. le cui mappe vengono date in colori diversi.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global ABIL TRF1 TRF2 TRF3 TRF4 HA str HALEG FIGLEG LABLEG SUBPLEG

if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
[vcol1,vcol2,repco]=coltbl; ABIL=0; HALEG=[]; LABLEG=[]; SUBPLEG=0;
frame=.1; str='s'; HA=[]; EA=setstr(200);
nargs=nargin;
if nargs==0
 flg=0;
 while flg==0
  arg1=input('\n   specificare la funzione di trasferimento : ','s');
  if ~isempty(arg1)
   if ~exist([arg1,'.mat'])
    disp([' **** errore: ',g1,'.mat non esiste'])
   else
    flg=1; nargs=1;
   end
  end
 end
end
%
if ~exist([arg1,'.mat'])
 disp([' **** errore: ',arg1,'.mat non esiste']), return
end
[z,p,k,str]=exportf(arg1,1); if isempty(k), return, end
xz1=real(z); yz1=imag(z); xp1=real(p); yp1=imag(p);
zp=[z;p]; xxx=real(zp); yyy=imag(zp);
if islegen
 LABLEG=['''',arg1,''''];
end
%
if nargs>=2
 if ~exist([arg2,'.mat'])
  disp([' **** errore: ',arg2,'.mat non esiste']), return
 end
 [z,p,k,str1]=exportf(arg2,1); if isempty(k), return, end
 xz2=real(z); yz2=imag(z); xp2=real(p); yp2=imag(p);
 zp=[z;p]; xxx=[xxx;real(zp)]; yyy=[yyy;imag(zp)];
 if str1~=str
  disp(' **** errore: insieme tempo continuo e discreto'), return
 end
 if islegen
  LABLEG=[LABLEG,',''',arg2,''''];
 end
end
if nargs>=3
 if ~exist([arg3,'.mat'])
  disp([' **** errore: ',arg3,'.mat non esiste']), return
 end
 [z,p,k,str1]=exportf(arg3,1); if isempty(k), return, end
 zp=[z;p];
 xz3=real(z); yz3=imag(z); xp3=real(p); yp3=imag(p);
 zp=[z;p]; xxx=[xxx;real(zp)]; yyy=[yyy;imag(zp)];
 if str1~=str
  disp(' **** errore: misto di f.d.t. a tempo continuo e discreto'), return
 end
 if islegen
  LABLEG=[LABLEG,',''',arg3,''''];
 end
end
if nargs>=4
 if ~exist([arg4,'.mat'])
  disp([' **** errore: ',arg4,'.mat non esiste']), return
 end
 [z,p,k,str1]=exportf(arg4,1); if isempty(k), return, end
 xz4=real(z); yz4=imag(z); xp4=real(p); yp4=imag(p);
 zp=[z;p]; xxx=[xxx;real(zp)]; yyy=[yyy;imag(zp)];
 if str1~=str
  disp(' **** errore: misto di f.d.t. a tempo continuo e discreto'), return
 end
 if islegen
  LABLEG=[LABLEG,',''',arg4,''''];
 end
end
%
xi=min(xxx); xs=max(xxx); yi=min(yyy); ys=max(yyy);
dx=(xs-xi)*frame; dy=(ys-yi)*frame;
xi=xi-dx;xs=xs+dx;yi=yi-dy;ys=ys+dy;
%
clf, ordf(3), nfig=gcf; nfigs=int2str(nfig); FIGLO=resfiglo;
FIGLEG=nfig;
if any(FIGLO(10,:))
 eval('set(nfig,''Position'',FIGLO(10,1:4))','erx=1;') %5.3
end
men_opt=uimenu(nfig,'Label','Memo');
if strcmp(str,'s')
 mess='mappa zeri-poli, tempo continuo';
else
 mess='mappa zeri-poli, tempo discreto';
end
uimenu(men_opt,'Label',mess);
plot([xi,xi,xs,xs],[yi,ys,ys,yi],'Color',vcol1(8,:),'LineStyle','none',...
'Marker','.'), VV=axis; axis(VV), hold on
%
if ~isempty(xz1)
 plot(xz1,yz1,'Color',vcol1(1,:),'LineStyle','none','Marker','o',...
'LineWidth',2)
end
if ~isempty(xp1)
 plot(xp1,yp1,'Color',vcol1(1,:),'LineStyle','none','Marker','x',...
'MarkerSize',10,'LineWidth',2)
end
TRF1=[arg1,repco(1)];
uimenu(men_opt,'Label',[arg1,', colore ',repco(1)],'Separator','on',...
'Callback','tfmaux(1,1,0)');
if nargs>=2
 if ~isempty(xz2)
  plot(xz2,yz2,'Color',vcol1(2,:),'LineStyle','none','Marker','o',...
 'LineWidth',2)
 end
 if ~isempty(xp2)
  plot(xp2,yp2,'Color',vcol1(2,:),'LineStyle','none','Marker','x',...
 'MarkerSize',10,'LineWidth',2)
 end
 TRF2=[arg2,repco(2)];
 uimenu(men_opt,'Label',[arg2,', colore ',repco(2)],...
 'Callback','tfmaux(2,1,0)');
end
if nargs>=3
 if ~isempty(xz3)
  plot(xz3,yz3,'Color',vcol1(3,:),'LineStyle','none','Marker','o',...
 'LineWidth',2)
 end
 if ~isempty(xp3)
  plot(xp3,yp3,'Color',vcol1(3,:),'LineStyle','none','Marker','x',...
 'MarkerSize',10,'LineWidth',2)
 end
 TRF3=[arg3,repco(3)];
 uimenu(men_opt,'Label',[arg3,', colore ',repco(3)],...
 'Callback','tfmaux(3,1,0)');
end
if nargs>=4
 if ~isempty(xz4)
  plot(xz4,yz4,'Color',vcol1(4,:),'LineStyle','none','Marker','o',...
 'LineWidth',2)
 end
 if ~isempty(xp4)
  plot(xp4,yp4,'Color',vcol1(4,:),'LineStyle','none','Marker','x',...
 'MarkerSize',10,'LineWidth',2)
 end
 TRF4=[arg4,repco(4)];
 uimenu(men_opt,'Label',[arg4,', colore ',repco(4)],...
 'Callback','tfmaux(4,1,0)');
end
if strcmp(str,'s')
 plot([0,0],[VV(3),VV(4)],'Color',vcol1(7,:),'LineStyle',':')
 plot([VV(1),VV(2)],[0,0],'Color',vcol1(7,:),'LineStyle',':')
else
 ang=2*pi*linspace(0,1,400); circ=cos(ang)+j*sin(ang);
 plot(circ,'Color',vcol1(7,:),'LineStyle',':')
 plot([0,0],[VV(3),VV(4)],'Color',vcol1(7,:),'LineStyle',':')
 plot([VV(1),VV(2)],[0,0],'Color',vcol1(7,:),'LineStyle',':')
end
men_gr=uimenu(nfig,'Label','Reticoli');
uimenu(men_gr,'Label','Reticolo on/off','Callback','grid');
uimenu(men_gr,'Label','Luoghi a delta costante on/off',...
'Callback','gridmng(5)');
men_zoom=uimenu(nfig,'Label','Zoom on/off','Callback','rootlaux(2)');
if islegen
 for kk=1:nargs
  ha=plot(0,0,'Color',vcol1(kk,:),'LineStyle','-');
  HALEG=[HALEG,ha];
 end
end
if legen==1, eval(['legend(HALEG,',LABLEG,',3)']), end
figure(nfig), hold off, ABIL=1;
xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
cc=get(0,'Children');
if any(cc==nfig)
 FIGLO(10,1:4)=get(nfig,'Position');
 save figlo# FIGLO -v4
 zoom off, zoom out
else
 disp(' '), disp(['   ',EA,' STATA CANCELLATA LA FIGURA!']), figure, ordf(1)
end
if length(HA)>0
 for kk=1:length(HA), eval('delete(HA(kk))','err=1;'), end
 HA=[]; gridmng(5)
end
eval('delete(men_gr)','err=1;'), eval('delete(men_zoom)','err=1;'), ordf(1)
% --- last line of zpplots ---
