function wplane(arg1,arg2,arg3,arg4)
%WPLANE   Conversione diretta e inversa al piano w (TFI).
%   WPLANE,gi,gj - da TFI [WPLANE('gi,'gj') - da Matlab] trasforma la
%   f.d.t. a tempo discreto gi nella f.d.t. a tempo continuo gj
%   secondo l'equivalenza al piano w, o la f.d.t. a tempo continuo gi
%   nella f.d.t. a tempo discreto gj secondo l'inversa dell'equivalenza
%   al piano w:
%
%           1 + wT/2          2 (z - 1)
%      z =  --------  ;  w =  ---------  .
%           1 - wT/2          T (z + 1)
%
%   Se WPLANE viene chiamato senza alcun argomento, le f.d.t. gi e gj
%   possono essere specificate in modo interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

eA=setstr(232);
if nargin==0
 flg=0;
 while flg==0
  gi=input('\n   funzione di trasferimento gi (ingresso) : ','s');
  if ~isempty(gi)
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1;
   end
  end
 end
 while flg==1
  gj=input('\n   funzione di trasferimento gj (uscita) : ','s');
  if ~isempty(gj)
   flg=2;
  end
 end
elseif nargin>=2
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1; gj=arg2;
 end
else
 disp(' **** errore: numero di argomenti non sufficiente'), return
end
[z,p,k,str]=exportf(gi,1); if isempty(k), return, end
if length(z)>length(p)
 disp([' **** errore: m > n in ',gi]), return
end
T=lsamp;
if strcmp(str,'s')
 fprintf('\n   trasformazione dal continuo al discreto secondo la conversione')
 fprintf('\n   al piano w inversa; il tempo di campionamento assunto ')
 fprintf([eA,' %.4g sec\n'],T)
 [zrd,prd,krd]=inwplane(z,p,k,T);
 aa=importf(zrd,prd,krd,gj,1);
else
 fprintf('\n   trasformazione dal discreto al continuo secondo la conversione')
 fprintf('\n   al piano w diretta; il tempo di campionamento assunto ')
 fprintf([eA,' %.4g sec\n'],T)
 [zr,pr,kr]=diwplane(z,p,k,T);
 aa=importf(zr,pr,kr,gj);
end
if aa==1, tfg(gj), end
% --- last line of wplane ---
