function [out1,out2]=trespd(z,p,k,arg4,arg5,arg6)
%TRESPD   Impulse response of a discrete-time system.
%   TRESPD(zd,pd,kd,[col]) provides a plot of the impulse response function
%   versus discrete time with automatic scaling.
%   TRESPD(zd,pd,kd,k1,[col]) or TRESPD(zd,pd,kd,T,t1,[col]) provides a
%   plot of the impulse response function in the time interval
%   0 <= k <= k1 or 0 <= t <= t1 with automatic y-axis scaling.
%   Parameter col (optional) defines color of plot; col must be a string
%   variable ('g'=green, 'b'=blue, 'r'=red, 'y'=yellow, 'c'=cyan,
%   'm'=magenta); default is col='g'.
%   External definition of axes is possible with "axis([0,k1,ym,yM])"
%   or "axis([0,t1,ym,yM])" or with the "hold on" statement.
%   [y,k]=TRESPD( ... ) provides output for external use.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global HALEG

nargs=nargin;
error(nargchk(3,6,nargs));
flt=0; xx=2; col='g-';
if nargs==4
 if ~isstr(arg4)
  k1=arg4; xx=3;
 else
  if length(arg4)==1, col=[arg4,'-']; else, col=arg4; end
 end
elseif nargs==5;
 if ~isstr(arg5)
  T=arg4; t1=arg5; flt=1; xx=4;
 else
  k1=arg4;
  if length(arg5)==1, col=[arg5,'-']; else, col=arg5; end
  xx=3;
 end
elseif nargs==6
 T=arg4; t1=arg5;
 if length(arg6)==1, col=[arg6,'-']; else, col=arg6; end
 flt=1; xx=4;
end
%
[num,den]=dezpk(z,p,k);
%
YY=axis; s1=get(gca,'XLimMode');
if ishold | strcmp(s1,'manual')
 if YY(2)<0
  return
 else
  k1=YY(2);
  if flt==1
   k1=YY(2)/T;
  end
 end
else
 if xx==2
  if isempty(p)
   k1=10;
  else
   pd=p(find(p~=0)); npo=length(p)-length(pd); p1=log(pd);
   tol=10^(-4)*max(abs(p1)); ii=find(abs(p1)>tol);
   if isempty(ii)
    k1=10;
   else
    p1=p1(ii); pr=abs(real(p1)); pi=abs(imag(p1));
    pir=pi./(pr+10^(-8)); pi=pi(find(pir>.1));
    pr=pr(find(pr>tol)); pi=pi(find(pi>tol)); sig=min([pr;pi]); tt=8/sig+npo;
    vv=log10([1,1.2,1.6,2,2.5,3,4,5,8,10]);
    uu=log10(tt); uu1=floor(uu); uu2=uu-uu1;
    [ww,ii]=min(abs(vv-uu2)); k1=10^(uu1+vv(ii));
   end
  end
 elseif xx==4
  k1=t1/T;
 end
end
%
if k1>601; k1=601; end
%
k0=0; k=k0:1:k1; nk=length(k);
%
ttt=[zeros(1,length(den)-length(num)),num];
y=filter(ttt,den,[1,zeros(1,nk-1)]);
%
ks=zeros(1,2*nk-1); ys=zeros(1,2*nk-1); in=1;
ks(1)=k(1); ys(1)=y(1);
for kk=1:nk-1
 in=in+1; ks(in)=k(kk+1); ys(in)=y(kk); in=in+1;
 ks(in)=k(kk+1); ys(in)=y(kk+1);
end
%
[col1,col2,sty]=coltbl(col);
if flt==0
 ha=plot(ks,ys,col,'Color',col1,'LineStyle',sty); HALEG=[HALEG,ha];
 VV=axis; xtick=get(gca,'XTick'); lti=xtick(2)-xtick(1);
 xtick=VV(1):lti:VV(2); set(gca,'XTick',xtick)
 set(gca,'Xlim',[k0,k1]);
 if ishold | ~strcmp(s1,'auto')
  axis(YY)
 end
 if ~ishold
  title('risposta nel tempo (discreto)')
  aat=setstr(32*ones(1,120)); aam=sprintf('numero di campioni');
  mess=[aat(1:120-length(aam)),aam]; xlabel(mess)
 end
else
 ha=plot(ks*T,ys,col,'Color',col1,'LineStyle',sty); HALEG=[HALEG,ha];
 VV=axis; xtick=get(gca,'XTick'); lti=xtick(2)-xtick(1);
 xtick=VV(1):lti:VV(2); set(gca,'XTick',xtick)
 set(gca,'Xlim',[k0,k1]*T);
 if ishold | ~strcmp(s1,'auto')
  axis(YY)
 end
 if ~ishold
  title('risposta nel tempo')
  aat=setstr(32*ones(1,120)); aam=sprintf('secondi');
  mess=[aat(1:100-length(aam)),aam]; xlabel(mess)
 end
end
if nargout==0
 disp(' '), figure(gcf), return
end
out1=y; out2=k;
% --- last line of trespd ---
