function [out1,out2]=trespc(z,p,k,arg4,arg5)
%TRESPC   Impulse response of a continuous-time system.
%   TRESPC(z,p,k,[col]) provides a plot of the impulse response function
%   versus time with automatic scaling.
%   TRESPC(z,p,k,t1,[col]) provides a plot of the impulse response function
%   in the time interval 0 <= t <= t1 with automatic y-axis scaling.
%   Parameter col (optional) defines color of plot; col must be a string
%   variable ('g'=green, 'b'=blue, 'r'=red, 'y'=yellow, 'c'=cyan,
%   'm'=magenta); default is col='g'.
%   External definition of axes is possible with "axis([0,t1,ym,yM])".
%   [y,t]=TRESPC( ... ) provides output for external use.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global NPKK HALEG

if isempty(NPKK)|nargout==0, NPKK=0; end
nargs=nargin;
error(nargchk(3,5,nargs));
xx=2;
if nargs==3
 col='g-';
elseif nargs==4
 if isstr(arg4)
  if length(arg4)==1, col=[arg4,'-']; else, col=arg4; end
 else
  col='g-'; t1=arg4; xx=3;
 end
else
 t1=arg4; col=arg5; xx=3;
end
%
[a,b,c,d]=jorcf(z,p,k);
%
YY=axis; s1=get(gca,'XLimMode');
if ishold | strcmp(s1,'manual')
 if YY(2)<0
  return
 else
  t1=YY(2);
 end
else
 if xx==2
  tol=10^(-4)*max(abs(p)); ii=find(abs(p)>tol);
  if isempty(ii)
   t1=10;
  else
   p1=p(ii); pr=abs(real(p1)); pi=abs(imag(p1));
   pir=pi./(pr+10^(-8)); pi=pi(find(pir>.1));
   pr=pr(find(pr>tol)); pi=pi(find(pi>tol)); sig=min([pr;pi]); tt=8/sig;
   vv=log10([1,1.2,1.6,2,2.5,3,4,5,8,10]);
   uu=log10(tt); uu1=floor(uu); uu2=uu-uu1;
   [ww,ii]=min(abs(vv-uu2)); t1=10^(uu1+vv(ii))-10^(-8);
  end
 end
end
%
nt=601; t0=0; dt=(t1-t0)/(nt-1); t=t0:dt:t1;
ad=expm(a*dt); u=zeros(nt,1);
if length(ad) > 0
 x=ltitr(ad,b,u,b); y=c*x.';
else
 y=zeros(1,nt);
end
%
[col1,col2,sty]=coltbl(col);
ha=plot(t,y,'Color',col1,'LineStyle',sty); HALEG=[HALEG,ha];
if d~=0
 NPKK=NPKK+1;
 mess=sprintf('(oltre un impulso di Dirac in t=0; valore: %.4g)',d);
 xxt=.08; yyt=.04*NPKK;
 wfont='normal'; % wfont='bold';
 ha=text(xxt,yyt,mess,'Units','normalized','FontWeight',wfont);
 set(ha,'Color',col2)
end
VV=axis; xtick=get(gca,'XTick'); lti=xtick(2)-xtick(1);
xtick=VV(1):lti:VV(2); set(gca,'XTick',xtick)
set(gca,'Xlim',[t0,t1]);
if ishold | ~strcmp(s1,'auto')
 axis(YY)
end
if ~ishold
 title('risposta nel tempo')
 aat=setstr(32*ones(1,120)); aam=sprintf('secondi');
 mess=[aat(1:100-length(aam)),aam]; xlabel(mess)
end
if nargout==0
 disp(' '), figure(gcf), return
end
out1=y; out2=t;
% --- last line of trespc ---
