function tresp(arg1,arg2,arg3,arg4)
%TRESP	  Risposta nel tempo (TFI).
%   TRESP,gi - da TFI [TRESP('gi') - da Matlab] fornisce un grafico della
%   risposta nel tempo corrispondente alla f.d.t. gi.
%   Possibili opzioni:
%      1 - risposta al gradino ad anello aperto
%      2 - risposta al gradino ad anello chiuso
%      3 - risposta all'impulso ad anello aperto
%      4 - risposta all'impulso ad anello chiuso
%   Se TRESP viene chiamato senza alcun argomento, la f.d.t. gi puo'
%   essere specificata in interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global ABIL TRF1 TRF2 TRF3 TRF4 TRF5 TRF5 TRF6 TRF7 NPKK gr VV0 VV...
 HALEG FIGLEG LABLEG SUBPLEG

eA=setstr(232); oA=setstr(242); uA=setstr(249); EA=setstr(200);
nfig=gcf; nfigs=int2str(nfig); fluic=0; NPKK=0; ind=0;
FIGLEG=nfig; HALEG=[]; LABLEG=[]; SUBPLEG=0; FIGLO=resfiglo;
ms1=['\n **** errore: non si pu',oA,' cambiare figura durante l''esecuzione\n'];
ms2='   premere un tasto per proseguire';
if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
if nargin>0
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1;
 end
end
framesc=get(0,'DefaultFigureColor');
clf, ordf(3), set(gcf,'Color',framesc), VFULL=get(gcf,'Position');
SC=diag([1/VFULL(3);1/VFULL(4);1/VFULL(3);1/VFULL(4)]);
if any(FIGLO(2,:))
 erx=0; eval('set(nfig,''Position'',FIGLO(2,1:4))','erx=1;')
end
set(0,'DefaultUIControlUnits','normalized')
%
%  TOP MENU
%
men_opt=uimenu(nfig,'Label','Memo');
mess='risposta nel tempo';
uimenu(men_opt,'Label',mess);
men_time=uimenu(gcf,'Label','Asse tempi');
uimenu(men_time,'Label','ingrandire x 2',...
'Callback','gridmng(25)');
uimenu(men_time,'Label','ingrandire x 5','Separator','on',...
'Callback','gridmng(26)');
uimenu(men_time,'Label','ingrandire x 10','Separator','on',...
'Callback','gridmng(27)');
uimenu(men_time,'Label','ripristinare la scala iniziale','Separator','on',...
'Callback','gridmng(28)');
men_gr=uimenu(nfig,'Label','Reticolo on/off','Callback','gridmng(1)');
men_zoom=uimenu(nfig,'Label','Zoom on/off','Callback','gridmng(11)');
%
pbs=zeros(1,20);
[tp1,tp2,ccol,ccols]=coltbl;
colbg=tp1(8,:);
oran1=tp1(9,:);
oran2=tp2(9,:);
BB=VFULL(4)-16;
Pos=[10 BB 400 15]*SC;
pbs(1)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'Visible','off');
%
llth=110;
AA=VFULL(3)-llth-4; BB=VFULL(4)-16;
for kk=2:10
 Pos=[AA BB-15*(kk-2) llth 15]*SC;
 pbs(kk)=uicontrol(gcf,...
 'Style','text',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'BackgroundColor',colbg,...
 'Visible','off');
end
%
Pos=[10 5 400 15]*SC;
pbs(20)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'ForegroundColor',oran2,...
'Visible','off',...
'String','PREMERE INVIO PER IL MENU');
%
flg=0; izz=-1; flgd1=0; flgd2=0; ab=0;
cfl=0; gr=0; cd=0; err=0; ncall=0;
iiq=0; iitf=0;
vectc=[]; vstr=[]; vresp=[];
vectg=[]; gnum=[]; gn=0; vecttc=[];
while flg==0
 if (nargin==0)|(izz==2)
  flg1=0; ind=1;
  while flg1==0
   gi=[];
   while isempty(gi)
    gi=input('\n   specificare la funzione di trasferimento : ','s');
    if isempty(get(0,'children')), return, end
    if gcf~=nfig, fprintf(ms1), return, end
   end
   if gi=='0', ordf(1), return, end
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste']), err=1;
   else
    err=0;
   end
   if err==0
    [zc,pc,kc,strc,tc]=exportf(gi,2); if isempty(kc), ordf(1), return, end
    if (strc=='z')&(tc==0), tc=lsamp; end
    if strcmp(strc,'s')&(cd==1)
     fprintf('\n **** errore: conflitto fra tempo continuo e discreto')
     fprintf('\n              convertire l''asse tempi con l''opzione 7\n')
     disp(' ')
     disp(ms2), pause, hold off
     cfl=1;
    else
     z=zc; p=pc; k=kc; str=strc;
    end
    flg1=1;
   end
  end
 elseif (nargin>0)&(izz<0)
  [z,p,k,str,tc]=exportf(gi,2); if isempty(k), ordf(1), return, end
  if (str=='z')&(tc==0), tc=lsamp; end
 end
 if (length(z)>1000)|(length(p)>1000)
  disp([' **** errore: m or n > 1000 in ',gi]), ordf(1), return
 end
 if cfl==0
  n=0;
  while (n~=1)&(n~=2)&(n~=3)&(n~=4)
   clc
   fprintf('\n   1 - risposta al gradino ad anello aperto')
   fprintf('\n   2 - risposta al gradino ad anello chiuso')
   fprintf('\n   3 - risposta all''impulso ad anello aperto')
   fprintf('\n   4 - risposta all''impulso ad anello chiuso\n')
   n=input('\n   operare una scelta (default 1, 0 per uscire) : ');
   if isempty(n), n=1; end
   if n==0, ordf(1), return, end
   if isempty(get(0,'children')), return, end
   if gcf~=nfig, fprintf(ms1), return, end
  end
  if n==1
   mess1=', al gradino ad anello aperto, ';
  elseif n==2
   mess1=', al gradino ad anello chiuso, ';
  elseif n==3
   mess1=', all''impulso ad anello aperto, ';
  elseif n==4
   mess1=', all''impulso ad anello chiuso, ';
  end
  iitf=iitf+1;
  eval(['vectz',int2str(iitf),'=z;'])
  eval(['vectp',int2str(iitf),'=p;'])
  eval(['vectk',int2str(iitf),'=k;'])
  vectg=[vectg,gi]; gnum=[gnum;length(gi)];
  vstr=[vstr;str]; vresp=[vresp;n]; vecttc=[vecttc;tc];
  flg1=0;
  while flg1==0
   ins=[ccol(7),'=',deblank(ccols(7,:)),','];
   fprintf(['\n   scegliere il colore del grafico: ',ins,' g=verde,'])
 mest='\n   b=blu, r=rosso, y=giallo, m=magenta, c=celeste, default verde : ';
   c=input(mest,'s');
   if isempty(c), c='g'; end
   c=c(1); if strcmp(c,'0'), ordf(1), return, end
   if isempty(get(0,'children')), return, end
   if gcf~=nfig, fprintf(ms1), return, end
   if isempty(vectc)
    rop=0; for kk=1:7, rop=rop|(c==ccol(kk)); end
    if rop, flg1=1; end
   else
    rop=0;
    for kk=1:7
     rop=rop|((c==ccol(kk))&isempty(find(vectc==ccol(kk))));
    end
    if rop, flg1=1; end
   end
  end
  vectc=[vectc;c];
  mess=[gi,mess1,' colore ',c];
  eval(['TRF',int2str(iitf),'=[gi,c];'])
  if fluic==0
   fluic=1;
   uimenu(men_opt,'Label',mess,'Separator','on',...
   'Callback',['tfmaux(',int2str(iitf),',1,0)']);
  else
   uimenu(men_opt,'Label',mess,...
   'Callback',['tfmaux(',int2str(iitf),',1,0)']);
  end
  ABIL=1;
 else
  flg1=1;
 end
 while flg1==1
  if cfl==0
   if (n==2)|(n==4)
    [num,den]=dezpk(z,p,k); dens=sumpol(num,den); [z,p,k]=tozpk(num,dens);
   end
   if (n==1)|(n==2)
    if str=='s'
     p=[p;0];
    else
     z=[z;0]; p=[p;1];
    end
   end
   rop=(izz==2)&strcmp(str,'z')&(cd==0);
   rop1=((izz==5)|(izz==6))&strcmp(str,'z')&(cd==0);
   rop2=(izz==2)&strcmp(str,'z')&(cd==1);
   rop3=((izz==5)|(izz==6))&strcmp(str,'z')&(cd==1);
   if length(z)>length(p)
    disp(' ')
    disp(['   **** grado relativo negativo in ',gi]), ordf(1), return
   end
   if rop|rop1
    [y,kt]=eval('trespd(z,p,k,tc,VV(2),c)');
   elseif rop2|rop3
    [y,kt]=eval('trespd(z,p,k,VV(2),c)');
   else
    if strcmp(str,'z')
     [y,kt]=eval('trespd(z,p,k,c)'); cd=1;
    else
     [y,kt]=eval('trespc(z,p,k,c)');
    end
    if ncall==0
     VV=axis;
     % correcting a Matlab auto axis bug
     tol=(VV(4)-VV(3))/400; ymin=min(y); yt=get(gca,'Ytick');
     if ymin>yt(2)-tol, VV(3)=yt(2); axis(VV), end
     ncall=1;
    end
   end
   if izz==6
    xtick=get(gca,'XTick'); ytick=get(gca,'YTick');
    divx=xtick(2)-xtick(1); divy=ytick(2)-ytick(1);
    if flgd1==1
     stepx=(VV(2)-VV(1))/ndiv(1);
    else
     stepx=divx;
    end
    xtick=VV(1):stepx:VV(2); set(gca,'XTick',xtick)
    if flgd2==1
     stepy=(VV(4)-VV(3))/ndiv(2);
    else
     stepy=divy;
    end
    ytick=VV(3):stepy:VV(4); set(gca,'YTick',ytick)
   end
   VV0=axis;
   if islegen
    if gn==0
     if length(gnum)==1
      LABLEG=['''',vectg,''''];
     else
      LABLEG=[LABLEG,',''',...
      vectg(sum(gnum(1:length(gnum)-1))+1:sum(gnum)),''''];
     end
    end
    if legen==1, eval(['legend(HALEG,',LABLEG,',4)']), end
   end
   iiq=iiq+1;
   eval(['vecty',int2str(iiq),'=y;'])
   eval(['vectkt',int2str(iiq),'=kt;'])
   rop=((izz==5)|(izz==6))&(ind<length(vectc));
   rop1=(izz==2)&(ind>1)&(ind<length(vectc));
   if rop|rop1
    ind=ind+1; flg2=1; % izz=2;
    eval(['z=vectz',int2str(ind),';'])
    eval(['p=vectp',int2str(ind),';'])
    eval(['k=vectk',int2str(ind),';'])
    str=vstr(ind); c=vectc(ind); n=vresp(ind); tc=vecttc(ind); hold on
   else
    if izz==2
     ymin=min([y,VV(3)]); ymax=max([y,VV(4)]); tol=(ymax-ymin)/400;
     yt=get(gca,'Ytick');
     dyt=yt(2)-yt(1);
     flgg=0;
     while ymax-ymin>32*dyt, dyt=10*dyt; flgg=1; end
     if flgg==1, yt=round((ymax+ymin)/(2*dyt))*dyt; end
     while ymin<yt(1)-tol, yt=[yt(1)-dyt,yt]; end
     while ymax>yt(length(yt))+tol, yt=[yt,yt(length(yt))+dyt]; end
     VV(3)=yt(1); VV(4)=yt(length(yt)); ndiv(2)=length(yt)-1; flgd2=1;
     axis(VV); set(gca,'Ytick',yt), VV0(3)=VV(3); VV0(4)=VV(4);
    end
    if izz>0
     hold off
    end
    gn=0; flg2=0; ind=1;
    if gr==1, grid on, end
    figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   end
  else
   cfl=0; flg2=0;
  end
  while flg2==0
   clc
   disp(' ')
   disp('   MENU :')
   disp(' ')
   disp('   1 - cambiare gli assi di riferimento')
   if gr==0
    disp('   2 - inserire reticolo')
   else
    disp('   2 - eliminare il reticolo')
   end
   disp('   3 - informazioni (solo sulla risposta al gradino)')
   disp('   4 - aggiungere un grafico in colore diverso')
   disp('   5 - rivedere la figura')
   disp('   6 - informazioni sui grafici con il mouse')
   if length(find(vstr=='s'))==0
    disp('   7 - cambiare l''asse tempi da continuo a discreto o viceversa')
    menupointer=[6,3,7,2,4,1,5];
   else
    menupointer=[6,3,7,2,4,1];
   end
   rpp=length(find((vresp==1)|(vresp==2)));
   zoom out, zoom off, axis(VV)
   izz=input('\n   operare una scelta (premere invio per uscire) : ');
   if isempty(get(0,'children')), return, end
   if gcf~=nfig, fprintf(ms1), return, end
   if isempty(izz)
    for kk=1:10
     eval('set(pbs(kk),''Visible'',''off'')','err=1;')
    end
    cc=get(0,'Children');
    if any(cc==nfig)
     FIGLO(2,1:4)=get(nfig,'Position');
     save figlo# FIGLO -v4
    else
     disp(' '), disp(['   LA FIGURA ',EA,' STATA CANCELLATA!'])
    end
    set(0,'DefaultUIControlUnits','pixel')
    eval('delete(men_zoom)','err=1;'), eval('delete(men_gr)','err=1;')
    eval('delete(men_time)','err=1;'), ordf(1), return
   end
   if izz==3 & rpp==0
    fprintf('\n **** errore: non si tratta di risposta al gradino\n\n')
    disp(ms2), pause, izz=-1;
   end
   izz=floor(izz); lpointer=length(menupointer);
   if (izz>=1) & (izz<=lpointer)
    izz=menupointer(izz);
   else
    izz=-1;
   end
   if izz==1
    ab=1;
    xyx=input('\n   **** premere invio per abilitare la selezione ','s');
    set(gcf,'Color',colbg)
    title('')
    set(men_opt,'Enable','off')
    set(men_time,'Enable','off')
    set(men_gr,'Enable','off')
    set(men_zoom,'Enable','off')
    mess='Scegliere punti con il mouse (pulsante 1, pulsante 2 per uscire)';
    set(pbs(1),'ForegroundColor',oran2,'Visible','on','String',mess)
    bb=1; hh=0; axis(VV), hold on
    while bb==1
     [x1s,y1s,bb]=ginput(1);
     if isempty(bb), bb=2; end
     if bb==1
      t1=x1s; y1=y1s;
      if hh~=0, delete(ha), end
      ha=plot([t1 t1],[VV(3) VV(4)],'Color',oran1,'LineStyle','-',...
      'LineWidth',2);
      if t1<VV(1), t1=VV(1); end
      if t1>VV(2), t1=VV(2)+10^(-8); end
      for kk=1:length(vectc)
       kks=int2str(kk);
       eval(['kt=vectkt',kks,';']), eval(['yt=vecty',kks,';'])
       if vstr(kk)=='s'
	ii=length(find(kt<t1)); if ii==0, ii=1; end
	tt=kt(ii); yy=yt(ii);
	lt=length(kt); if ii==lt, ii=lt-1; end
	tt1=kt(ii+1); yy1=yt(ii+1);
	dtt=tt1-tt; dyy=yy1-yy;
	if dtt~=0, yy=yy+(t1-tt)*dyy/dtt; end
	if abs(yy)<10^(-8), yy=0; end
       else
	if cd==1
	 t1d=fix(t1); asc='k';
	else
	 t1d=fix(t1/vecttc(kk));
	end
	t1c=fix(t1/lsamp);
	[zz,ii]=min(abs(t1d-kt));
	tt=kt(ii); yy=yt(ii);
       end
       [tp1,tbl,tp2]=coltbl(vectc(kk));
       mess=sprintf('y=%.3g',yy);
       if vstr(kk)=='z'
	mess=[mess,sprintf(', k=%.3g',t1d)];
       end
       set(pbs(kk+1),'ForegroundColor',tbl,'Visible','on','String',mess)
      end % for kk
      kk=kk+1;
      if cd==0
       mess=sprintf('t=%.3g sec',t1);
      else
       mess=sprintf('k=%.3g camp',t1d);
      end
      set(pbs(kk+1),'ForegroundColor',oran2,'Visible','on','String',mess)
      if (cd==0)&(any(vstr=='z'))
       mess=sprintf('kc=%.3g camp',t1c); kk=kk+1;
      end
      set(pbs(kk+1),'ForegroundColor',oran2,'Visible','on','String',mess)
     else
      for rr=1:kk+1
       set(pbs(rr),'Visible','off')
      end
      set(pbs(20),'Visible','on')
      if hh~=0, delete(ha), end
      hold off
     end % if bb
     hh=1;
    end % while
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
    eval('set(men_opt,''Enable'',''on'')','err=1;')
    eval('set(men_time,''Enable'',''on'')','err=1;')
    eval('set(men_gr,''Enable'',''on'')','err=1;')
    eval('set(men_zoom,''Enable'',''on'')','err=1;')
    if cd==0
     title('risposta nel tempo')
    else
     title('risposta nel tempo (discreto)')
    end
    eval('set(pbs(20),''Visible'',''off'')','err=1;')
    set(gcf,'Color',framesc)
   elseif izz==2
    if length(vectc)<7
     hold on, flg1=2; flg2=1;
    else
     fprintf(['\n   il numero massimo di grafici ',eA,' sette']), pause
    end
   elseif izz==3
    if gr==0
     gr=1; grid on
    else
     gr=0; grid off
    end
    figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   elseif izz==4
    figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   elseif izz==5
    gn=1; T=lsamp;
    if cd==0
     VV(1)=VV(1)/T; VV(2)=VV(2)/T; cd=1;
     VV0(1)=VV0(1)/T; VV0(2)=VV0(2)/T;
    else
     VV(1)=VV(1)*T; VV(2)=VV(2)*T; cd=0;
     VV0(1)=VV0(1)*T; VV0(2)=VV0(2)*T;
    end
    eval(['z=vectz',int2str(1),';'])
    eval(['p=vectp',int2str(1),';'])
    eval(['k=vectk',int2str(1),';'])
    str=vstr(1); c=vectc(1); n=vresp(1); tc=vecttc(1);
    iiq=0; axis(VV); flg2=1; HALEG=[];
   elseif izz==6
    clc, gn=1; % T=lsamp;
    xtick=get(gca,'XTick'); ytick=get(gca,'YTick');
    divx=xtick(2)-xtick(1); divy=ytick(2)-ytick(1);
    ndiv=round([(VV(2)-VV(1))/divx,(VV(4)-VV(3))/divy]);
    disp(' ')
    if cd==0
     fprintf(['   l''intervallo di tempo ',eA,' [%.4g %.4g];'],VV(1),VV(2))
     indin=0; while indin==0
     TA1=input('\n   premere invio o specificare nuovi valori: [t1 t2] = ');
     ll1=length(TA1); if (ll1==0)|(ll1==2), indin=1; end, end, TA1=sort(TA1);
    else
     fprintf(['   l''intervallo di campioni ',eA,' [%.4g %.4g];'],VV(1),VV(2))
     indin=0; while indin==0
     TA1=input('\n   premere invio o specificare nuovi valori: [k1 k2] = ');
     ll1=length(TA1); if (ll1==0)|(ll1==2), indin=1; end, end, TA1=sort(TA1);
    end
    fprintf('   numero di divisioni dell''asse x: %.4g;',ndiv(1))
    if ll1~=0
     fprintf('\n   premere invio per la messa in scala automatica')
    else
     fprintf('\n   premere invio per conservare la scala precedente')
    end
    indin=0; while indin==0
    ndivt1=input('\n   o specificare un nuovo valore: ndx = ');
    if (length(ndivt1)==0)|(length(ndivt1)==1), indin=1; end, end
    fprintf(['\n   l''intervallo dell''asse y ',eA,' [%.4g %.4g];'],VV(3),VV(4))
    indin=0; while indin==0
    TA2=input('\n   premere invio o specificare nuovi valori: [ym yM] = ');
    ll2=length(TA2); if (ll2==0)|(ll2==2), indin=1; end, end, TA2=sort(TA2);
    fprintf('   numero di divisioni dell''asse y: %.4g;',ndiv(2))
    if ll2~=0
     fprintf('\n   premere invio per la messa in scala automatica')
    else
     fprintf('\n   premere invio per conservare la scala precedente')
    end
    indin=0; while indin==0
    ndivt2=input('\n   o specificare un nuovo valore: ndy = ');
    if (length(ndivt2)==0)|(length(ndivt2)==1), indin=1; end, end
    rp1=(length(ndivt1)~=0)|((flgd1==1)&(ll1==0));
    if rp1, flgd1=1; else, flgd1=0; end
    rp2=(length(ndivt2)~=0)|((flgd2==1)&(ll2==0));
    if rp2, flgd2=1; else, flgd2=0; end
    if length(ndivt1)~=0, ndiv(1)=round(abs(ndivt1)); end
    if length(ndivt2)~=0, ndiv(2)=round(abs(ndivt2)); end
    if ll1~=0, VV(1)=TA1(1); VV(2)=TA1(2)+eps; end
    if ll2~=0, VV(3)=TA2(1); VV(4)=TA2(2)+eps; end
    if isempty(get(0,'children')), return, end
    if gcf~=nfig, fprintf(ms1), return, end
    eval(['z=vectz',int2str(1),';'])
    eval(['p=vectp',int2str(1),';'])
    eval(['k=vectk',int2str(1),';'])
    str=vstr(1); c=vectc(1); n=vresp(1); tc=vecttc(1);
    iiq=0; axis(VV); flg2=1; HALEG=[]; NPKK=0; VV0=VV;
   elseif izz==7
    clc
    if length(vectc)>1
     xx=0;
     while xx==0
      col=input('\n   scegliere la funzione specificandone il colore : ','s');
      if isempty(col), col='z'; end
      if col=='0', ordf(1), return, end
      if isempty(get(0,'children')), return, end
      if gcf~=nfig, fprintf(ms1), return, end
      ropc=0; for kk=1:7, ropc=ropc|strcmp(col,ccol(kk)); end
      if ropc
       if length(find(vectc==col))>0
	if (vresp(find(vectc==col))~=1) & (vresp(find(vectc==col))~=2)
	 fprintf('\n **** errore: non si tratta di risposta al gradino\n')
	else
	 xx=1;
	end
       end
      end
     end
    else
     col=c;
    end
    q=find(vectc==col);
    eval(['zc=vectz',int2str(q),';'])
    eval(['pc=vectp',int2str(q),';'])
    eval(['kc=vectk',int2str(q),';'])
    eval(['y=vecty',int2str(q),';'])
    eval(['kt=vectkt',int2str(q),';'])
    strc=vstr(q); nc=vresp(q); tc=vecttc(q);
    zs=zc; ps=pc; ks=kc; [nums,dens]=dezpk(zs,ps,ks); zw=zc; pw=pc; kw=kc;
    if (nc==2)|(nc==4)
     dens=sumpol(nums,dens); [zs,ps,ks]=tozpk(nums,dens); zw=zs; pw=ps; kw=ks;
    end
    if (nc==1)|(nc==2)
     if strc=='s'
      pw=[pw;0];
     else
      zw=[zw;0]; pw=[pw;1];
     end
    end
    ys=y; kts=kt; lt=length(kts);
    disp(' ')
    disp('   RISPOSTA AL GRADINO :')
    if strcmp(strc,'s')  % continuous-time
     hh=find(abs(zs)<10^(-8)); ii=find(abs(ps)<10^(-8));
     if length(ii)~=0 | length(hh)~=0
    disp('   guadagno statico infinito o nullo: informazione non disponibile')
     else
      gain0=polyval(nums,0)/polyval(dens,0); ys=ys/gain0; yss=ys; tss=kts;
      [maov,ii]=max(ys);
      if ii==lt
       disp('   nessuna sovraelongazione')
      else
       tiov=kts(ii);
       if ii<40
	nt=401; t0=0; t1=2*tiov; dt=(t1-t0)/(nt-1); kts=t0:dt:t1;
	[a1,b1,c1,d1]=jorcf(zw,pw,kw); ad=expm(a1*dt); u=zeros(nt,1);
	if length(ad) > 0
	 x=ltitr(ad,b1,u,b1); ys=c1*x.';
	else
	 ys=zeros(1,nt);
	end
	ys=ys/gain0;
       end
       lt=length(kts); [maov,ii]=max(ys); tiov=kts(ii);
       if (ii~=lt)&(ii~=1)
	dy=ys(ii+1)-ys(ii-1); maov=maov+abs(dy/4); dt=kts(ii+1)-kts(ii);
	if ys(ii+1)>ys(ii-1)
	 tiov=tiov+(1-(ys(ii)-ys(ii+1))/(ys(ii)-ys(ii-1)))*dt/2;
	else
	 tiov=tiov-(1-(ys(ii)-ys(ii-1))/(ys(ii)-ys(ii+1)))*dt/2;
	end
       end
       maov=(maov-1)*100;
       fprintf('   massima sovraelongazione: %.4g percento',maov)
       fprintf(' per t=%.4g sec\n',tiov)
      end
      if max(ys)<.9
       mess='   tempi di ritardo e di salita non calcolabili: ';
       mess=[mess,'ingrandire la scala tempi']; disp(mess)
      else
       ii=find(ys>.5); iind=ii(1); ydd=ys(iind); tdd=kts(iind);
       if iind==1, iind=2; end
       dy=ys(iind)-ys(iind-1); dt=kts(iind)-kts(iind-1);
       tdd=tdd+(.5-ydd)*(dt/dy);
       fprintf('   tempo di ritardo (al 50 percento): %.4g sec\n',tdd)
       ii=find(ys>.1); iind=ii(1); yr1=ys(iind); tr1=kts(iind);
       if iind==1, iind=2; end
       dy=ys(iind)-ys(iind-1); dt=kts(iind)-kts(iind-1);
       tr1=tr1+(.1-yr1)*(dt/dy);
       ii=find(ys>.9); iind=ii(1); yr2=ys(iind); tr2=kts(iind);
       if iind==1, iind=2; end
       dy=ys(iind)-ys(iind-1); dt=kts(iind)-kts(iind-1);
       tr2=tr2+(.9-yr2)*(dt/dy);
       fprintf('   tempo di salita (dal 10 al 90 percento):')
       fprintf(' %.4g sec\n',tr2-tr1)
      end
      yy=abs(yss-1); lt=length(tss);
      ii=find(yy<.05); ii=[-1,ii]; li=length(ii);
      if yy(lt)>.05 | max(yy(lt-round(.1*lt):lt))>.08 | li>round(.98*lt)
       mess='   tempo di assestamento non calcolabile: ';
       mess=[mess,'modificare la scala tempi']; disp(mess)
      else
       for kk=1:li-1
	if ii(li-kk+1)~=ii(li-kk)+1
	 iind=ii(li-kk+1)-1; break
	end
       end
       yset=yy(iind); tset=tss(iind);
       dy=yy(iind+1)-yy(iind); dt=tss(iind+1)-tss(iind);
       tset=tset+(.05-yset)*(dt/dy);
       fprintf(['   tempo di assestamento (al pi',uA,'/meno 5 percento):'])
       fprintf(' %.4g sec\n',tset)
      end
     end
     if nc==2
      disp(' ')
      disp('   ERRORI A REGIME (SOLO AD ANELLO CHIUSO) :')
      num0=nums; den0=dens; numst=sumpol(den0,-num0); denst=den0;
      er0=polyval(numst,0)/polyval(denst,0);
      if abs(er0)<10^(-8), er0=0; end
      if er0==0
       numr=deconv(numst,[1 0]); denr=denst;
       er1=polyval(numr,0)/polyval(denr,0);
      else
       er1=10^31*sign(er0);
      end
      fprintf('   errore a regime in risposta al gradino: %.4g\n',er0)
      if er1>=10^30
       disp('   errore a regime in risposta alla rampa: infinito')
      elseif er1<-10^30
       disp('   errore a regime in risposta alla rampa: meno infinito')
      else
       fprintf('   errore a regime in risposta alla rampa: %.4g\n',er1)
      end
     end
    else  % discrete-time
     T=tc;
     hh=find(abs(zs-1)<10^(-8)); ii=find(abs(ps-1)<10^(-8));
     if length(ii)~=0 | length(hh)~=0
    disp('   guadagno statico infinito o nullo: informazione non disponibile')
     else
      gain0=polyval(nums,1)/polyval(dens,1); ys=ys/gain0; [maov,ii]=max(ys);
      if ii==lt
       disp('   nessuna sovraelongazione')
      else
       tiov=kts(ii); maov=(maov-1)*100;
       fprintf('   massima sovraelongazione: %.4g percento',maov)
       fprintf(' per k=%.4g camp',tiov)
       fprintf(' (t=%.4g sec)\n',T*tiov)
      end
      if max(ys)<.9
       mess='   tempi di ritardo e di salita non calcolabili: ';
       mess=[mess,'ingrandire la scala tempi']; disp(mess)
      else
       ii=find(ys>.5); iind=ii(1); tdd=kts(iind);
       fprintf('   tempo di ritardo (al 50 percento): %.4g camp',tdd)
       fprintf(' (%.4g sec)\n',T*tdd)
       ii=find(ys>.1); iind=ii(1); tr1=kts(iind);
       ii=find(ys>.9); iind=ii(1); tr2=kts(iind);
       fprintf('   tempo di salita (dal 10 al 90 percento):')
       fprintf(' %.4g camp',tr2-tr1)
       fprintf(' (%.4g sec)\n',T*(tr2-tr1))
      end
      yy=abs(ys-1);
      if yy(lt)>.05 | max(yy(lt-round(.1*lt):lt))>.08
       mess='   tempo di assestamento non calcolabile: ';
       mess=[mess,'ingrandire la scala tempi']; disp(mess)
      else
       ii=find(yy<.05); ii=[-1,ii]; li=length(ii);
       for kk=1:li-1
	if ii(li-kk+1)~=ii(li-kk)+1
	 iind=ii(li-kk+1); break
	end
       end
       tset=kts(iind);
       fprintf(['   tempo di assestamento (al pi',uA,'/meno 5 percento):'])
       fprintf(' %.4g camp',tset)
       fprintf(' (%.4g sec)\n',T*tset)
      end
     end
     if nc==2
      disp(' ')
      disp('   ERRORI A REGIME (SOLO AD ANELLO CHIUSO) :')
      num0=nums; den0=dens; numst=sumpol(den0,-num0); denst=den0;
      er0=polyval(numst,1)/polyval(denst,1);
      if abs(er0)<10^(-8), er0=0; end
      if er0==0
       numr=deconv(numst,[1 -1]); denr=denst;
       er1=polyval(numr,1)*T/polyval(denr,1);
       if abs(er1)<10^(-8), er1=0; end
      else
       er1=10^31*sign(er0);
      end
      fprintf('   errore a regime in risposta al gradino: %.4g\n',er0)
      if er1>=10^30
       disp('   errore a regime in risposta alla rampa: infinito')
      elseif er1<-10^30
       disp('   errore a regime in risposta alla rampa: meno infinito')
      else
       fprintf('   errore a regime in risposta alla rampa: %.4g\n',er1)
      end
     end
    end
    disp(' '), disp(ms2), pause
   end
  end
 end
end
% --- last line of tresp ---
