function [z,p,K]=tozpk(num,den,opt)
%TOZPK	  Converts a transfer function to zero-pole-gain.
%   [z,p,k] = TOZPK(num,den) finds the zeros, poles, and gain from
%   the numerator and denominator coefficients, given in vectors
%   num & den in descending powers of s :
%
%	  (s-z1)(s-z2)...(s-zn)   num(s)
%	k --------------------- = ------ .
%	  (s-p1)(s-p2)...(s-pn)   den(s)
%   NOTE: z & p are column vectors, while num & den are row vectors.
%   [z,p,k] = TOZPK(num,den,1) (called with three arguments) allows
%   for interactive selection of multiple poles and zeros within
%   a specified tolerance.
%   See DEZPK to convert the other way.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

error(nargchk(2,3,nargin)); aA=setstr(224);
zz=roots(num); pp=roots(den);
% Computing the gain
lnum=length(num); lden=length(den);
while num(lnum)==0
 lnum=lnum-1;
end
while den(lden)==0
 lden=lden-1;
end
K=num(lnum)/den(lden); zz1=zz(find(abs(zz))); pp1=pp(find(abs(pp)));
K=K*prod(-pp1)/prod(-zz1); K=real(K);
%
if nargin==3
 ss=0;
 if length(zz)==0; ss=1; end;
 while ss==0
  clc
  disp('   >>> Zeri <<<')
  disp(' ')
  zzz=1;
  for k=1:length(zz)
   if abs(imag(zz(k)))>10^(-4)
    fprintf('  %4.f    %+4.4e    %+4.4e * j',k,real(zz(k)),imag(zz(k)))
    fprintf('  %4.f\n',zzz)
   else
    fprintf('  %4.f    %+4.4e                    ',k,real(zz(k)))
    fprintf('  %4.f\n',zzz)
   end
  end % for
  tol=input('\n   specificare la tolleranza (default 10^(-4)) : ');
  if length(tol)==0
   tol=10^(-4);
  end
  [egv,mul]=makest(zz,tol,0);
% Rounds the multiple eigenvalues
  ii=find(mul>1);
  for kk=ii
   egv(kk)=tol*round(egv(kk)/tol);
  end
% Builds the conjugate eigenvalues
  ii=find(abs(imag(egv))>0);
  egv=[egv conj(egv(ii))];
  mul=[mul mul(ii)];
  disp(' ')
  disp(['   >>> Zeri con gli ordini di molteplicit',aA,' rilevati <<<'])
  disp(' ')
  for k=1:length(egv)
   if abs(imag(egv(k)))>0
    fprintf('  %4.f    %+4.4e    %+4.4e * j',k,real(egv(k)),imag(egv(k)))
    fprintf('  %4.f\n',mul(k))
   else
    fprintf('  %4.f    %+4.4e                    ',k,real(egv(k)))
    fprintf('  %4.f\n',mul(k))
   end
  end % for
  kzz=0;
  while kzz==0;
   kzz=1;
   ss=3;
   ss=input('\n   OK (1/0) ? : ');
   if length(ss)==0; kzz=0; end;
   rop=((ss~=1)&(ss~=0)); if rop; kzz=0; end;
  end
 end % while ss==0
 egvz=egv;
 mulz=mul;
 ss=0;
 if length(pp)==0; ss=1; end;
 while ss==0
  clc
  disp('   >>> Poli <<<')
  disp(' ')
  ppp=1;
  for k=1:length(pp)
   if abs(imag(pp(k)))>10^(-4)
    fprintf('  %4.f    %+4.4e    %+4.4e * j',k,real(pp(k)),imag(pp(k)))
    fprintf('  %4.f\n',ppp)
   else
    fprintf('  %4.f    %+4.4e                    ',k,real(pp(k)))
    fprintf('  %4.f\n',ppp)
   end
  end % for
  tol=input('\n   specificare la tolleranza (default 10^(-4)) : ');
  if length(tol)==0
   tol=10^(-4);
  end
  [egv,mul]=makest(pp,tol,0);
% Rounds the multiple eigenvalues
  ii=find(mul>1);
  for kk=ii
   egv(kk)=tol*round(egv(kk)/tol);
  end
% Builds the conjugate eigenvalues
  ii=find(abs(imag(egv))>0);
  egv=[egv conj(egv(ii))];
  mul=[mul mul(ii)];
  disp(' ')
  disp(['   >>> Poli con gli ordini di molteplicit',aA,' rilevati <<<'])
  disp(' ')
  for k=1:length(egv)
   if abs(imag(egv(k)))>0
    fprintf('  %4.f    %+4.4e    %+4.4e * j',k,real(egv(k)),imag(egv(k)))
    fprintf('  %4.f\n',mul(k))
   else
    fprintf('  %4.f    %+4.4e                    ',k,real(egv(k)))
    fprintf('  %4.f\n',mul(k))
   end
  end % for
  kzz=0;
  while kzz==0;
   kzz=1;
   ss=3;
   ss=input('\n   OK (1/0) ? : ');
   if length(ss)==0; kzz=0; end;
   rop=((ss~=1)&(ss~=0)); if rop; kzz=0; end;
  end
 end % while ss==0
 egvp=egv;
 mulp=mul;
else
 tol=10^(-4);  % tolerance for multiple roots
 [egv,mul]=makest(zz,tol,0);
% Rounds the multiple eigenvalues
 ii=find(mul>1);
 for kk=ii
  egv(kk)=tol*round(egv(kk)/tol);
 end
% Builds the conjugate eigenvalues
 ii=find(abs(imag(egv))>0);
 egv=[egv conj(egv(ii))];
 mul=[mul mul(ii)];
 egvz=egv;
 mulz=mul;
 [egv,mul]=makest(pp,tol,0);
% Rounds the multiple eigenvalues
 ii=find(mul>1);
 for kk=ii
  egv(kk)=tol*round(egv(kk)/tol);
 end
% Builds the conjugate eigenvalues
 ii=find(abs(imag(egv))>0);
 egv=[egv conj(egv(ii))];
 mul=[mul mul(ii)];
 egvp=egv;
 mulp=mul;
end
vv=[];
for i1=1:length(mulz)
 for i2=1:mulz(i1)
  if imag(egvz(i1))==0
   vv=[vv;egvz(i1)];
  elseif imag(egvz(i1))>0
   vv=[vv;egvz(i1);conj(egvz(i1))];
  end
 end
end
z=vv;
vv=[];
for i1=1:length(mulp)
 for i2=1:mulp(i1)
  if imag(egvp(i1))==0
   vv=[vv;egvp(i1)];
  elseif imag(egvp(i1))>0
   vv=[vv;egvp(i1);conj(egvp(i1))];
  end
 end
end
p=vv;
% --- last line of tozpk ---
