function tfmaux(arg1,arg2,arg3,arg4)
%TFMAUX   manages the uimenu display of transfer functions (TFI).
%    TFMAUX(no,vpos,[dir,type]), with the meaning:
%	no: the number of TRF referred to in global - TRFi is a string
%	    with the transfer function name and the color
%     vpos: the vertical position of the displayed transfer function,
%	    in absolute units
%      dir: the direction of display with respect to vpos, 1 up, 0 down,
%	    default is 1
%     type: if present, 1 factorized, 2 time-constant.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global ABIL TRF1 TRF2 TRF3 TRF4 TRF5 TRF5 TRF6 TRF7
if ABIL==0, return, end
if nargin<=1, vshi=0; else, vshi=arg2; end
ud=1; if nargin>=3, ud=arg3; end
eval(['gc=TRF',int2str(arg1),';']);
gi=gc(1:length(gc)-1); cc=gc(length(gc));

% color correction table
[tp1,tbl,tp2]=coltbl(cc);

VFULL=get(0,'ScreenSize'); % VFULL is a [1 times 4] matrix
if VFULL(3)>700, xx1=.04; else, xx1=-.1; end
if nargin<=3
 if vshi==.9601
  eval('tt=tfg1g(gi);'), vshi=.96;
 else
  eval('tt=tfgg(gi);')
 end
else
 [z,p,k,str]=exportf(gi,1);
 if str=='s'
  eval('tt=tfmg(z,p,k,gi,''1'');')
 else
  eval('tt=tfmg(z,p,k,gi,''1'',1);')
 end
end
nr=length(find(tt=='|'))+1;
xx=[]; yy=[];
for kk=1:nr
 if ud==1
  xx=[xx;xx1]; yy=[yy;vshi+.04*ABIL*nr-.04*ABIL*kk];
 else
  xx=[xx;xx1]; yy=[yy;vshi+.04*ABIL-.04*ABIL*kk];
 end
end
hh=text(xx,yy,tt,'Units','normalized','FontName','Fixedsys');
for kk=1:nr
 set(hh(kk),'Color',tbl,'Interpreter','none')
end
xy=waitforbuttonpress;
for kk=1:nr
 delete(hh(kk))
end
% --- last line of tfmaux ---
