function tfm(arg1,arg2,arg3,arg4,arg5,arg6)
%TFM	  Transfer function display (aux for TFI).
%   TFM(num,den,'gi')
%   TFM(num,den,'gi',1) --->  show the polynomial form of gi
%   TFM(z,p,k,'gi')
%   TFM(z,p,k,'gi',1)   --->  show the factorized form of gi
%   TFM(z,p,k,'gi','1')
%   TFM(z,p,k,'gi','1',1) ---> show the time constant form of gi
%   NOTE: option "1" means discrete-time; "gi" is just a name for display.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(3,6,nargs));
str='s'; fac=0;
if (nargs==3)|((nargs==4)&(isstr(arg3)))
 num=arg1; den=arg2; gi=arg3; pol=1;
 if nargs==4
  str='z';
 end
 Num=num; Den=den; k=1;
 if num(1)~=0, k=num(1); Num=num/num(1); Den=den; else, k=0; end
else
 z=arg1; p=arg2; k=arg3;
 gi=arg4; pol=0;
 if nargs==5
  if ~isstr(arg5), str='z'; else, fac=1; end
 end
 if nargs==6, str='z'; fac=1; end
 Num=[]; Den=[]; i=1;
 while i<=length(z)
  sn=size(Num);
  if abs(imag(z(i)))>10^(-4)
   nn=real(poly([z(i),real(z(i))-j*imag(z(i))]));
   qq=find(z==(real(z(i))-j*imag(z(i))));
   if length(qq)~=0, z(qq(1))=[]; end
   if fac==1, k=k*nn(3); nn=nn/nn(3); end
   Num=[zeros(sn(1),length(nn)-sn(2)),Num;nn];
  else
   pnum=poly(z(i));
   if (fac==1)&(pnum(2)~=0), k=k*pnum(2); pnum=pnum/pnum(2); end
   Num=[Num;zeros(1,sn(2)-2),pnum];
  end
  i=i+1;
 end
 i=1;
 while i<=length(p)
  sd=size(Den);
  if abs(imag(p(i)))>10^(-4)
   dd=real(poly([p(i),real(p(i))-j*imag(p(i))]));
   qq=find(p==(real(p(i))-j*imag(p(i))));
   if length(qq)~=0, p(qq(1))=[]; end
   if fac==1, k=k/dd(3); dd=dd/dd(3); end
   Den=[zeros(sd(1),length(dd)-sd(2)),Den;dd];
  else
   pden=poly(p(i));
   if (fac==1)&(pden(2)~=0), k=k/pden(2); pden=pden/pden(2); end
   Den=[Den;zeros(1,sd(2)-2),pden];
  end
  i=i+1;
 end
 if size(Num)==[0,0], Num=1; end
 if size(Den)==[0,0], Den=1; end
end
fprintf('\n')
[egv1,mul1,egv2,mul2,k]=ordg(Num,Den,k);
kl=length(sprintf('%.4g',k));
gl=length(gi)+3;
for hh=1:gl, fprintf(' '), end
i=4; nzpl=[]; vnil=[];
nz1=[]; nz2=[];
%
% max.length of expression
%
len=74;
%
for i=4:-1:1
 index=0; nzpl1=0;
 if (i==2)|(i==4)
  e=egv1; m=mul1; nil=kl;
 elseif (i==1)|(i==3)
  e=egv2; m=mul2; nil=0;
 end
 if i==2, fprintf('%.4g',k), end
 le=size(e);
 if (i==3)|((i==4)&(le(2)~=1))
  for nr=1:le(1)
   g=e(nr,:);
   cond1=((g(1)==0)&(le(2)==3)) | ((g(1)~=0)&(le(2)<=2));
   cond=(cond1 & pol==0) | pol==1 | fac==1;
   q=find(g~=0);
   kk=le(2);
   ncm=length(sprintf('%.4g',m(nr)));
   while kk~=0
    if cond
     if abs(g(le(2)+1-kk))>0
      nt=length(sprintf('%.4g',abs(g(le(2)+1-kk))));
      nc=length(sprintf('%.4g',kk-1));
      if (le(2)+1-kk)==q(1)
       if (nr~=1)|((nr==1)&(i==4)), nil=nil+1; end
       if length(q)>1, nil=nil+1; end
      end
      if (le(2)+1-kk)~=q(1), nil=nil+3; end
      if (le(2)+1-kk)==q(1) & g(le(2)+1-kk)<0, nil=nil+2; end
      if (abs(g(le(2)+1-kk))~=1)|((abs(g(le(2)+1-kk))==1)&(kk-1==0))
       nil=nil+nt;
      end
      if kk-1>0
       if abs(g(le(2)+1-kk))~=1
	nil=nil+2;
       else
	nil=nil+1;
       end
      end
      if kk-1>1, nil=nil+1+nc; end
     end
    else
     kk=1; rad=roots(g);
     lrea=length(sprintf('%.4g',abs(real(rad(1)))));
     lima=length(sprintf('%.4g',imag(rad(1))));
     if (nr~=1)|((nr==1)&(i==4)), nil=nil+1; end
     nil=nil+10+lima;
     if real(rad(1))~=0, nil=nil+1; end
     if real(rad(1))~=0, nil=nil+4+lrea; end
    end %end cond
    nzpl1=[nzpl1,nil];
    if nil>(len-gl)
     nil=nzpl1(length(nzpl1))-nzpl1(length(nzpl1)-1)-1;
     nzpl=[nzpl,nzpl1(length(nzpl1)-1)];
     vnil=[vnil,diff(nzpl1)];
     nzpl1=nil;
    end
    kk=kk-1;
   end
   if (length(q)>1)&cond, nil=nil+1; end
   if (m(nr)>1)&(length(find(g~=0))>0)
    nil=nil+1+ncm;
   end
   nzpl1=[nzpl1,nil];
   nzpl=[nzpl,nil];
  end
  if i==4
   vnil1=[vnil,diff(nzpl1)];
   xx=0; vnil=[];
   for kk=1:length(vnil1)
    if (xx+vnil1(kk))<=max(nzpl)
     xx=xx+vnil1(kk);
    else
     nz1=[nz1,xx]; xx=vnil1(kk)-1;
    end
   end
   nz1=[nz1,xx];
  else
   vnil2=[vnil,diff(nzpl1)]; xx=0;
   for kk=1:length(vnil2)
    if (xx+vnil2(kk))<=max(nzpl)
     xx=xx+vnil2(kk);
    else
     nz2=[nz2,xx]; xx=vnil2(kk)-1;
    end
   end
   nz2=[nz2,xx];
  end
 elseif (i==1)|((i==2)&(le(2)~=1))
  if i==2, nz=nz1; else, nz=nz2; end
  index=index+1;
  for nr=1:le(1)
   g=e(nr,:);
   cond1=((g(1)==0)&(le(2)==3)) | ((g(1)~=0)&(le(2)<=2));
   cond=(cond1 & pol==0) | pol==1 | fac==1;
   q=find(g~=0); kk=le(2);
   ncm=length(sprintf('%.4g',m(nr)));
   while kk~=0
    len=nz(index);
    if cond
     if abs(g(le(2)+1-kk))>0
      nt=length(sprintf('%.4g',abs(g(le(2)+1-kk))));
      nc=length(sprintf('%.4g',kk-1));
      if g(le(2)+1-kk)>0
       sgn=(' + ');
      elseif g(le(2)+1-kk)<0
       sgn=(' - ');
      end
      if (le(2)+1-kk)==q(1)
       if (nr~=1)|((nr==1)&(i==2))
	fprintf(' '), nil=nil+1;
       end
       if length(q)>1
	fprintf('('), nil=nil+1;
       end
      end
      if (le(2)+1-kk)~=q(1)
       fprintf(sgn), nil=nil+3;
      end
      if (le(2)+1-kk)==q(1) & g(le(2)+1-kk)<0
       fprintf('- '), nil=nil+2;
      end
      if (abs(g(le(2)+1-kk))~=1)|((abs(g(le(2)+1-kk))==1)&(kk-1==0))
       fprintf('%.4g',abs(g(le(2)+1-kk))), nil=nil+nt;
      end
      if kk-1>0
       if abs(g(le(2)+1-kk))~=1
	fprintf('*'), fprintf(str), nil=nil+2;
       else
	fprintf(str), nil=nil+1;
       end
      end
      if kk-1>1, fprintf('^%.4g',kk-1), nil=nil+1+nc; end
     end
    else
     kk=1; rad=roots(g);
     lrea=length(sprintf('%.4g',abs(real(rad(1)))));
     lima=length(sprintf('%.4g',imag(rad(1))));
     if (nr~=1)|((nr==1)&(i==2))
      fprintf(' '), nil=nil+1;
     end
     nil=nil+10+lima;
     fprintf('[')
     if real(rad(1))~=0
      fprintf('('), nil=nil+1;
     end
     fprintf(str)
     if real(rad(1))~=0
      if real(rad(1))>0
       sgnr=' -';
      else
       sgnr=' +';
      end
      fprintf(sgnr)
      fprintf(' %.4g)',abs(real(rad(1))))
      nil=nil+4+lrea;
     end
     fprintf('^2 + %.4g^2]',imag(rad(1)))
    end
    if (nil>=len)&(index<length(nz))
     index=index+1; nil=-1;
     fprintf('\n')
     for hh=1:gl-1, fprintf(' '), end
     if kk==1, fprintf(' '), end
    end
    kk=kk-1;
   end
   if length(q)>1 & cond
    fprintf(')'), nil=nil+1;
   end
   if (m(nr)>1)&(length(find(g~=0))>0)
    fprintf('^%.4g',m(nr)), nil=nil+1+length(sprintf('%.4g',m(nr)));
   end
   if (nil>=len)&(nr~=le(1))&(index<length(nz))
    index=index+1; nil=-1;
    fprintf('\n'),
    for hh=1:gl-1, fprintf(' '), end
   end
  end
 end
 if i==2
  fprintf('\n'), fprintf(gi), fprintf(' = ')
  for in=1:max([nz1,nz2,kl]), fprintf(setstr(173)), end
  fprintf('\n')
  for hh=1:gl, fprintf(' '), end
 end
end
fprintf('\n')
% --- last line of tfm ---
