function tfi_main
%TFI      Transfer Function Interpreter. Crea l'ambiente TFI.
%
%Operatori disponibili: +, -, *, /, ^. Esempi:
%
%> g1=10/(s*(s+1)^2*(s+5))  definisce la f.d.t. g1 e la salva come g1.mat
%> g2=5*(z+1)/(z-1)^2       come sopra, per sistemi a tempo discreto
%> g1                       mostra g1
%> g1=                      mostra g1 nella forma zeri-poli
%> g1:                      mostra g1 nella forma costanti di tempo
%> g1;                      traccia la mappa zeri-poli di g1
%> g1(1+2*j)                mostra il valore di g1(s) per s=1+2*j
%> g0=gc*g1/(1+gc*g1)       calcola g0 in funzione di gc e g1
%> -.3*(7+5/44)             calcola l'espressione e mostra il risultato
%> [sin(pi/4)+atan(26)]     calcola l'espressione e mostra il risultato
%
%Comandi disponibili: cd, clc, what, help file, print file, grid, degrid,
%                     delete file, delete(n), dir, shg, zoom on, zoom off.
%
%Funzioni disponibili (inviare "help funzione" per maggiori informazioni):
%
%    convert,gi,gj : converte gi da s a z e salva in gj
%    defactf,gi,gj : pone gi in forma polinomiale e salva in gj
%    deftf,gi : definisce gi con mouse o secondo Bessel, Butterworth, Pade'
%    descrf[,gi] : analisi di sistemi non lineari con funzione descrittiva
%    factf,gi,gj : fattorizza gi e salva in gj
%    fresp,gi : traccia i diagrammi di risposta in frequenza di gi
%    gpmarg,gi : visualizza i margini di ampiezza e fase di gi
%    invtr,gi : visualizza l'antitrasformata di Laplace (o Z) di gi
%    lagc,gi,gj : progetto di rete ritardatrice (diagrammi di Bode)
%    leadc,gi,gj : progetto di rete anticipatrice (diagrammi di Bode)
%    nlsim,gi,gj,gk : risposta nel tempo di un anello con una nonlinearita'
%    perftra,gi,gj,gk,gw : progetto di controllo digitale con preazione
%    pidc,gi,gj : progetto di regolatore PID (diagrammi di Bode)
%    pidd,gi,gj : progetto di regolatore PID digitale (diagrammi di Bode)
%    pidnich,gi,gj : progetto di regolatore PID (diagramma di Nichols)
%    regdph,gi,gj,gk,gw : progetto di regolatore con l'equazione diofantea
%    regnich,gi,gj : progetto di rete correttrice (diagramma di Nichols)
%    regrootl,gi,gj : progetto di regolatore col luogo delle radici
%    robpar,gi,gj,gk,[gw] : analisi di robustezza parametrica
%    rootl,gi : traccia il luogo delle radici di gi
%    routh,gi : mostra gli intervalli di stabilita' ad anello chiuso di gi
%    samptime,T : definisce il tempo di campionamento corrente in TFI
%    select,gi,gj : sceglie in interattivo fattori di gi e salva in gj
%    startint : definisce alcune configurazioni dell'ambiente TFI
%    tfeval,gi : visualizza il valore di gi per un dato valore di s o z
%    tresp,gi : traccia la risposta all'impulso o al gradino di gi
%    wplane,gi,gj : converte dal piano z al piano w o viceversa
%    zpplots,gi : traccia la mappa zeri-poli di gi
%
%Per creare o richiamare finestre grafiche, usare "fig1", "fig2",...,"last".
%I comandi "sma[ll]", "med[ium]", "lar[ge]" dimensionano la figura corrente,
%"delete(n)" chiude la figura n, "new" crea una nuova figura con il primo
%numero disponibile, "ordf" ordina le figure come small, "delf" le cancella,
%"enl" ingrandisce la figura corrente del 20 %, "red" la riduce del 20 %,
%"res[figlo]" ripristina le posizioni delle figure modificate con il mouse.

%    A.Civolani, G.Marro (supervisor: A.Natali) - 1-18-1994
%    revised 9-30-1995, 1-20-97. Matlab5 version, 1997.

global ABIL HALEG FIGLEG LABLEG SUBPLEG, ABIL=0;

eA=setstr(232); EA=setstr(200);
clc, flg=0; funcv='xxxxx';
fprintf('\n TRANSFER FUNCTION INTERPRETER - A.Civolani e G.Marro ')
fprintf('- ver 3.2, 22-1-1998\n')
disp(' ')
disp(' NOTA: sono disponibili da TFI i comandi Matlab:')
fprintf('       cd, clc, what, help file, print file [opzioni], grid,')
fprintf(' degrid,\n')
fprintf('       delete file, delete(n), dir, shg, zoom on, zoom off,')
fprintf(' figure;\n')
disp('       si possono valutare espressioni, come 3*6/(2+7) o [pi/6];')
disp('       "shg" fa passare da Command Window alla figura corrente;')
disp('       il tasto escape fa passare dalla figura a Command Window;')
disp('       i comandi "new" e "figure" creano una nuova finestra grafica;')
disp('       la sessione termina (uscita a Matlab) con "exit" o "quit".')
disp(' ')
fprintf([' ',EA,' necessario definire un tempo di campionamento'])
fprintf(' per la conversione da\n')
fprintf(' tempo continuo a tempo discreto')
fprintf(' (programmi convert e wplane):\n')
if ~exist('time#.mat')
 disp(' prima di usare l''inteprete, definire il tempo di campionamento;')
 samptime
else
 T=lsamp;
 fprintf(['\n   il tempo di campionamento attuale ',eA,' %.4g sec\n'],T)
end
fprintf('\n per cambiarlo, introdurre il nuovo')
fprintf(' valore usando "sam[ptime]".\n')
fprintf(' Per maggiori informazioni sui comandi,')
fprintf(' inviare "help tfi" o "tfi".\n')
figure(1), ordf(1)
flg=0;
while flg==0
 flg1=0; flg2=0; ss=[]; er=0; a=0;
 str=[]; s1=[]; cond=1;
 while flg1==0
  sv=input('\n > ','s');
  if (length(sv)==0)&(length(str)~=0), flg1=1; end
  if length(sv)~=0
   while (sv(1)==' ')&(length(sv)>1), sv=sv(2:length(sv)); end
   if strcmp(sv,'quit')|strcmp(sv,'exit')
    return
   end
   rop=0;
   if strcmp(sv,'shg'), sv='fig'; end
   if strcmp(sv,'new')
    rop=1; sv='yyyyy'; figure, ordf(1)
   end
   if strcmp(sv,'tfi') | strcmp(sv,'help tfi'), sv='help tfi_main'; end
   if strcmp(sv,'intp') | strcmp(sv,'tfi_main'), rop=1; sv='yyyyy'; end
   if strcmp(sv,'last'), sv=['fig',int2str(max(get(0,'Children')))]; end
   if strcmp(sv,'degrid'), sv='grid off'; end
   if strcmp(sv,'error'), rop=1; sv='yyyyy'; end
   if strcmp(sv,'who'), rop=1; sv='yyyyy'; end
   if flg2==0
    str1=sv(1);
    rop=rop|(str1=='.');
    rop=rop|(str1=='+');
    rop=rop|(str1=='-');
    rop=rop|(str1=='(');
    rop=rop|(str1=='[');
    rop=rop|((abs(str1)>=48)&(abs(str1)<=57));
    if (rop==0)&(length(sv)>=2)
     rop=rop|strcmp(sv(1:2),'cd');
    end
    if (rop==0)&(length(sv)>=3)
     if strcmp(sv(1:3),'sma'), sv='small'; end
     if strcmp(sv(1:3),'med'), sv='medium'; end
     if strcmp(sv(1:3),'lar'), sv='large'; end
     if strcmp(sv(1:3),'red'), rop=1; ordf(4), sv='yyyyy'; end
     if strcmp(sv(1:3),'enl'), rop=1; ordf(5), sv='yyyyy'; end
     rop=rop|strcmp(sv(1:3),'clc');
     rop=rop|strcmp(sv(1:3),'dir');
     if strcmp(sv(1:3),'fig') & ~strcmp(sv,'figure')
      if length(sv)>3
       err='err';
       sk=eval(['figure(',sv(4:length(sv)),')'],'err');
       if sk=='err'
        disp('   errore in ingresso')
       end
      else
       eval('figure(gcf)'), ordf(3)
      end
      rop=1; sv='yyyyy';
     end
    end
    if (rop==0)&(length(sv)>=4)
     rop=rop|strcmp(sv(1:4),'help');
     rop=rop|strcmp(sv(1:4),'meta');
     rop=rop|strcmp(sv(1:4),'!dir');
     rop=rop|strcmp(sv(1:4),'!del');
     rop=rop|strcmp(sv(1:4),'grid');
     rop=rop|strcmp(sv(1:4),'what');
     rop=rop|strcmp(sv(1:4),'path');
     if strcmp(sv(1:4),'help')&(length(sv)>5)
      xx=sv(6:length(sv)); xx=xx(find(xx~=' '));
      sv=['help ',functab(xx)];
     end
     if strcmp(sv(1:4),'zoom')
      rop=1;
      set(gca,'XTickMode','auto'), set(gca,'YTickMode','auto')
     end
    end
    if (rop==0)&(length(sv)>=5)
     rop=rop|strcmp(sv(1:5),'clear');
     rop=rop|strcmp(sv(1:5),'print');
     rop=rop|strcmp(sv(1:5),'which');
     if strcmp(sv(1:5),'clear'), sv='clear functions'; end
     if strcmp(sv(1:5),'small')
      rop=1; sv='yyyyy'; ordf(1), figure(gcf)
     end
     if strcmp(sv(1:5),'large')
      rop=1; sv='yyyyy'; ordf(3), figure(gcf)
     end
    end
    if (rop==0)&(length(sv)>=6)
     rop=rop|strcmp(sv(1:6),'delete');
     rop=rop|strcmp(sv(1:6),'figure');
     rop=rop|strcmp(sv(1:6),'legend');
     if strcmp(sv(1:6),'medium')
      rop=1; sv='yyyyy'; ordf(2), figure(gcf)
     end
    end
    if (rop==0)&(length(sv)>=7)
     rop=rop|strcmp(sv(1:7),'whitebg');
    end
   end
   if rop
    if ~strcmp(sv,'yyyyy')
     eval(sv,'rop=0;')
    end
   end
   if ~rop
    sv=sv(find(sv~=' '));
    for i=1:length(sv)
     if sv(i)~=' '
      str=[str,sv(i)]; s1=[s1,sv(i)];
      if i<length(sv)
       if (sv(i)=='(')&(sv(i+1)=='-'), str=[str,'0']; a=a+1; end
       if (sv(i)=='=')&((sv(i+1)=='-')|(sv(i+1)=='+'))
        str=[str,'0']; a=a+1;
       end
      end
     end
    end
    if length(str)~=1, str1=str(1:length(str)-1); end
    rop=any(str1=='+');
    rop=rop|any(str1=='-');
    rop=rop|any(str1=='*');
    rop=rop|any(str1=='/');
    rop=rop|any(str1=='^');
    rop=rop&~any(str1=='=');
    rop=rop&~((str(length(str))=='=')|...
    (str(length(str))==':')|(str(length(str))==';'));
    rop1=1; fbl=find(str=='(');
    if length(fbl)>0
     if fbl(1)>1
      fb=str(fbl(1)-1);
      if length(find(fb=='=*/^+-'))==0, rop1=0; end
      rop=rop&rop1;
     end
    end
    if rop
     if str(1)=='-', str=['ans=0',str]; a=a+1; else, str=['ans=',str]; end
     s1=['ans=',s1];
    end
    rop=rop1;
    if (str(length(str))=='=')&rop
     str=str(1:length(str)-1); s1=s1(1:length(s1)-1); rop=0;
     if exist([str,'.mat'])
      cond=0;
      [z,p,k,string]=exportf(str,1);
      if strcmp(string,'s')
       tfm(z,p,k,str)
      else
       tfm(z,p,k,str,1)
      end
     end
    end
    if (str(length(str))==':')&rop
     str=str(1:length(str)-1); s1=s1(1:length(s1)-1); rop=0;
     if exist([str,'.mat'])
      cond=0;
      [z,p,k,string]=exportf(str,1);
      if strcmp(string,'s')
       tfm(z,p,k,str,'1')
      else
       tfm(z,p,k,str,'1',1)
      end
     end
    end
    if (str(length(str))==';')&rop
     str=str(1:length(str)-1); s1=s1(1:length(s1)-1); rop=0;
     if exist([str,'.mat'])
      cond=0;
      figure, zpplots(str); delete(gcf)
     end
    end
    if str(length(str))~='>'
     flg1=1;
    else
     str=[str(1:length(str)-1)]; s1=[s1(1:length(s1)-1)]; flg2=1;
    end
   end  % if ~rop
  end   % if length(sv)==0
 end    % while flg1==0
 q=find(str=='=');
 [func,flfu]=functab(str,1); zoom off
 if length(q)==0 | ~rop1
  qq=find(str==',');
  err=0; mess=(' **** TFI ha qualche problema con l''ultima richiesta');
  if isempty(qq)
   if exist([str,'.mat'])
    if cond
     lstr=length(str);
     if lstr>2
      if str(lstr-1:lstr)=='_p', eval('tfg1(str)'), else, tfg(str), end
     else
      tfg(str)
     end
    end
   elseif flfu==1
    eval(func,'err=1;')
   elseif ~rop1
    fbl=find(str=='('); fbr=find(str==')');
    lfbl=length(fbl); lfbr=length(fbr);
    if lfbl>0 & lfbr>0 & (lfbl==lfbr)
     if fbl(1)>1 & fbr(length(fbr))==length(str)
      tfev=str(1:fbl(1)-1); nev=str(fbl(1)+1:fbr(length(fbr))-1);
      eval('tfeval(tfev,nev)')
     else
      disp(' errore: stringa in ingresso non ammessa')
     end
    else
     disp(' errore: stringa in ingresso non ammessa')
    end
   else
    disp([' ',str,'.mat o l''applicazione ',str,' non esiste'])
   end
  else
   func=str(1:qq(1)-1); vec=[]; nvec=0; gi=[]; gj=[];
   [func,flfu]=functab(func); zoom off
   if flfu==0
    disp([' l''applicazione ',func,' non esiste'])
   else
    if qq(length(qq))==length(str)
     disp(' errore: carattere "," alla fine dell''espressione')
    else
     if length(find(diff(qq)==1))~=0
      disp(' errore: carattere ",," non ammesso')
     else
      funcv=func;
      if length(qq)==1
       tf1=str(qq(1)+1:length(str));
       eval([func,'(''',tf1,''')'],'err=1;'), ABIL=0;
      elseif length(qq)==2
       tf1=str(qq(1)+1:qq(2)-1);
       tf2=str(qq(2)+1:length(str));
       eval([func,'(''',tf1,''',''',tf2,''')'],'err=1;'), ABIL=0;
      elseif length(qq)==3
       tf1=str(qq(1)+1:qq(2)-1);
       tf2=str(qq(2)+1:qq(3)-1);
       tf3=str(qq(3)+1:length(str));
       eval([func,'(''',tf1,''',''',tf2,''',''',tf3,''')'],'err=1;'), ABIL=0;
      else
       tf1=str(qq(1)+1:qq(2)-1);
       tf2=str(qq(2)+1:qq(3)-1);
       tf3=str(qq(3)+1:qq(4)-1);
       tf4=str(qq(4)+1:length(str));
       eval([func,'(''',tf1,''',''',tf2,''',''',tf3,''',''',tf4,''')'],...
       'err=1;'), ABIL=0;
      end
     end
    end
   end
  end
  if err==1, disp(mess), end
 elseif length(q)>1
  disp(' errore: troppi "=" ')
 else
  name=str(1:q-1); str=str(q+1:length(str));
  a1=length(find(str=='+')); a2=length(find(str=='-'));
  a3=length(find(str=='*')); a4=length(find(str=='/'));
  a5=length(find(str=='^'));
  if (a1==0)&(a2==0)&(a3==0)&(a4==0)&(a5==0)
   if (length(find(str=='('))>0)|(length(find(str==')'))>0)
    disp(' errore: parentesi non ammessa')
    er=1;
   else
    str=['1*',str]; a=a+2;
   end
  end
  strbr=str(find((str=='(')|(str==')'))); strbr=[strbr,'1'];
  if strbr(1)==')'
   disp(' errore: sequenza di parentesi non ammessa'), er=1;
  elseif length(find(str=='('))~=length(find(str==')'))
   disp(' errore: parentesi non bilanciate'), er=1;
  elseif str(1)==')'
   disp(' errore: parentesi destra all''inizio dell''espressione'), er=1;
  elseif str(length(str))=='('
   disp(' errore: parentesi sinistra alla fine dell''espressione'), er=1;
  elseif er==0
   fprintf('\n'), fprintf(s1), fprintf('\n')
   if length(name)+1>=a
    for i=1:length(name)+1-a, fprintf('.'), end
   end
   if length(find([name,str]==','))~=0
    fprintf('\nerrore: carattere "," nell''espressione\n')
    er=1;
   else
    i=1;
    vg=[]; inx=[]; n=[]; a=ones(1,length(str)); vo=' '*a;
%
%  lexical analyzer: string is analyzed by characters, and lexical
%  class of character or of string initiating with it is searched for;
%  output is a symbol corresponding to this class or an error message.
%
    while i<=length(str)
     rop=((48<=abs(str(i)))&(abs(str(i))<=57));
     rop1=(str(i)~='+')&(str(i)~='-')&(str(i)~='*');
     rop1=rop1&(str(i)~='/')&(str(i)~='^');
     rop2=(str(i)~='.')&(str(i)~=')')&(str(i)~='(');
     if ~(rop)&rop1&rop2
      for h=i:length(str)
       rop=(str(h)~='+')&(str(h)~='-')&(str(h)~='*');
       rop=rop&(str(h)~='/')&(str(h)~='^');
       if rop&(str(h)~=')')
        if str(h)=='('
         fprintf('\nerrore: parentesi sinistra non ammessa\n')
         er=1; i=length(str)+1;
         break
        end
        if str(h)=='.'
         fprintf('\nerrore: carattere "." non ammesso\n')
         er=1; i=length(str)+1;
         break
        end
        fprintf('.'), n=[n,str(h)]; a(h)=0;
       else
        break
       end
      end
      if ~exist([n,'.mat'])&~(strcmp(n,'s'))&~(strcmp(n,'z'))&(er==0)
       disp(' ')
       disp([n,'.mat non esiste'])
       er=1; i=length(str)+1;
       break
      end
      vg=[vg;n,' '*ones(1,16-length(n))]; inx=[inx,length(n)];
      x=i+length(n); str(i)='g'; a(i)=1;
     end
     if ((48<=abs(str(i)))&(abs(str(i))<=57))|(str(i)=='.')
      fprintf('.'), n=str(i); str(i)='n';
      h=i+1; flgoo=0;
      while h<=length(str)
       if (((48<=abs(str(h)))&(abs(str(h))<=57))|(str(h)=='.'))&(flgoo~=2) %5.3
        if (flgoo==1)&(str(h)=='.')
         fprintf('.'), n=[n,'k']; a(h)=0; h=h+1; flgoo=2;
        else
        fprintf('.'), n=[n,str(h)]; a(h)=0; h=h+1;
        end
       elseif (str(h)=='e')&(h<length(str))
        rop=(48<=abs(str(h+1)))&(abs(str(h+1))<=57);
        if rop|(str(h+1)=='+')|(str(h+1)=='-')
         fprintf('..'), n=[n,str(h:h+1)]; a(h:h+1)=[0,0]; h=h+2; flgoo=1;
        else
         fprintf('.'), n=[n,'k']; a(h)=0; h=h+1; flgoo=2;
        end
       else
        break
       end
      end
      vg=[vg;n,' '*ones(1,16-length(n))]; inx=[inx,length(n)];
      x=i+length(n);
      if (str(x-1)=='.')|strcmp(n,'.')
       fprintf('\nerrore: carattere "." non ammesso\n')
       er=1; i=length(str)+1;
       break
      end
      if length(find(n=='.'))>1
       fprintf('\nerrore: troppi "." nell''espressione\n')
       er=1; i=length(str)+1;
       break
      end
%  messages related to numbers with exponential notation
%  rop is 1 if there is an error
      rop=length(find(n=='e'))>1;
      rop=rop|length(find(n=='k'))>0;
      rop=rop|n(length(n))=='+'|n(length(n))=='-';
      if rop
       fprintf('\nerrore: rappresentazione di numero non ammessa\n')
       er=1; i=length(str)+1;
       break
      end
      if (x-1)~=length(str)
       rop=(str(x)~='+')&(str(x)~='-')&(str(x)~='*');
       rop=rop&(str(x)~='/')&(str(x)~='^')&(str(x)~=')');
       if rop
        fprintf('.'), er=1; i=length(str)+1;
        fprintf('\nerrore: carattere dopo numero non ammesso\n')
        break
       end
      end
     end
     if str(i)=='('
      x=i+1; fprintf('.')
      if (x-1)~=length(str)
       rop=(str(x)=='+')|(str(x)=='*')|(str(x)=='/');
       rop=rop|(str(x)=='^')|(str(x)==')');
       if rop
        fprintf('\nerrore: carattere dopo parentesi non ammesso\n')
        er=1; i=length(str)+1;
        break
       end
      end
      vg=[vg;'$'*ones(1,16)]; inx=[inx,0];
     end
     if str(i)==')'
      x=i+1; fprintf('.')
      if (x-1)~=length(str)
       rop=(str(x)~='+')&(str(x)~='-')&(str(x)~='*');
       rop=rop&(str(x)~='/')&(str(x)~='^');
       if rop&(str(x)~=')')
        fprintf('\nerrore: carattere dopo parentesi non ammesso\n')
        er=1; i=length(str)+1;
        break
       end
      end
      vg=[vg;'$'*ones(1,16)]; inx=[inx,0];
     end
     rop=(str(i)=='+')|(str(i)=='*')|(str(i)=='/')|(str(i)=='^');
     if rop|(str(i)=='-')
      vo(i)=str(i); str(i)='o';
      x=i+1; fprintf('.')
      if (((x-1)==1)&rop)|((x-1)==length(str))
       fprintf('\nerrore: carattere non ammesso\n')
       er=1; i=length(str)+1;
       break
      end
      if (x-1)~=length(str)
       rop=(str(x)=='+')|(str(x)=='-')|(str(x)=='*');
       rop=rop|(str(x)=='/')|(str(x)=='^');
       if rop|(str(x)==')')
        fprintf('\nerrore: carattere dopo operatore non ammesso\n')
        er=1; i=length(str)+1;
        break
       end
      end
      vg=[vg;'$'*ones(1,16)]; inx=[inx,0];
     end
     i=x; n=[];
    end
   end
  end
  if er~=1
   fprintf('\n'), aw=find(a);
   str=str(aw); vo=vo(aw); a=a(aw); var1=[]; var2=[]; var=[];
   for jj=1:length(str)
    if (vg(jj,1)=='s')&(inx(jj)==1), var1='s'; end
    if (vg(jj,1)=='z')&(inx(jj)==1), var2='z'; end
   end
   if ~isempty(var1)&~isempty(var2)
    fprintf('\nerrore: "s" e "z" nella stessa espressione\n')
    er=1;
   elseif ~isempty(var1)&isempty(var2)
    var='s';
   elseif ~isempty(var2)&isempty(var1)
    var='z';
   end
   if er~=1
    i=1; vect=[]; vv=[]; inv=[]; vop=[];
    aux=[]; vx=[]; va=[];
    for jj=1:20, fprintf(setstr(95)), end
    fprintf('\n')
%
%  reverse polish notation, where priority of operators
%  is taken into account.
%
    while i<=length(str)
     if (str(i)=='g')|(str(i)=='n')
      vect=[vect,str(i)]; vv=[vv;vg(i,:)]; inv=[inv,inx(i)]; vop=[vop,' '];
      x=i+1;
     end
     if str(i)=='o'
      if vo(i)=='^'
       if (str(i+1)~='(')
        vect=[vect,str(i+1),'o']; vv=[vv;vg(i+1,:);zeros(1,16)];
        inv=[inv,inx(i+1),0]; vop=[vop,' ','^']; x=i+2;
       else
        aux=['o',aux]; vx=['^',vx]; x=i+1;
       end
      end
      if (vo(i)=='*')|(vo(i)=='/')
       if length(aux)~=0
        if vx(1)=='/'
         vect=[vect,'o']; vv=[vv;zeros(1,16)]; inv=[inv,0]; vop=[vop,vx(1)];
         b=ones(1,length(aux)); b(1)=0; aux=aux(find(b)); vx=vx(find(b));
        end
       end
       if str(i-1)==')'
        if length(aux)~=0
         if vx(1)=='^'
          vect=[vect,'o']; vv=[vv;zeros(1,16)]; inv=[inv,0]; vop=[vop,'^'];
          b=ones(1,length(aux)); b(1)=0; aux=aux(find(b)); vx=vx(find(b));
         end
        end
       end
       if str(i+1)~='('
        if i+2<=length(str)
         if vo(i+2)~='^'
          vect=[vect,str(i+1),'o']; vv=[vv;vg(i+1,:);zeros(1,16)];
          inv=[inv,inx(i+1),0]; vop=[vop,' ',vo(i)];
         else
          vect=[vect,str(i+1)]; vv=[vv;vg(i+1,:)]; inv=[inv,inx(i+1)];
          vop=[vop,' ']; aux=['o',aux]; vx=[vo(i),vx];
         end
        else
         vect=[vect,str(i+1),'o']; vv=[vv;vg(i+1,:);zeros(1,16)];
         inv=[inv,inx(i+1),0]; vop=[vop,' ',vo(i)];
        end
        x=i+2;
       else
        aux=['o',aux]; vx=[vo(i),vx];
        x=i+1;
       end
      end
      if (vo(i)=='+')|(vo(i)=='-')
       if i-2>1
        if (vo(i-2)=='*')|(vo(i-2)=='/')|(vo(i-2)=='^')
         if length(aux)~=0
          vect=[vect,aux]; vv=[vv;zeros(length(aux),16)];
          inv=[inv,zeros(1,length(aux))]; vop=[vop,vx]; aux=[]; vx=[];
         end
        end
       end
       if str(i+1)~='('
        if i+2<=length(str)
         if (vo(i+2)~='^')&(vo(i+2)~='*')&(vo(i+2)~='/')
          vect=[vect,str(i+1),'o']; vv=[vv;vg(i+1,:);zeros(1,16)];
          inv=[inv,inx(i+1),0]; vop=[vop,' ',vo(i)];
         else
          vect=[vect,str(i+1)]; vv=[vv;vg(i+1,:)]; vop=[vop,' '];
          inv=[inv,inx(i+1)]; aux=['o',aux]; vx=[vo(i),vx];
         end
        else
         vect=[vect,str(i+1),'o']; vv=[vv;vg(i+1,:);zeros(1,16)];
         inv=[inv,inx(i+1),0]; vop=[vop,' ',vo(i)];
        end
        x=i+2;
       else
        aux=['o',aux]; vx=[vo(i),vx]; x=i+1;
       end
      end
     end
     if str(i)=='('
      if length(aux)~=0
       va=[va;vx,' '*ones(1,20-length(vx))];
       aux=[]; vx=[];
      else
       va=[va;'$'*ones(1,20)];
      end
      x=i+1;
     end
     if str(i)==')'
      vect=[vect,aux]; vv=[vv;zeros(length(aux),16)];
      inv=[inv,zeros(1,length(aux))]; vop=[vop,vx]; aux=[]; vx=[];
      if i<length(str)
       if (str(i+1)==')')|(vo(i+1)=='+')|(vo(i+1)=='-')
        sc=size(va);
        if sc(1)~=0
         if va(sc(1),:)~='$'*ones(1,20)
          q=find(va(sc(1),:)==' ');
          vect=[vect,'o'*ones(1,q(1)-1)]; vv=[vv;zeros(q(1)-1,16)];
          inv=[inv,zeros(1,q(1)-1)]; vop=[vop,va(sc(1),1:q(1)-1)];
          va(sc(1),:)=[];
         else
          va(sc(1),:)=[];
         end
        end
       end
       if (vo(i+1)=='*')|(vo(i+1)=='/')|(vo(i+1)=='^')
        sc=size(va);
        if sc(1)~=0
         if va(sc(1),:)~='$'*ones(1,20)
          q=find(va(sc(1),:)==' ');
          aux='o'*ones(1,q(1)-1); vx=va(sc(1),1:q(1)-1);
          va(sc(1),:)=[];
         else
          va(sc(1),:)=[];
         end
        end
       end
      end
      x=i+1;
     end
     i=x;
    end
    vect=[vect,aux]; vv=[vv;zeros(length(aux),16)]; vop=[vop,vx];
    inv=[inv,zeros(1,length(aux))]; sc=size(va);
    for k=1:sc(1)
     if va(sc(1)-k+1,:)~='$'*ones(1,20)
      q=find(va(sc(1)-k+1,:)==' ');
      vect=[vect,'o'*ones(1,q(1)-1)];
      vv=[vv;zeros(q(1)-1,16)];
      inv=[inv,zeros(1,q(1)-1)];
      vop=[vop,va(sc(1)-k+1,1:q(1)-1)];
     end
    end
%
%  performing computations and storing results.
%
    a=ones(1,length(vect)); a1=length(find(vect=='o')); nr=0; nk=1;
    kf=[]; Nu=[]; De=[]; sn=[]; sd=[];
    xx=10/length(find(vop~=' ')); kk=0;
    vectn=zeros(1,length(vect));
    for i=1:length(vect)
     if vect(i)=='n'
      vectn(i)=eval(vv(i,:));
     end
    end
    while nk<=a1
     for i=1:length(vect)
      if vect(i)=='o'
       if vect(i-2)=='n'
        Num1=1; Den1=1; k1=vectn(i-2);
       elseif vect(i-2)=='g'
        x=vv(i-2,1:inv(i-2));
        if (x=='s')|(x=='z')
         Num1=[1 0]; Den1=1; k1=1;
        else
         [Num1,Den1,k1,str1,Tc]=ltf(x);
         if (size(Num1)==[1,1])&(size(Den1)==[1,1])
          str1=var;
         elseif isempty(var)
          var=str1;
         elseif str1~=var
          if er~=1
           disp('errore: "s" e "z" nella stessa espressione')
           er=1; nk=a1+1;
          end
          break
         end
        end
       else
        if vect(i-1)~='r'
         nn=sn(1); dd=sd(1);
         Num1=Nu(1:nn(1),:); Den1=De(1:dd(1),:); k1=kf(1);
         Nu(1:nn(1),:)=[]; De(1:dd(1),:)=[]; kf(1)=[]; sn(1,:)=[]; sd(1,:)=[];
        else
         nn1=sn(1); nn2=sn(2); dd1=sd(1); dd2=sd(2);
         Num1=Nu(nn1(1)+1:nn1(1)+nn2(1),:);
         Den1=De(dd1(1)+1:dd1(1)+dd2(1),:); k1=kf(2);
         Nu(nn1(1)+1:nn1(1)+nn2(1),:)=[]; De(dd1(1)+1:dd1(1)+dd2(1),:)=[];
         kf(2)=[]; sn(2,:)=[]; sd(2,:)=[];
        end
       end
       if vect(i-1)=='n'
        Num2=1; Den2=1; k2=vectn(i-1);
        if (vop(i)=='^')&(round(k2)~=k2)
         disp('errore: non un numero intero dopo ^ ! ')
         er=1; nk=a1+1;
         break
        end
       elseif vect(i-1)=='g'
        x=vv(i-1,1:inv(i-1));
        if vop(i)=='^'
         disp('errore: non un numero intero dopo ^ ! ')
         er=1; nk=a1+1;
         break
        end
        if  (x=='s')|(x=='z')
         Num2=[1 0]; Den2=1; k2=1;
        else
         [Num2,Den2,k2,str2,Tc]=ltf(x);
         if (size(Num2)==[1,1])&(size(Den2)==[1,1])
          str2=var;
         elseif isempty(var)
          var=str2;
         elseif str2~=var
          if er~=1
           disp('errore: "s" e "z" nella stessa espressione')
           er=1; nk=a1+1;
          end
          break
         end
        end
       else
        nn=sn(1); dd=sd(1);
        Num2=Nu(1:nn(1),:); Den2=De(1:dd(1),:); k2=kf(1);
        Nu(1:nn(1),:)=[]; De(1:dd(1),:)=[]; kf(1)=[]; sn(1,:)=[]; sd(1,:)=[];
        if vop(i)=='^'
         disp('errore: non un numero intero dopo ^ ! ')
         er=1; nk=a1+1;
         break
        end
       end
       opt=0;
       if (vect(i-2)=='n')&(vect(i-1)=='n')
        N=1; D=1;
        K=feval(vop(i),k1,k2);
       elseif (vect(i-1)=='n')&(vect(i-2)~='n')&((vop(i)=='*')|(vop(i)=='/'))
        N=Num1; D=Den1;
        K=feval(vop(i),k1,k2);
       elseif (vect(i-2)=='n')&(vect(i-1)~='n')&((vop(i)=='*'))
        N=Num2; D=Den2;
        K=feval(vop(i),k1,k2);
       elseif (vect(i-2)=='n')&(vect(i-1)~='n')&((vop(i)=='/'))
        N=Den2; D=Num2;
        K=feval(vop(i),k1,k2);
       else
        if (vop(i)=='+')|(vop(i)=='-')
         op='sumg';
        elseif (vop(i)=='*')|(vop(i)=='/')
         op='prodg';
        elseif vop(i)=='^'
         op='expg';
        end
        if (vop(i)=='/')|(vop(i)=='-'), opt=1; end
        if vop(i)~='^'
         [N,D,K]=feval(op,Num1,Den1,k1,Num2,Den2,k2,opt);
        else
         [N,D,K]=feval(op,Num1,Den1,k1,k2);
        end
       end
       if (vect(i-2)=='n')&(vect(i-1)=='n')
        vectn(i-2)=K;
       else
        kf=[K,kf];
        snu=size(Nu); sde=size(De); n=size(N); d=size(D);
        sn=[n;sn]; sd=[d;sd];
        if snu(2)>n(2)
         Nu=[zeros(n(1),snu(2)-n(2)),N;Nu];
        else
         Nu=[N;zeros(snu(1),n(2)-snu(2)),Nu];
        end
        if sde(2)>d(2)
         De=[zeros(d(1),sde(2)-d(2)),D;De];
        else
         De=[D;zeros(sde(1),d(2)-sde(2)),De];
        end
        vect(i-2)='r';
       end
       for jj=1:fix(xx*nk)-fix(kk), fprintf('..'), end
       kk=xx*nk; a(i-1)=0; a(i)=0; aw=find(a);
       vect=vect(aw); vv=vv(aw,:); inv=inv(aw);
       vop=vop(aw); vectn=vectn(aw); a=a(aw);
       break
      end
     end
     nk=nk+1;
    end
    if isempty(var), var='s'; end
    if er~=1
     aa=stf(N,D,K,var,name);
     fprintf('\n')
     if aa==1, tfg(name), end
    end
   end
  end
 end
end
% --- last line of tfi_main ---
