function tfeval(arg1,arg2,arg3,arg4)
%TFEVAL   Valutazione di una funzione di trasferimento (TFI).
%   TFEVAL,gi - da TFI [TFEVAL('gi') - da Matlab] mostra il valore
%   della funzione di trasferimento gi corrispondente ad un valore
%   dell'argomento s o z (specificato in interattivo).
%   TFEVAL('gi','N') - da Matlab mostra il valore di gi in N.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin; j=sqrt(-1);
if nargs==0
 flg=0;
 while flg==0
  gi=input('\n   specificare la funzione di trasferimento : ','s');
  if ~isempty(gi)
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1;
   end
  end
 end
else
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1;
 end
end
[z,p,k,str]=exportf(gi,1); if isempty(k), return, end
nz=length(z); np=length(p); tol=10^(-8);
%
%   elimination of common zeros and poles
%
iz=ones(nz,1); ip=ones(np,1);
for kk=1:nz
 for kh=1:np
  if (abs(z(kk)-p(kh))<=tol)&(ip(kh)~=0)
   iz(kk)=0; ip(kh)=0; break
  end
 end
end
z=z(find(iz)); p=p(find(ip)); nz=length(z); np=length(p);
%
flg=0;
while flg==0
 if nargs < 2
  w=input(['\n   valore di ',str,' (invio per uscire) : ']);
  if length(w)==0, return, end
 else
  err=0;
  if any(arg2==','), err=1; else, eval(['w=',arg2,';'],'err=1;'); end
  if max(size(w))~=1 | err==1
   disp(' '), disp(' **** argomento non consentito'), return
  end
  flg=1;
 end
 if k>=0, mag=k; phi=0; else, mag=abs(k); phi=-pi; end
 for kk=1:np
  if abs(w-p(kk))>10^(-8)
   mag=mag/abs(w-p(kk)); phi=phi-angle(w-p(kk));
  else
   mag=mag/eps; phi=phi-pi/2;
  end
 end
 for kk=1:nz
  mag=mag*abs(w-z(kk)); phi=phi+angle(w-z(kk));
 end
 y=mag*exp(j*phi);
 ry=real(y); iy=imag(y);
 phi=angle(ry+j*iy);
 if (abs(phi)<10^(-8)), phi=0; end
 if mag>10^8
  mag=Inf;
  cn=exp(j*phi); rcn=real(cn); icn=imag(cn);
  if abs(rcn)<10^(-8), ry=0; iy=Inf*icn; end
  if abs(icn)<10^(-8), iy=0; ry=Inf*rcn; end
 end
 phi=phi*180/pi;
 disp(' ')
 rr=real(w); ii=imag(w);
 fprintf(['   valore di ',gi,'('])
 if abs(rr)<=tol & abs(ii)<=tol, fprintf('0'), end
 if abs(rr)>tol, fprintf('%.4g',rr), end
 if abs(ii)>tol
  if ii >= 0, ss=' + '; else, ss=' - '; end
  if (abs(rr)<=tol)&(ss==' + '), ss=[]; end
  fprintf([ss,'%.4gi'],abs(ii))
 end
 fprintf('): ')
 if (abs(ry)<=tol)&(abs(iy)<=tol), fprintf('0'), end
 if abs(ry)>tol, fprintf('%.4g',ry), end
 if abs(iy)>tol
  if iy >= 0, ss=' + '; else, ss=' - '; end
  if (abs(ry)<=tol)&(ss==' + '), ss=[]; end
  fprintf([ss,'%.4gi'],abs(iy))
 end
 fprintf('\n   modulo: %.4g ',mag)
 fprintf('(%.4g db);',20*log10(mag))
 fprintf(' argomento: %.4g gradi ',phi)
 fprintf('(%.4g radianti)\n',phi*pi/180)
end
% ----- end line of tfeval -----
