function tfblocks(type,bl1,bl2,bl3,bl4,sc1,sc2,sc3,sc4,sc5,sc6)
%TFBLOCKS Displays some simple block diagrams for TFI applications.
%   TFBLOCKS(type,bl1,bl2,bl3,bl4,sc1,sc2,sc3,sc4,sc5,sc6) creates a
%   medium-size block diagram in the right upper corner of the screen:
%   type ranges from 1 to 6, bl1,bl2,... are the inscriptions in the
%   blocks and sc1,sc2,... those referring to the connections.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

clf, nfig=gcf; % col='c'; % here it is possible to change color
set(nfig,'Menubar','none')
colbg=get(0,'DefaultAxesColor');
if colbg(1)==0, col='c'; else, col='b'; end
VV=[0,200,0,150];
rx=1.5*(VV(2)-VV(1))/(2*25); ry=1.5*(VV(4)-VV(3))/(1.5*25);
%
% Blocks and lines dimensions
Lb=24; Hb=18; Ll=18; Dj=8; Lt1=20; Lt2=24; Ht1=30; Ht2=40;
% Number of letter in x-size (Nl=44 medium, Nl=70 large)
Nl=44; Sl=(VV(2)-VV(1))/Nl; Hl=8*(VV(2)-VV(1))/200;
% Font size
AA=get(0,'ScreenSize');
if AA(3)<700
 fontsize=10;
else
 fontsize=8;
end
%
if (type==1)|(type==2)
 Ldraw=Dj+Lt1+Lt2+Ll+Lb;
 xa=(200-Ldraw)/2; ya=100;
elseif (type==3)|(type==4)
 Ldraw=Dj+Lt1+Lt2+2*Ll+2*Lb;
 xa=(200-Ldraw)/2; ya=100;
else
 Ldraw=Dj+Lt1+Lt2+3*Ll+3*Lb;
 xa=(200-Ldraw)/2; ya=100;
end
if (type==1)|(type==3)|(type==5)
 Lfeed=Ldraw-Lt1-Lt2/2-Dj/2; arr=0;
else
 Lfeed=Ldraw-Lt1-Lt2/2-Dj-Lb-Ll; arr=1;
end
if type==1, sct=sc3; end
if type==2, sct=sc3; blf=bl2; scf=sc4; end
if type==3, sct=sc4; end
if type==4, sct=sc4; blf=bl3; scf=sc5; end
if type==5, sct=sc5; end
if type==6, sct=sc5; blf=bl4; scf=sc6; end
%
xc=xa; yc=ya;
%
% initial line with label
x=[xc,xc+Lt1]; y=[yc,yc];
plot(x,y,['-',col])
hold on %%%% only in the first line
arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
text(xc+Lt1/2-Sl*length(sc1)/2,yc+Hl,sc1,...
'FontSize',fontsize,'Interpreter','none')
xc=xc+Lt1;
%
% summing junction with + and -
ang=2*pi*linspace(0,1,40); xcir=Dj/2*cos(ang); ycir=Dj/2*sin(ang);
plot(xc+Dj/2+xcir,yc+ycir,['-',col])
text(xc-Hl-Sl/2,yc-Hl,'+','FontSize',fontsize,'Interpreter','none')
text(xc-Sl,yc-1.5*Hl,'_','FontSize',fontsize,'Interpreter','none')
xc=xc+Dj;
%
% line with label
x=[xc,xc+Ll]; y=[yc,yc];
plot(x,y,['-',col])
arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
text(xc+Ll/2-Sl*length(sc2)/2,yc+Hl,sc2,...
'FontSize',fontsize,'Interpreter','none')
xc=xc+Ll;
%
% block with label
x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
plot(x,y,['-',col])
text(xc+Lb/2-Sl*length(bl1)/2,yc,bl1,...
'FontSize',fontsize,'Interpreter','none')
xc=xc+Lb; xf2=xc;
%
if type>2
% line with label
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Ll/2-Sl*length(sc3)/2,yc+Hl,sc3,...
 'FontSize',fontsize,'Interpreter','none')
 xc=xc+Ll;
%
% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl2)/2,yc,bl2,...
 'FontSize',fontsize,'Interpreter','none')
 xc=xc+Lb;
end
%
if type>4
 % line with label
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Ll/2-Sl*length(sc4)/2,yc+Hl,sc4,...
 'FontSize',fontsize,'Interpreter','none')
 xc=xc+Ll;
%
% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl3)/2,yc,bl3,...
 'FontSize',fontsize,'Interpreter','none')
 xc=xc+Lb;
end
%
% terminal line with label
x=[xc,xc+Lt2]; y=[yc,yc];
plot(x,y,['-',col])
arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
text(xc+Lt2/2-Sl*length(sct)/2,yc+Hl,sct,...
'FontSize',fontsize,'Interpreter','none')
xc=xc+Lt2/2;
%
% vertical line
x=[xc,xc]; y=[yc,yc-Ht2];
plot(x,y,['-',col])
xc=xc; yc=yc-Ht2;
%
% feedback line
x=[xc,xc-Lfeed]; y=[yc,yc];
plot(x,y,['-',col])
if arr==1, arrowl(x(1),y(1),x(2),y(2),rx,ry,col), end
xc=xc-Lfeed;
%
if (type==2)|(type==4)|(type==6)
% feedback block with label
 x=[xc,xc-Lb,xc-Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc-Lb/2-Sl*length(blf)/2,yc,blf,...
 'FontSize',fontsize,'Interpreter','none')
 xc=xc-Lb;
%
% feedback line with label
 x=[xc,xc-Ll-Dj/2]; y=[yc,yc];
 plot(x,y,['-',col])
 text(xc-Ll/2-Sl*length(scf)/2,yc+Hl,scf,...
 'FontSize',fontsize,'Interpreter','none')
 xc=xc-Ll-Dj/2;
end
%
% vertical closing line
x=[xc,xc]; y=[yc,yc+Ht2-Dj/2];
plot(x,y,['-',col])
arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
%
axis(VV), set(gca,'xtick',[],'ytick',[])
ordf(2)
%
xc=[2,198,198,2,2]; yc=[2,2,148,148,2]; plot(xc,yc,['-',col])
mess='schema a blocchi';
text(VV(1)+.34*(VV(2)-VV(1)),VV(3)+.08*(VV(4)-VV(3)),mess,...
'FontSize',fontsize+2,'Interpreter','none')
figure(nfig), hold off
xxx=input('\n   **** premere invio per proseguire ','s');
err=0; eval('set(nfig,''Menubar'',''figure'')','err=1;')
% --- last line of tfblocks ---
