function tfblff(arg1,bl1,bl2,bl3,bl4,bl5,bl6)
%TFBLFF   Block diagrams of a discrete perfect tracking feedforward unit.
%   TFBLFF(type,bl1,bl2,bl3,bl4) creates a medium-size block diagram in the
%   right upper corner of the screen: type ranges from 0 to 4, while
%   bl1,bl2,...,bl6 are the inscriptions in the blocks.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

clf, nfig=gcf; % col='c'; % here it is possible to change color
set(nfig,'Menubar','none')
colbg=get(0,'DefaultAxesColor');
if colbg(1)==0, col='c'; else, col='b'; end
VV=[0,200,0,150];
rx=1.5*(VV(2)-VV(1))/(2*25); ry=1.5*(VV(4)-VV(3))/(1.5*25);
%
% Blocks and lines dimensions
Lb=24; Hb=18; Ll=12; Dj=8; Lt1=24; Ht1=30; Ht2=40; Lb1=20; Hb1=16; Lt2=20;
% Number of letter in x-size (Nl=44 medium, Nl=70 large)
Nl=44; Sl=(VV(2)-VV(1))/Nl; Hl=8*(VV(2)-VV(1))/200;
% Font size
SS=get(0,'ScreenSize');
if SS(3)<700
 fontsize=9;
else
 fontsize=8;
end
if arg1==0, type=2; flgp=0; else, type=arg1; flgp=1; end

if type==1

 Ldraw=Lt1+Lb1+Lt1+Lb1+Lt2+Dj+Ll+Lb+Ll+Dj+Ll;
 xa=(200-Ldraw)/2; ya=60;

 xc=xa; yc=ya;

% initial line
 x=[xc,xc+Lt1]; y=[yc,yc];
 plot(x,y,['-',col])
 hold on % only in the first line
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Lt1/4-Sl*length('x')/2,yc+Hl,'x','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lt1;

% small block with label
 x=[xc,xc+Lb1,xc+Lb1,xc,xc]; y=[yc-Hb1/2,yc-Hb1/2,yc+Hb1/2,yc+Hb1/2,yc-Hb1/2];
 plot(x,y,['-',col])
 text(xc+Lb1/2-Sl*length('D_p')/2,yc,'D_p','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb1; xf2=xc;

% long line
 x=[xc,xc+Lt1]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 xc=xc+Lt1;

 xc1=xc-Lt1/2;

% small block with label
 x=[xc,xc+Lb1,xc+Lb1,xc,xc]; y=[yc-Hb1/2,yc-Hb1/2,yc+Hb1/2,yc+Hb1/2,yc-Hb1/2];
 plot(x,y,['-',col])
 text(xc+Lb1/2-Sl*length('D_r')/2,yc,'D_r','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb1; xf2=xc;

% medium line
 x=[xc,xc+Lt2]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Lt2/2-Sl*length('r')/2,yc+Hl,'r','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lt2;

% summing junction with + and -
 ang=2*pi*linspace(0,1,40); xcir=Dj/2*cos(ang); ycir=Dj/2*sin(ang);
 plot(xc+Dj/2+xcir,yc+ycir,[':',col])
 text(xc-Hl,yc-Hl,'+','FontSize',fontsize,'Interpreter','none')
 text(xc-Sl,yc-1.5*Hl,'_','FontSize',fontsize,'Interpreter','none')
 xc=xc+Dj;

% vertical closing line
 x=[xc-Dj/2,xc-Dj/2]; y=[yc-Lt1,yc-Dj/2];
 plot(x,y,[':',col])
 text(xc+Sl*length('y')/2,yc-Lt1+Hl,'y','FontSize',fontsize,...
 'Interpreter','none')
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,[':',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 xc=xc+Ll;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,[':',col])
 text(xc+Lb/2-Sl*length(bl1)/2,yc,bl1,'FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb; xf2=xc;

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,[':',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 xc=xc+Ll;

% summing junction with + and +
 ang=2*pi*linspace(0,1,40); xcir=Dj/2*cos(ang); ycir=Dj/2*sin(ang);
 plot(xc+Dj/2+xcir,yc+ycir,[':',col])
 text(xc-Hl,yc-Hl,'+','FontSize',fontsize,'Interpreter','none')
 text(xc-Sl,yc+1.5*Hl,'+','FontSize',fontsize,'Interpreter','none')
 xc=xc+Dj;

 xc2=xc-Dj/2;

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,[':',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Ll/2-Sl*length('u')/2,yc+Hl,'u','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Ll;

% inner feedforward connection

 xc=xc1; yc=ya;

% vertical line
 x=[xc,xc]; y=[yc,yc+Ht1+Dj];
 plot(x,y,['-',col])
 xc=xc; yc=yc+Ht1+Dj;

% line
 x=[xc,xc+Ll+Dj]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 xc=xc+Ll+Dj;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length('g_s')/2,yc,'g_s','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb;

% long line
 x=[xc,xc+Lt1]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Lt1/2-Sl*length('u_s')/2,yc+Hl,'u_s','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lt1;

% summing junction with + and +
 ang=2*pi*linspace(0,1,40); xcir=Dj/2*cos(ang); ycir=Dj/2*sin(ang);
 plot(xc+Dj/2+xcir,yc+ycir,['-',col])
 text(xc-Hl,yc-Hl,'+','FontSize',fontsize,'Interpreter','none')
 text(xc-Sl,yc+1.5*Hl,'+','FontSize',fontsize,'Interpreter','none')
 xc=xc+Dj;

 xc3=xc-Dj/2; yc3=yc;

% feedforward line
 x=[xc,xc2]; y=[yc,yc];
 plot(x,y,['-',col])
 text(xc+Ll-Sl*length('u_c')/2,yc+Hl,'u_c','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc2;

% vertical closing line
 x=[xc,xc]; y=[yc,yc-Ht1-Dj+Dj/2];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)

% outer feedforward connection

 xc=xa+Lt1/2; yc=ya;

% vertical line
 x=[xc,xc]; y=[yc,yc+Ht2+Ll+Dj];
 plot(x,y,['-',col])
 xc=xc; yc=yc+Ht2+Ll+Dj;

% line
 x=[xc,xc+Ll+Dj]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 xc=xc+Ll+Dj;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length('g_p')/2,yc,'g_p','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb;

% feedforward line
 x=[xc,xc3]; y=[yc,yc];
 plot(x,y,['-',col])
 text(xc+Ll-Sl*length('u_p')/2,yc+Hl,'u_p','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc3;

% vertical closing line
 x=[xc,xc]; y=[yc,yc3+Dj/2];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)

 mess='D_r: ritardo gr. relativo, g_s: comp. zeri stabili.';
 text(VV(1)+.03*(VV(2)-VV(1)),VV(3)+.18*(VV(4)-VV(3)),mess,...
 'FontSize',fontsize,'Interpreter','none')
 mess='D_p: ritardo preazione, g_p: comp. zeri instabili.';
 text(VV(1)+.03*(VV(2)-VV(1)),VV(3)+.08*(VV(4)-VV(3)),mess,...
 'FontSize',fontsize,'Interpreter','none')

elseif type==2

 Ldraw=Lt1+Lb+Ll+Dj+Ll+Lb+Ll+Dj+Ll+Lb+Lt1;
 xa=(200-Ldraw)/2; ya=80;

 xc=xa; yc=ya;

% initial line
 x=[xc,xc+Lt1]; y=[yc,yc];
 plot(x,y,['-',col])
 hold on % only in the first line
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Lt1/4-Sl*length('x')/2,yc+Hl,'x','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lt1;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl3)/2,yc,bl3,'FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb; xf2=xc;

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Ll/2-Sl*length('r')/2,yc+Hl,'r','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Ll;

% summing junction with + and -
 ang=2*pi*linspace(0,1,40); xcir=Dj/2*cos(ang); ycir=Dj/2*sin(ang);
 plot(xc+Dj/2+xcir,yc+ycir,['-',col])
 text(xc-Hl,yc-Hl,'+','FontSize',fontsize,'Interpreter','none')
 text(xc-Sl,yc-1.5*Hl,'_','FontSize',fontsize,'Interpreter','none')
 xc=xc+Dj;

 xc1=xc-Dj/2;

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Ll/2-Sl*length('e')/2,yc+Hl,'e','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Ll;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl1)/2,yc,bl1,'FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb; xf2=xc;

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 xc=xc+Ll;

% summing junction with + and +
 ang=2*pi*linspace(0,1,40); xcir=Dj/2*cos(ang); ycir=Dj/2*sin(ang);
 plot(xc+Dj/2+xcir,yc+ycir,['-',col])
 text(xc-Hl,yc-Hl,'+','FontSize',fontsize,'Interpreter','none')
 text(xc-Sl,yc+1.5*Hl,'+','FontSize',fontsize,'Interpreter','none')
 xc=xc+Dj;

 xc2=xc-Dj/2; yc2=yc;

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Ll/2-Sl*length('u')/2,yc+Hl,'u','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Ll;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl2)/2,yc,bl2,'FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb;

% terminal line
 x=[xc,xc+Lt1]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+3*Lt1/4-Sl*length('y')/2,yc+Hl,'y','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lt1/2;

% vertical line
 x=[xc,xc]; y=[yc,yc-Ht2];
 plot(x,y,['-',col])
 xc=xc; yc=yc-Ht2;

% feedback line
 x=[xc,xc1]; y=[yc,yc];
 plot(x,y,['-',col])
 xc=xc1;

% vertical closing line
 x=[xc,xc]; y=[yc,yc+Ht2-Dj/2];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)

% feedforward connection

 xc=xa+Lt1/2; yc=ya;

% vertical line
 x=[xc,xc]; y=[yc,yc+Ht2];
 plot(x,y,['-',col])
 xc=xc; yc=yc+Ht2;

% line
 x=[xc,xc+Ll+Dj]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 xc=xc+Ll+Dj;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl4)/2,yc,bl4,'FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb;

% feedforward line
 x=[xc,xc2]; y=[yc,yc];
 plot(x,y,['-',col])
 text(xc+Ll-Sl*length('u_c')/2,yc+Hl,'u_c','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc2;

% vertical closing line
 x=[xc,xc]; y=[yc,yc2+Dj/2];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)

 if flgp==1
  mess='il compensatore ad azione in avanti : ';
  text(VV(1)+.04*(VV(2)-VV(1)),VV(3)+.18*(VV(4)-VV(3)),mess,...
  'FontSize',fontsize,'Interpreter','none')
  mess=[bl3,' = D_p D_r ;  ',bl4,' = g_p + D_p g_s'];
  text(VV(1)+.04*(VV(2)-VV(1)),VV(3)+.08*(VV(4)-VV(3)),mess,...
  'FontSize',fontsize,'Interpreter','none')
 else
  xc=[2,198,198,2,2]; yc=[2,2,148,148,2]; plot(xc,yc,['-',col])
  mess='schema a blocchi';
  text(VV(1)+.34*(VV(2)-VV(1)),VV(3)+.08*(VV(4)-VV(3)),mess,...
  'FontSize',fontsize+2,'Interpreter','none')
 end

elseif type==3

 Ldraw=Lt2+Lb+Ll+Dj+Ll+Lb+Lt2+Lb+Lt1;
 xa=(200-Ldraw)/2; ya=100;

 xc=xa; yc=ya;

% initial line
 x=[xc,xc+Lt2]; y=[yc,yc];
 plot(x,y,['-',col])
 hold on % only in the first line
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Lt2/4-Sl*length('x')/2,yc+Hl,'x','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lt2;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl5)/2,yc,bl5,'FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb; xf2=xc;

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Ll/2-Sl*length('r')/2,yc+Hl,'r','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Ll;

% summing junction with + and -
 ang=2*pi*linspace(0,1,40); xcir=Dj/2*cos(ang); ycir=Dj/2*sin(ang);
 plot(xc+Dj/2+xcir,yc+ycir,['-',col])
 text(xc-Hl,yc-Hl,'+','FontSize',fontsize,'Interpreter','none')
 text(xc-Sl,yc-1.5*Hl,'_','FontSize',fontsize,'Interpreter','none')
 xc=xc+Dj;

 xc1=xc-Dj/2;

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Ll/2-Sl*length('e')/2,yc+Hl,'e','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Ll;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl1)/2,yc,bl1,'FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb; xf2=xc;

% line
 x=[xc,xc+Lt2]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Lt2/2-Sl*length('u')/2,yc+Hl,'u','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lt2;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl2)/2,yc,bl2,'FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb;

% terminal line
 x=[xc,xc+Lt1]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+3*Lt1/4-Sl*length('y')/2,yc+Hl,'y','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lt1/2;

% vertical line
 x=[xc,xc]; y=[yc,yc-Ht2];
 plot(x,y,['-',col])
 xc=xc; yc=yc-Ht2;

% feedback line
 x=[xc,xc1]; y=[yc,yc];
 plot(x,y,['-',col])
 xc=xc1;

% vertical closing line
 x=[xc,xc]; y=[yc,yc+Ht2-Dj/2];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)

 mess='il compensatore ad azione in avanti : ';
 text(VV(1)+.04*(VV(2)-VV(1)),VV(3)+.18*(VV(4)-VV(3)),mess,...
 'FontSize',fontsize,'Interpreter','none')
 mess=[bl5,' = ',bl3,' + ',bl4,'/',bl1];
 text(VV(1)+.04*(VV(2)-VV(1)),VV(3)+.08*(VV(4)-VV(3)),mess,...
 'FontSize',fontsize,'Interpreter','none')

elseif type==4

 Ldraw=Lt1+Lb+Ll+Dj+Ll+Lb+Lt1;
 xa=(200-Ldraw)/2; ya=110;

 xc=xa; yc=ya;

% initial line
 x=[xc,xc+Lt1]; y=[yc,yc];
 plot(x,y,['-',col])
 hold on % only in the first line
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Lt1/4-Sl*length('x')/2,yc+Hl,'x','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lt1;

 xc1=xa+Lt1-Ll;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl5)/2,yc,bl5,'FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb; xf2=xc;

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Ll/2-Sl*length('r')/2,yc+Hl,'r','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Ll;

% summing junction with + and -
 ang=2*pi*linspace(0,1,40); xcir=Dj/2*cos(ang); ycir=Dj/2*sin(ang);
 plot(xc+Dj/2+xcir,yc+ycir,['-',col])
 text(xc-Hl,yc-Hl,'+','FontSize',fontsize,'Interpreter','none')
 text(xc-Sl,yc-1.5*Hl,'_','FontSize',fontsize,'Interpreter','none')
 xc=xc+Dj;

 xc2=xc-Dj/2;

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+Ll/2-Sl*length('u')/2,yc+Hl,'u','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Ll;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl2)/2,yc,bl2,'FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb; xf2=xc;

% terminal line
 x=[xc,xc+Lt1]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 text(xc+3*Lt1/4-Sl*length('y')/2,yc+Hl,'y','FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lt1/2;

% vertical line
 x=[xc,xc]; y=[yc,yc-Ht1-Ht1];
 plot(x,y,['-',col])
 xc=xc; yc=yc-Ht1-Ht1;

% feedback line
 x=[xc,xc1]; y=[yc,yc];
 plot(x,y,['-',col])
 xc=xc1;

% vertical closing line
 x=[xc,xc]; y=[yc,yc+Ht1];
 plot(x,y,['-',col])
 yc=yc+Ht1;

% line
 x=[xc,xc+Ll]; y=[yc,yc];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)
 xc=xc+Ll;

% block with label
 x=[xc,xc+Lb,xc+Lb,xc,xc]; y=[yc-Hb/2,yc-Hb/2,yc+Hb/2,yc+Hb/2,yc-Hb/2];
 plot(x,y,['-',col])
 text(xc+Lb/2-Sl*length(bl6)/2,yc,bl6,'FontSize',fontsize,...
 'Interpreter','none')
 xc=xc+Lb; xf2=xc;

% line
 x=[xc,xc+Ll+Dj/2]; y=[yc,yc];
 plot(x,y,['-',col])
 xc=xc+Ll+Dj/2;

% vertical closing line
 x=[xc,xc]; y=[yc,yc+Ht1-Dj/2];
 plot(x,y,['-',col])
 arrowl(x(1),y(1),x(2),y(2),rx,ry,col)

 mess='il compensatore ad azione in avanti : ';
 mess=[mess,bl5,' = ',bl3,' ',bl1,' + ',bl4];
 text(VV(1)+.04*(VV(2)-VV(1)),VV(3)+.18*(VV(4)-VV(3)),mess,...
 'FontSize',fontsize,'Interpreter','none')

 mess=['l''unit',setstr(224),' in retroazione : '];
 mess=[mess,bl6,' = ',bl1];
 text(VV(1)+.04*(VV(2)-VV(1)),VV(3)+.08*(VV(4)-VV(3)),mess,...
 'FontSize',fontsize,'Interpreter','none')

end

axis(VV), set(gca,'xtick',[],'ytick',[])

ordf(2)
if (type==2)&(flgp==1)
 VVS=get(gcf,'Position'); VVS(1)=VVS(1)-12;
 set(gcf,'Position',VVS)
elseif type==3
 VVS=get(gcf,'Position'); VVS(1)=VVS(1)-24;
 set(gcf,'Position',VVS)
end
%
xc=[2,198,198,2,2]; yc=[2,2,148,148,2]; plot(xc,yc,['-',col])
figure(nfig), hold off
xyx=input('\n   **** premere invio per proseguire ','s');
%ordf(1)
% --- last line of tfblff ---
