function c=sumpol(a,b)
%SUMPOL   Sum of two polynomials.
%   c = SUMPOL(a,b) returns in c the sum of polynomials a and b.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

error(nargchk(2,2,nargin));
na=length(a); nb=length(b);
if any(a)==0
 a=0; na=1;
end
if any(b)==0
 b=0; nb=1;
end
if na > nb
 b=[zeros(1,na-nb) b];
elseif nb > na
 a=[zeros(1,nb-na) a];
end
c=a+b;
% --- last line of sumpol ---
