function sumgm(gi,gj,gk,opt)
%SUMGM	  Sum or difference of transfer functions.
%   SUMGM('gi','gj','gk',0) computes the sum gi+gj
%			    and saves the result in gk.mat;
%   SUMGM('gi','gj','gk',1) computes the difference gi-gj
%			    and saves the result in gk.mat.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(4,4,nargs));
if ~exist([gi,'.mat'])
 error([' **** error: ',gi,'.mat does not exist'])
end
if ~exist([gj,'.mat'])
 error([' **** error: ',gj,'.mat does not exist'])
end
[Numi,Deni,ki,stri]=ltf(gi);
[Numj,Denj,kj,strj]=ltf(gj);
if ~strcmp(stri,strj)
 error(' **** error: conflict between continuous and discrete-time')
end
[Numk,Denk,kk]=sumg(Numi,Deni,ki,Numj,Denj,kj,opt);
aa=stf(Numk,Denk,kk,stri,gk);
% --- last line of sumgm ---
