function [Num,Den,k]=sumg(Num1,Den1,k1,Num2,Den2,k2,opt)
%SUMG	  Sum or difference of transfer functions (aux for TFI).
%   [Num,Den,k]=SUMG(Num1,Den1,k1,Num2,Den2,k2,opt)
%   if opt=0, SUMG gives the sum G1+G2,
%   if opt=1, SUMG gives the difference G1-G2,
%   with G1=k1*Num1/Den1;  G2=k2*Num2/Den2.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(7,7,nargs));
[Num1,Den1,k1]=ridg(Num1,Den1,k1);
[Num2,Den2,k2]=ridg(Num2,Den2,k2);
ln1=size(Num1); ln2=size(Num2);
ld1=size(Den1); ld2=size(Den2);
if (ln1==[1,1])&(ld1==[1,1])&(k1==0)
 Num=Num2; Den=Den2;
 if opt==0, k=k2; else, k=-k2; end
elseif (ln2==[1,1])&(ld2==[1,1])&(k2==0)
 Num=Num1; Den=Den1;
 if opt==0, k=k1; else, k=-k1; end
else
 l=max([ln1(2),ld1(2),ln2(2),ld2(2)]);
 if l>ln1(2), Num1=[zeros(ln1(1),l-ln1(2)) Num1]; end
 if l>ld1(2), Den1=[zeros(ld1(1),l-ld1(2)) Den1]; end
 if l>ln2(2), Num2=[zeros(ln2(1),l-ln2(2)) Num2]; end
 if l>ld2(2), Den2=[zeros(ld2(1),l-ld2(2)) Den2]; end
 [Denk1 Denk2 kk]=ridg(Den1,Den2,1); ldk1=size(Denk1); ldk2=size(Denk2);
 if l>ldk2(2), Denk2=[zeros(ldk2(1),l-ldk2(2)),Denk2]; end
 Numk1=[Num1;Denk2]; N1=1;
 for i=1:(ln1(1)+ldk2(1))
  N1=conv(N1,Numk1(i,:));
 end
 if l>ldk1(2), Denk1=[zeros(ldk1(1),l-ldk1(2)),Denk1]; end
 Numk2=[Num2;Denk1]; N2=1;
 for i=1:(ln2(1)+ldk1(1))
  N2=conv(N2,Numk2(i,:));
 end
 if opt==0 %  addition
  Num=sumpol(N1*k1,N2*k2);
 elseif opt==1 %  subtraction
  Num=sumpol(N1*k1,-N2*k2);
 end
 q=find(Num~=0);
 if length(q)~=0
  k=Num(q(1)); Num=Num(q(1):length(Num))/k; Den=[Den1;Denk2];
  [Num,Den,k]=ridg(Num,Den,k);
 else
  Num=1; Den=1; k=0;
 end
end
% --- last line of sumg ---
