function select(arg1,arg2,arg3,arg4)
%SELECT   Selezione di fattori da una funzione di trasferimento (TFI).
%    SELECT,gi,gj - da TFI [SELECT('gi,'gj') - da Matlab] consente la
%    selezione interattiva di fattori di gi e li salva come gj.
%    Se SELECT viene chiamato senza alcun argomento, le f.d.t. gi e gj
%    possono essere specificate in modo interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

eA=setstr(232);
if nargin==0
 flg=0;
 while flg==0
  gi=input('\n   funzione di trasferimento gi (ingresso) : ','s');
  if ~isempty(gi)
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1;
   end
  end
 end
 while flg==1
  gj=input('\n   funzione di trasferimento gj (uscita) : ','s');
  if ~isempty(gj), flg=2; end
 end
elseif nargin>=2
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1; gj=arg2;
 end
else
 disp(' **** errore: numero di argomenti non sufficiente'), return
end
clc
eval(['load ',gi])
sn=size(Numc); sd=size(Denc); Numc=[zeros(1,sn(2)-1),kc;Numc]; sn(1)=sn(1)+1;
%  Ko : the old dc gain
if strc=='s'
 Ko=Numc(1,sn(2));
 if sn(1)>1
  vvn=Numc(2:sn(1),sn(2)); vvn=vvn(find(vvn~=0));
  for kk=1:length(vvn), Ko=Ko*vvn(kk); end
 end
 vvd=Denc(:,sd(2)); vvd=vvd(find(vvd~=0));
 for kk=1:length(vvd), Ko=Ko/vvd(kk); end
else
 Ko=Numc(1,sn(2));
 if sn(1)>1
  vvn=(sum(Numc(2:sn(1),:)'))'; vvn=vvn(find(vvn~=0));
  for kk=1:length(vvn), Ko=Ko*vvn(kk); end
 end
 vvd=(sum(Denc'))'; vvd=vvd(find(vvd~=0));
 for kk=1:length(vvd), Ko=Ko/vvd(kk); end
end
%
tfg(gi)
disp(' ')
fprintf('   numeratore:')
flg=0; Num=1;
while flg==0
 s=input('\n   scegliere i fattori 1,2,..; * = tutti; invio = annulla : ','s');
 if length(s)~=0
  if s=='*'
   Num=Numc; flg=1;
  else
   s=s(find(s~=' '));
   a=zeros(1,sn(1)); x=[]; vect=[]; jj=0;
   for i=1:length(s)
    rop=((abs(s(i))>=49)&(abs(s(i))<=57));
    rop=rop|((abs(s(i))==48)&(length(x)~=0));
    rop=rop|(s(i)==',');
    if rop
     if s(i)~=','
      x=[x,s(i)];
     else
      vect=[vect,eval(x)]; x=[];
     end
    else
     jj=1; break
    end
   end
   if jj==0
    vect=[vect,eval(x)];
    if length(find(vect>sn(1)))==0
     a(vect)=ones(1,length(vect)); flg=1; Num=Numc(find(a),:);
    end
   end
  end
 else
  flg=1;
 end
end
disp(' ')
fprintf('   denominatore:')
flg=0; Den=1;
while flg==0
 s=input('\n   scegliere i fattori 1,2,..; * = tutti; invio = annulla : ','s');
 if length(s)~=0
  if s=='*'
   Den=Denc; flg=1;
  else
   s=s(find(s~=' '));
   a=zeros(1,sd(1)); x=[]; vect=[]; jj=0;
   for i=1:length(s)
    rop=((abs(s(i))>=49)&(abs(s(i))<=57));
    rop=rop|((abs(s(i))==48)&(length(x)~=0));
    rop=rop|(s(i)==',');
    if rop
     if s(i)~=','
      x=[x,s(i)];
     else
      vect=[vect,eval(x)]; x=[];
     end
    else
     jj=1; break
    end
   end
   if jj==0
    vect=[vect,eval(x)];
    if length(find(vect>sd(1)))==0
     a(vect)=ones(1,length(vect)); flg=1; Den=Denc(find(a),:);
    end
   end
  end
 else
  flg=1;
 end
end
%
sn=size(Num); sd=size(Den);
%  Kn : the new dc gain
if strc=='s'
 Kn=Num(1,sn(2));
 if sn(1)>1
  vvn=Num(2:sn(1),sn(2)); vvn=vvn(find(vvn~=0));
  for kk=1:length(vvn), Kn=Kn*vvn(kk); end
 end
 vvd=Den(:,sd(2)); vvd=vvd(find(vvd~=0));
 for kk=1:length(vvd), Kn=Kn/vvd(kk); end
else
 Kn=Num(1,sn(2));
 if sn(1)>1
  vvn=(sum(Num(2:sn(1),:)'))'; vvn=vvn(find(vvn~=0));
  for kk=1:length(vvn), Kn=Kn*vvn(kk); end
 end
 vvd=(sum(Den'))'; vvd=vvd(find(vvd~=0));
 for kk=1:length(vvd), Kn=Kn/vvd(kk); end
end
%
disp(' ')
mess=['   il guadagno statico della f.d.t. originaria (',gi,') ',eA,': '];
fprintf([mess,'%.4g\n'],Ko)
mess=['   il guadagno statico della f.d.t. selezionata (',gj,') ',eA,': '];
fprintf([mess,'%.4g\n'],Kn)
flg=0;
while (flg~=1)&(flg~=2)&(flg~=3)
 disp(' ')
 disp('   1 - mantenere il guadagno statico della f.d.t. originaria')
 disp('   2 - mantenere il guadagno statico della f.d.t. selezionata')
 disp('   3 - specificare un nuovo guadagno statico')
 flg=input('\n   operare una scelta : ');
 if length(flg)==0, flg=0; end
end
K=1;
if flg==1
 K=Ko/Kn;
elseif flg==3
 gain=input('\n   specificare il nuovo valore, invio per uscire : ');
 if length(gain)~=0
  K=gain/Kn;
 end
end
aa=stf(Num,Den,K,strc,gj);
if aa==1, tfg(gj), end
% --- last line of select ---
