function Y=satdfn(X)
%SATDFN   describing function of unit saturation (auxiliary for TFI).
%   Y=SATDFN(X) is the function: (2/pi)*(asin(1/X)+(1/X)*sqrt(1-(1/X)^2)).

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

Y=(2/pi)*(asin(1/X)+(1/X)*sqrt(1-(1/X)^2));
% ----- end line of satdfn -----
