function K1=routhd(arg1,arg2,arg3,arg4)
%ROUTHD   Stability intervals of discrete-time feedback systems.
%   ROUTHD(numd,dend,T)
%   ROUTHD(zd,pd,kd,T)
%   display the stability intervals of a discrete-time feedback system
%   as functions of the loop gain K. The characteristic equation is
%
%	  1 + K G(z) = 0
%
%   T denotes the sampling time, required for the w-plane transform:
%   since the result does not depend on it, you can set T:=1.
%   K=ROUTHD(...) also provides the bounds of the stability intervals
%   by rows in matrix K.
%   For continuous-time systems, use ROUTHC.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(3,4,nargs));
if nargs==3
 numd=arg1;dend=arg2;T=arg3; [zd,pd,kd]=tozpk(numd,dend);
else
 zd=arg1;pd=arg2;kd=arg3;T=arg4;
end
%
nap=6;
nz=length(zd); np=length(pd);
ii=find(abs(pd)~=0); np1=length(ii); np0=np-np1;
np1r=max((nz-np1),0); nde=np0-np1r;
if nde<nap
 [zw,pw,kw]=diwplane(zd,pd,kd,T);
else
%
%  (long delay)
%
 zd1=[]; pd1=zeros(nap,1); kd1=1;
 [zw1,pw1,kw1]=diwplane(zd1,pd1,kd1,T*nde/nap);
 zd2=zd; pd2=[pd(ii);zeros(np1r,1)]; kd2=kd;
 [zw2,pw2,kw2]=diwplane(zd2,pd2,kd2,T);
 zw=[zw1;zw2]; pw=[pw1;pw2]; kw=kw1*kw2;
end
if nargout==0
 routhc(zw,pw,kw); return
end
Ko=routhc(zw,pw,kw); K1=Ko;
% --- last line of routhd ---
