function K1=routhc(arg1,arg2,arg3)
%ROUTHC   Stability intervals of continuous-time feedback systems.
%   ROUTHC(num,den)
%   ROUTHC(z,p,K)
%   display the stability intervals of a continuous-time feedback system
%   as functions of the loop gain K. The characteristic equation is
%
%	 1 + K G(s) = 0
%
%   K=ROUTHC(...) provides the bounds of the stability intervals by rows
%   in matrix K.
%   For discrete-time systems, use ROUTHD.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(2,3,nargs));
if nargs==2
 num=arg1;den=arg2; [z,p,k]=tozpk(num,den);
else
 z=arg1;p=arg2;k=arg3; [num,den]=dezpk(z,p,k);
end
kkd=abs(k);
% scaling for better performance
num=num/kkd; den=den/kkd;
tol=10^(-8); Ko=[];
j=sqrt(-1);
%
%   Construction of the Routh array
%   ar : matrix of the array, with variable number of columns
%   ap : matrix of pointers
%   al : matrix of lengths
%
dnum=length(num)-1; dden=length(den)-1;
if dnum<=dden
 nn=[zeros(1,dden-dnum) num]; dd=den; n=dden;
else
 nn=num; dd=[zeros(1,dnum-dden) den]; n=dnum;
end
if n==0
 error('not a dynamic system in routh')
end
ap=zeros(n+1,n); ap(:,1)=ones(n+1,1); al=ones(n+1,n); lrow=zeros(1,n+1);
row1=[]; row2=[]; kp=0; kc=0;
while kp<n+1
 kp=kp+1;
 vv=sumpol(dd(kp),nn(kp)*[1 0]);
 kc=kc+1; row1=[row1 vv]; lrow(1)=lrow(1)+1; lvv=length(vv);
 ap(1,kc+1)=ap(1,kc)+lvv; al(1,kc)=lvv;
 if kp==n+1
  break
 end
 kp=kp+1;
 vv=sumpol(dd(kp),nn(kp)*[1 0]);
 row2=[row2 vv]; lrow(2)=lrow(2)+1; lvv=length(vv);
 ap(2,kc+1)=ap(2,kc)+lvv; al(2,kc)=lvv;
end
lr1=length(row1); lr2=length(row2); pp=max([lr1 lr2]); ar=zeros(n+1,pp);
if lr1>lr2
 row2=[row2 zeros(1,lr1-lr2)];
elseif lr2>lr1
 row1=[row1 zeros(1,lr2-lr1)];
end
ar(1,:)=row1; ar(2,:)=row2;
%
if any(row2)==0
 if nargout==0
  disp(' ')
  disp('   instabile o non strettamente stabile per ogni K')
  disp(' '), return
 end
 K1=Ko; return
end
for kr=3:n+1
 row=[]; ae1=ar(kr-2,1:al(kr-2,1)); ae2=ar(kr-1,1:al(kr-1,1));
 for kc=2:lrow(kr-2)
  be1=ar(kr-2,ap(kr-2,kc):ap(kr-2,kc)+al(kr-2,kc)-1);
  if kc<=lrow(kr-1)
   be2=ar(kr-1,ap(kr-1,kc):ap(kr-1,kc)+al(kr-1,kc)-1);
  else
   be2=0;
  end
  vv=sumpol(conv(ae2,be1),-conv(ae1,be2));
  row=[row vv]; lrow(kr)=lrow(kr)+1; lvv=length(vv);
  ap(kr,kc)=ap(kr,kc-1)+lvv; al(kr,kc-1)=lvv;
 end
 [mm,nn]=size(ar(1:kr-1,:)); lr1=nn; lr2=length(row);
 if lr1>lr2
  row=[row zeros(1,lr1-lr2)];
 elseif lr2>lr1
  ar=[ar zeros(n+1,lr2-lr1)];
 end
 ar(kr,:)=row;
end
%
%   Interpretation of the Routh array
%
vvint=j;
for kk=1:n+1
 vvint=[vvint;roots(ar(kk,1:al(kk,1)))];
end
vvint=vvint(find(imag(vvint)==0)); vvint=sort(vvint); lvv=length(vvint);
for kk=1:lvv
 if abs(vvint(kk))<tol
  vvint(kk)=0;
 end
end
if lvv==0
 if nargout==0
  disp(' ')
  disp('   instabile o non strettamente stabile per ogni K')
  disp(' '), return
 end
 K1=Ko; return
end
% elimination of multiple boundary points
vvint1=[vvint(1)];
for kr=2:lvv
 if abs(vvint(kr)-vvint(kr-1))>10^(-3)*abs(vvint(kr))
  vvint1=[vvint1;vvint(kr)];
 end
end
vvint=vvint1; lvv=length(vvint); delta=max(abs(vvint))*10^(-3)+tol;
vvint1=[vvint(1)-delta;vvint;vvint(lvv)+delta]; lvv1=length(vvint1);
hh=zeros(lvv1-1,1);
for kr=1:lvv1-1
 kk=(vvint1(kr+1)+vvint1(kr))/2; pp=sumpol(den,kk*num);
 hh(kr)=max(real(roots(pp)));
end
if hh(1)<0
 Ko=[Ko;[-inf,vvint(1)]];
end
for kr=2:lvv1-2
 if hh(kr)<0
  Ko=[Ko;[vvint(kr-1),vvint(kr)]];
 end
end
if hh(lvv1-1)<0
 Ko=[Ko;[vvint(lvv1-2),inf]];
end
[mKo,nn]=size(Ko);
if mKo>1
 Kl=Ko; Ko=[]; mm=zeros(1,2); mm(1)=Kl(1,1);
 for kk=1:mKo-1
  if Kl(kk,2)~=Kl(kk+1,1)
   mm(2)=Kl(kk,2); Ko=[Ko;mm]; mm(1)=Kl(kk+1,1);
  end
 end
 mm(2)=Kl(mKo,2); Ko=[Ko;mm];
end
[mKo,nn]=size(Ko);
disp(' ')
if nargout==0
 if mKo~=0
  for kk=1:mKo
   if Ko(kk,1)==-inf
    fprintf('   stabile per K nell''intervallo: da -infinito a %.4g',Ko(kk,2))
    fprintf('\n')
   elseif Ko(kk,2)==inf
    fprintf('   stabile per K nell''intervallo: da %.4g ad infinito',Ko(kk,1))
    fprintf('\n')
   else
    fprintf('   stabile per K nell''intervallo: ')
    fprintf('da %.4g a %.4g',Ko(kk,1),Ko(kk,2)), fprintf('\n')
   end
  end
 else
  disp('   instabile per ogni K')
 end
 return
end
K1=Ko;
% --- last line of routhc ---
