function routh(arg1,arg2,arg3,arg4)
%ROUTH	  Intervalli di stabilita' con il criterio di Routh (TFI).
%   ROUTH,gi - da TFI [ROUTH('gi') - da Matlab] visualizza gli intervalli
%   di stabilita' in funzione del guadagno di anello K per il sistema
%   in retroazione a tempo continuo o discreto con f.d.t. di anello gi.
%   L'equazione caratteristica considerata e':
%
%	    1 + K gi(s) = 0   o   1 + K gi(z) = 0
%
%   Nel caso a tempo discreto ci si riferisce al cerchio unitario.
%   Se ROUTH viene chiamato senza alcun argomento, la f.d.t. gi puo'
%   essere specificata in interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

if nargin==0
 flg=0;
 while flg==0
  gi=input('\n   specificare la funzione di trasferimento : ','s');
  if ~isempty(gi)
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1;
   end
  end
 end
else
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1;
 end
end
[z,p,k,str]=exportf(gi,1); if isempty(k), return, end
if max(length(p),length(z))==0
 eA=setstr(232);
 disp(' '), disp([' **** errore: ',gi,' non ',eA,' un sistema dinamico'])
 return
end
figure, nnf=gcf; tfblocks(3,'K',gi,'','','','','','','','')
err=0; eval('delete(nnf)','err=1;')
disp(' ')
fprintf('   equazione caratteristica:')
if strcmp(str,'s')
 disp(['   1 + K ',gi,'(s) = 0 ;'])
 routhc(z,p,k)
else
 disp(['   1 + K ',gi,'(z) = 0 ;'])
 routhd(z,p,k,lsamp)
end
% --- last line of routh ---
