function [rrm,kkm]=rootlc(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8)
%ROOTLC   Root locus for continuous-time systems.
%   ROOTLC(num,den,stp,col) plots the locus of the roots of
%
%      den(s) + k * num(s) = 0,   k >= 0 .
%
%   Parameters stp & col (optional) define the relative step of plot and
%   color: col must be a string variable ('g'=green, 'b'=blue, 'r'=red,
%   'w'=white, 'y'=yellow, 'c'=cyan, 'm'=magenta).
%   Default is stp=1, col='g'. External definition of axes is allowed.
%   [rmul,kmul]=ROOTLC(num,den,stp,col) outputs the values of the
%   branching points and corresponding k.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global HALEG

nargs=nargin; rev=0;
error(nargchk(2,8,nargs));
if nargs==2
 stp=1; col='g';
elseif nargs==3
 if isstr(arg3)
  stp=1; col=arg3;
 else
  stp=arg3; col='g';
 end
elseif nargs==4
 stp=arg3; col=arg4;
end
if nargs<7
 if length(arg1)<=length(arg2)
  num=arg1; den=arg2;
 else
  num=arg2; den=arg1; rev=1;
 end
 z=roots(num); p=roots(den);
else
 if length(arg1)<=length(arg2)
  z=arg1; p=arg2; k=arg3; stp=arg4; col=arg5;
 else
  z=arg2; p=arg1; k=1/arg3; stp=arg4; col=arg5; rev=1;
 end
 [num,den]=dezpk(z,p,k);
end
[col1,col2,tp1]=coltbl(col);
[tp1,tp2,tp3,tp4]=coltbl;
WB=tp1(8,:);
if length(den) < 2
 disp('   nessun polo o zero in rootlc'), return
end
%
if abs(den(1))>10^(-8) & den(1)~=1
 den=den/den(1); num=num/den(1);
end
ln=length(num); nz=ln-1; ld=length(den); np=ld-1; npz=np-nz;
x1=real(p); y1=imag(p); x2=real(z); y2=imag(z); s1=get(gca,'XLimMode');
rop=(~ishold) & strcmp(s1,'auto');
if rop
 xi=min([x1;x2]); xs=max([x1;x2]); yi=min([y1;y2]); ys=max([y1;y2]);
 dx=xs-xi;dy=ys-yi; mms=max(abs([dx,dy]));
 tol=10^(-2);
 if mms<tol; dx=1; mms=1; end;
 dk1=1.2; zz1=roots(sumpol(den,num*dk1));
 if max(abs(zz1))<100*mms
  x3=real(zz1); y3=imag(zz1); xi=min([x1;x2;x3]); xs=max([x1;x2;x3]);
  yi=min([y1;y2;y3]); ys=max([y1;y2;y3]); dx=xs-xi;dy=ys-yi;
 end
 if dx < tol*dy; dx=.1*dy; end;
 if dy < tol*dx; dy=.1*dx; end;
 xi=xi-.2*dx;xs=xs+.2*dx;yi=yi-.2*dy;ys=ys+.2*dy;
 if (ys-yi)<(xs-xi)/1.5
  yi=yi-dx;ys=ys+dx;
 end
 plot([xi,xi,xs,xs],[yi,ys,ys,yi],'Color',WB,'LineStyle','none','Marker','.')
 VV=axis; axis(VV)
end
%
%   the derivatives of num and den
%
dnum=zeros(1,ln);
if ln==1
 dnum=0;
else
 for kk=1:ln-1
  dnum(kk)=num(kk)*(ln-kk);
 end
 dnum=dnum(1:ln-1);
end
dden=zeros(1,ld);
if ld==1
 dden=0;
else
 for kk=1:ld-1
  dden(kk)=den(kk)*(ld-kk);
 end
 dden=dden(1:ld-1);
end
%
%   multiple roots and corresponding values of k
%
rmul=roots(sumpol(conv(num,dden),-conv(den,dnum)));
kmul=-polyval(den,rmul)./(polyval(num,rmul)+eps);
ii=find(real(kmul)>0); kmulv=real(kmul(ii)); kmulv=sort(kmulv);
ii=find((real(kmul)>0)&(abs(imag(kmul))<10^(-2)*abs(real(kmul))));
kmul=real(kmul(ii)); rmul=rmul(ii); [kmul,ii]=sort(kmul); rmul=rmul(ii);
%
dk1=1; zz2=roots(sumpol(den,num*dk1));
zz2=zz2+j*10^(-30)*ones(length(zz2),1);
xx2=real(zz2); yy2=imag(zz2);
if nz==np & num(1)<0
 kinf=-1/num(1);
else
 kinf=10^30;
end
kmulv=[kmulv;10^80]; ind2=0;
%
VV=axis; scale=max(abs(VV));
xm=VV(1);xM=VV(2);ym=VV(3);yM=VV(4);
ii=find((x1>=xm)&(x1<=xM)&(y1>=ym)&(y1<=yM)); x1=x1(ii); y1=y1(ii);
ii=find((x2>=xm)&(x2<=xM)&(y2>=ym)&(y2<=yM)); x2=x2(ii); y2=y2(ii);
if isempty(x1), x1=10^8; y1=10^8; end
if isempty(x2), x2=10^8; y2=10^8; end
ha=plot(x1,y1,x2,y2);
if rev==0
 set(ha(1),'Color',col1,'LineStyle','none','Marker','x','MarkerSize',10)
 set(ha(2),'Color',col1,'LineStyle','none','Marker','o')
else
 set(ha(1),'Color',col1,'LineStyle','none','Marker','o')
 set(ha(2),'Color',col1,'LineStyle','none','Marker','x','MarkerSize',10)
end
axis(VV), hold on
if nargs>=7
 flgd=arg6; ndiv=arg7;
 if flgd==1
  if ndiv(1)>0
   stepx=(VV(2)-VV(1))/ndiv(1); xtick=VV(1):stepx:VV(2); set(gca,'xtick',xtick)
  end
  if ndiv(2)>0
   stepy=(VV(4)-VV(3))/ndiv(2); ytick=VV(3):stepy:VV(4); set(gca,'ytick',ytick)
  end
 end
end
if nargs<8, title('luogo delle radici'), end
figure(gcf), drawnow
ii=find((xx2>=xm)&(xx2<=xM)&(yy2>=ym)&(yy2<=yM)); xx2=xx2(ii); yy2=yy2(ii);
if length(xx2)~=0
 plot(xx2,yy2,'Erasemode','none','Color',col1,'LineStyle','none','Marker','+')
 axis(VV)
end
ii=find((real(z)>=xm)&(real(z)<=xM)&(imag(z)>=ym)&(imag(z)<=yM));
zzin=z(ii); nzin=length(zzin); npzin=np-nzin;
%
%  plotting the locus
%
npt=5; rr1=p; stp1=stp/2;
dk1=.0001*scale*stp1;  % initial trial value of k
sttp=.0005*scale*stp1; % length of the segments
rr=roots(sumpol(den,num*dk1)); rr=ordvv(rr1,rr); drr=max(abs(rr-rr1))+eps;
dk1=dk1*sttp/drr;  % the corrected value of k
if dk1>=kmulv(1)
 dk1=kmulv(1); kmulv=kmulv(find(kmulv>dk1));
end
rr=roots(sumpol(den,num*dk1));
rr=ordvv(rr1,rr); % ordering of the roots
x1r=real(rr1); y1r=imag(rr1); x2r=real(rr); y2r=imag(rr);
% drawing the first segment
drawnow %5.3
ha=plot([x1r,x2r]',[y1r,y2r]','Erasemode','none','Color',col1,'LineStyle','-');
delta1=rr-rr1; % difference of the roots on the first segment
rr1=rr; % the first point of the second segment
kk=dk1; % the corresponding value of k
dk=dk1; % the current increment
rrx=j*ones(np,npt); finish=0; flginf=0;
while ~finish
 aaa=sumpol(den,num*(kk+dk)); if aaa(1)==0, aaa(1)=-eps^2; end
 rr=roots(aaa); rr=ordvv(rr1,rr); % ordering of the roots
% test on the maximal curvature
 delta2=rr-rr1; % difference of the new pair of roots
 angs=angle(delta2)-angle(delta1); % angles of consecutive segments
 maxerr=max(abs(angs).*abs(delta2)); % maximal error due to curvature
 if maxerr<10^(-12)*scale
  dk=dk*3; kkn=kk+dk;
 else
  dk=dk*stp1*sqrt(.05*scale/maxerr); kkn=kk+dk;
 end
% managing of a non-asymptotic point at infinity
 if kkn>kinf
  if flginf<=5
   kkn=kk+(kinf-kk)/2;
  else
   kinf=10^(30);
  end
  flginf=flginf+1;
 end
 if kkn>=kmulv(1)
  kkn=kmulv(1); kmulv=kmulv(find(kmulv>kkn));
 end
 kav=logspace(log10(kk),log10(kkn),npt);
 for ind=1:npt
  aaa=sumpol(den,num*kav(ind)); if aaa(1)==0, aaa(1)=-eps^2; end
  rrx(:,ind)=roots(aaa);
  if ind==1
   rrx(:,ind)=ordvv(rr1,rrx(:,ind));
  else
   rrx(:,ind)=ordvv(rrx(:,ind-1),rrx(:,ind)); % ordering of the roots
  end
 end
 x1r=real(rrx); y1r=imag(rrx);
%
%  framing output into axes
%
 iind=zeros(np,npt);
 ii=find((x1r>=xm)&(x1r<=xM)&(y1r>=ym)&(y1r<=yM));
 iind(ii)=ones(1,length(ii)); kk=min(iind');
 if max(kk)==1
  plot(x1r(find(kk),:)',y1r(find(kk),:)','Erasemode','none',...
  'Color',col1,'LineStyle','-')
 end
%
% completing the uncomplete branches
%
 kk=sum(iind'); ii=find((kk~=0)&(kk~=npt));
 for kk=ii
  np1=round(20*abs(rrx(npt)-rrx(1))/scale);
  if np1<100, np1=100; elseif np1>250, np1=250; end
  refin=linspace(0,1,np1); x1ra=[]; y1ra=[];
  for kk1=1:npt-1
   if iind(kk,kk1)==1
    x1ra=[x1ra,x1r(kk,kk1)]; y1ra=[y1ra,y1r(kk,kk1)];
   end
   if iind(kk,kk1)~=iind(kk,kk1+1)
    x1ra=[x1ra,x1r(kk,kk1)+(x1r(kk,kk1+1)-x1r(kk,kk1))*refin];
    y1ra=[y1ra,y1r(kk,kk1)+(y1r(kk,kk1+1)-y1r(kk,kk1))*refin];
   end
  end
  if iind(kk,npt)==1
   x1ra=[x1ra,x1r(kk,npt)]; y1ra=[y1ra,y1r(kk,npt)];
  end
  ii1=find((x1ra>=xm)&(x1ra<=xM)&(y1ra>=ym)&(y1ra<=yM));
  plot(x1ra(ii1)',y1ra(ii1)','Erasemode','none','Color',col1,'LineStyle','-')
 end
 delta1=rrx(:,npt)-rr1; rr1=rrx(:,npt);
%
%   termination criterion
%
 finish=(length(kmulv)==0);
 ii=find((real(rr1)>=xm)&(real(rr1)<=xM)&(imag(rr1)>=ym)&(imag(rr1)<=yM));
 nbout=np-length(ii);
 if nzin > 0
  dpz=max(min(abs(rr1*ones(1,nzin)-ones(np,1)*zzin.')));
 else
  dpz=0;
 end
 finish=((nbout>=npzin)&(dpz < scale/400));
 kk=kkn;
end
HALEG=[HALEG,ha(1)];
if WB(1)==0; colsty='w:'; else, colsty='k:'; end
plot([0 0],[VV(3),VV(4)],colsty,'Erasemode','none')
hold off
if nargout==0, disp(' '), return, end
rrm=rmul; kkm=kmul;
% --- last line of rootlc ---
