function rootlaux(typ)
%ROOTLAUX Auxiliary file for graphic management related to rootl.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global pbs vectc indexit oran2 str tc vectz vectp vectk vecttc inx...
 HA HA1 HA2 HA3 HA4 HHAt

xy=1;
if typ==1
 for kk=1:length(vectc)
  [tp1,tp2,tp3,mmm]=coltbl(vectc(kk)); mmm=deblank(mmm);
  set(pbs(10+kk),'Visible','on','String',mmm)
 end
 indexit=10+length(vectc)+1;
 set(pbs(indexit),'Visible','on','String','MENU')
 if length(vectc)>1
  mess='Scegliere un colore o MENU per uscire';
 else
  mess='Scegliere il colore o MENU per uscire';
 end
 set(pbs(1),'ForegroundColor',oran2,'Visible','on','String',mess)
 figure(gcf)
elseif typ==2
 set(gca,'XTickMode','auto'), set(gca,'YTickMode','auto')
 zoom, pbs(22)=1;
 if length(HA)>1
  for kk=1:length(HA), eval('delete(HA(kk))','err=1;'), end
  HA=[];
 end
end
if typ>=11
 for kk=2:8, set(pbs(kk),'Visible','off'), end
 SEL=typ-10; xy=0;
 for kk=11:indexit
  set(pbs(kk),'Visible','off')
 end
 if SEL~=indexit-10
  if length(vectc)>1
   ii1=SEL;
  else
   ii1=1;
  end
  cc=vectc(ii1);
  % color correction table
  [tp1,tbl,tp2,mmm]=coltbl(cc); mmm=deblank(mmm);
  messp1=['Scegliere un punto con il mouse (pulsante 1) sul grafico ',...
  mmm,' (pulsante 2 per uscire)'];
  messp2='Premere il pulsante 1 per cancellare i dati';
  set(pbs(1),'ForegroundColor',tbl,'Visible','on','String',messp1)
  mess='Il punto scelto:';
  set(pbs(2),'ForegroundColor',tbl,'Visible','off','String',mess)
  set(pbs(3),'Visible','off')
  set(pbs(4),'Visible','off')
  if str=='s'
   mess='Tempo continuo';
  else
   TT=tc;
   mess=sprintf('Tempo discr., T=%.3g',TT);
  end
  set(pbs(5),'ForegroundColor',tbl,'Visible','off','String',mess)
  set(pbs(6),'Visible','off')
  set(pbs(7),'Visible','off')
  set(pbs(8),'Visible','off')
  q=ii1; zc=vectz(1:inx(q,1),q); pc=vectp(1:inx(q,2),q); kc=vectk(q);
  tc=vecttc(q); TT=tc;
  [numc,denc]=dezpk(zc,pc,kc);
  bb1=1; hh1=0;
  while bb1==1
   if xy==4
    [x1s,y1s,bb1]=ginput(1);
    if isempty(bb1), bb1=2; end
   end
   xy=4;
   if bb1==1
    set(pbs(1),'ForegroundColor',tbl,'String',messp1)
    for kk=2:8
     set(pbs(kk),'Visible','off')
    end
    [x1s,y1s,bb1]=ginput(1);
    if isempty(bb1), bb1=2; end
   end
   if bb1==1
    set(pbs(1),'ForegroundColor',tbl,'String',messp2)
    set(pbs(2),'Visible','on')
    set(pbs(5),'Visible','on')
    x=x1s; y=y1s;
    mess=sprintf('x: %.3g',x); mess=[mess,sprintf(', y: %.3g',y)];
    set(pbs(3),'ForegroundColor',tbl,'Visible','on','String',mess)
    av=x+j*y; kc=-polyval(denc,av)/polyval(numc,av); kc=real(kc);
    if kc<0
     eval('delete(HA1(ii1))','err=1;'), eval('delete(HA2(ii1))','err=1;')
     eval('delete(HA3(ii1))','err=1;'), eval('delete(HA4(ii1))','err=1;')
    else
     mess=sprintf('Guadagno K: %.3g',kc);
     set(pbs(4),'ForegroundColor',tbl,'Visible','on','String',mess)
     pp=roots(sumpol(denc,kc*numc)); [ww,ii]=min(abs(av-pp));
     ppv=pp; pp0=pp(ii); x=real(pp0); y=imag(pp0);
     pp=roots(sumpol(denc,kc*.999*numc)); pp=ordvv(pp0,pp);
     x0=real(pp(ii)); y0=imag(pp(ii));
     VV=axis; hold on
     rx=(VV(2)-VV(1))/(2*25); ry=(VV(4)-VV(3))/(1.5*25);
     [HA1(ii1),HA2(ii1)]=arrowl(x0,y0,x,y,rx,ry,cc);
     HHAt=[HHAt;HA1(ii1);HA2(ii1)];
     if y~=0
      [HA3(ii1),HA4(ii1)]=arrowl(x0,-y0,x,-y,rx,ry,cc);
      HHAt=[HHAt;HA3(ii1);HA4(ii1)];
     end
     if str=='z'
      zz=x+j*y;
      ss1=(1/TT)*log(zz); x=real(ss1); y=imag(ss1);
     end
     onn=sqrt(x^2+y^2); ddp=-x/onn;
     mess=sprintf('omega_n: %.3g rad/sec',onn);
     set(pbs(6),'ForegroundColor',tbl,'Visible','on','String',mess)
     mess=sprintf('delta: %.4g',ddp);
     set(pbs(7),'ForegroundColor',tbl,'Visible','on','String',mess)
     if str=='z', ppv=(1/TT)*log(ppv); end
     settime=-3/max(real(ppv));
     if settime<0, settime=NaN; end
     if str=='z', settime=TT*ceil(settime/TT); end
     mess=sprintf('tempo assest.: %.4g sec',settime);
     set(pbs(8),'ForegroundColor',tbl,'Visible','on','String',mess)
    end
   end % if bb1==1
   hh1=1;
  end % while bb1
  for kk=2:8, set(pbs(kk),'Visible','off'), end
  if length(vectc)>1
   mess='Scegliere un colore o MENU per uscire';
  else
   mess='Scegliere il colore o MENU per uscire';
  end
  set(pbs(1),'ForegroundColor',oran2,'Visible','on','String',mess)
  for kk=11:indexit, set(pbs(kk),'Visible','on'), end
 else
  for rr=1:18, set(pbs(rr),'Visible','off'), end
  set(pbs(20),'Visible','on'), hold off
 end
end % if typ
% --- last line of rootlaux ---
