function rootl(arg1,arg2,arg3,arg4)
%ROOTL	  Luogo delle radici (TFI).
%   ROOTL,gi - da TFI [ROOTL('gi') - da Matlab] traccia il luogo delle
%   radici corrispondente alla funzione di trasferimento gi.
%   Se ROOTL viene chiamato senza alcun argomento, la f.d.t. gi puo'
%   essere specificata in interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global ABIL TRF1 TRF2 TRF3 TRF4 TRF5 TRF5 TRF6 TRF7 gr HA...
 pbs vectc indexit oran2 str tc vectz vectp vectk vecttc inx...
 HA1 HA2 HA3 HA4 HHAt HALEG FIGLEG LABLEG SUBPLEG

aA=setstr(224); eA=setstr(232); oA=setstr(242); EA=setstr(200);
nfig=gcf; nfigs=int2str(nfig); flgmen=0; HA=[]; hauim=[]; FIGLO=resfiglo;
FIGLEG=nfig; HALEG=[]; LABLEG=[]; SUBPLEG=0; HHAt=[]; selasym=[];
ms1=['\n **** errore: non si pu',oA,' cambiare figura durante l''esecuzione\n'];
if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
gi='tf';
if nargin>0
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1;
 end
end
framesc=get(0,'DefaultFigureColor');
clf, ordf(3), set(gcf,'Color',framesc), VFULL=get(gcf,'Position');
SC=diag([1/VFULL(3);1/VFULL(4);1/VFULL(3);1/VFULL(4)]);
if any(FIGLO(5,:))
 erx=0; eval('set(nfig,''Position'',FIGLO(5,1:4))','erx=1;')
end
set(0,'DefaultUIControlUnits','normalized')
HA1=zeros(1,7); HA2=zeros(1,7); HA3=zeros(1,7); HA4=zeros(1,7);
men_opt=uimenu(nfig,'Label','Memo');
men_gr=uimenu(nfig,'Label','Reticoli');
uimenu(men_gr,'Label','Reticolo on/off','Callback','gridmng(1)');
uimenu(men_gr,'Label','Luoghi a delta costante on/off',...
'Callback','gridmng(5)');
men_zoom=uimenu(nfig,'Label','Zoom on/off','Callback','rootlaux(2)');
%
pbs=zeros(1,22);
[tp1,tp2,ccol,ccols]=coltbl;
colbg=tp1(8,:);
oran1=tp1(9,:);
oran2=tp2(9,:);
BB=VFULL(4)-16;
%
Pos=[10 BB 500 15]*SC;
pbs(1)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'Visible','off');
%
llth=154;
AA=VFULL(3)-llth-4; BB=VFULL(4)-16;
%
for kk=2:10
 Pos=[AA BB-15*(kk-2) llth 15]*SC;
 pbs(kk)=uicontrol(gcf,...
 'Style','text',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'BackgroundColor',colbg,...
 'Visible','off');
end
%
BB=VFULL(4)-26; llth=60;
%
for kk=11:18
 Pos=[4 BB-20*(kk-10) llth 20]*SC;
 pbs(kk)=uicontrol(gcf,...
 'Style','push',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'Visible','off',...
 'Callback',['rootlaux(',int2str(kk),')']);
end
%
Pos=[14 5 400 15]*SC;
pbs(20)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'ForegroundColor',oran2,...
'Visible','off',...
'String','PREMERE INVIO PER IL MENU');
%
fldiv1=0; fldiv2=0; flg=0; izz=-1; gr=0;
vectz=[]; vectp=[]; vectk=[]; inx=[]; vectc=[]; vtime=[]; vecttc=[];
vectg=[]; gnum=[]; gn=0; vrmul=[]; vkmul=[]; inx1=[];
stp=1; cfl=0; flgd=0; ndiv=0; ab=0; rev=0; iitf=0;
%
figure, nnf=gcf;
tfblocks(3,'K',gi,'','','','','','','','')
err=0; eval('delete(nnf)','err=1;')
while flg==0
 if (nargin==0 )|(izz==6)
  flg1=0; err=0;
  while flg1==0
   gi=[];
   while isempty(gi)
    gi=input('\n   specificare la funzione di trasferimento : ','s');
    if isempty(get(0,'children')), return, end
    if gcf~=nfig, fprintf(ms1), return, end
   end
   if gi=='0', ordf(1), return, end
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
    err=1;
   else
    err=0;
   end
   if err==0
    [zc,pc,kc,strc,tc]=exportf(gi,2); if isempty(kc), ordf(1), return, end
    if (strc=='z')&(tc==0), tc=lsamp; end
    if length(zc)>length(pc)
     disp(' '), disp(['   **** attenzione: ',gi,' ',eA,' non causale'])
     disp(['        il luogo verr',aA,' tracciato in direzione opposta'])
     disp(' '), disp('   **** premere un tasto per proseguire'), pause
     rev=1;
    end
    if isempty(vtime)
     vtime=strc; z=zc; p=pc; k=kc; str=strc;
    else
     if ~strcmp(strc,vtime)
      fprintf('\n **** errore: tempo continuo e discreto nella stessa figura')
      fprintf('\n'), pause, cfl=1;
     else
      z=zc; p=pc; k=kc; str=strc;
     end
    end
    flg1=1;
   end
  end
 elseif (nargin>0)&(izz<0)
  [z,p,k,str,tc]=exportf(gi,2); if isempty(k), ordf(1), return, end
  if (str=='z')&(tc==0), tc=lsamp; end
  if length(z)>length(p)
   disp(' '), disp(['   **** attenzione: ',gi,' ',eA,' non causale'])
   disp(['        il luogo verr',aA,' tracciato in direzione opposta'])
   disp(' '), disp('   **** premere un tasto per proseguire'), pause
   rev=1;
  end
  vtime=str;
 end
 if cfl==0
  iitf=iitf+1;
  vectz=[vectz,[z;zeros(50-length(z),1)]];
  vectp=[vectp,[p;zeros(50-length(p),1)]];
  vectk=[vectk,k]; vectg=[vectg,gi]; vecttc=[vecttc;tc];
  gnum=[gnum;length(gi)]; inx=[inx;length(z),length(p)]; flg1=0;
  while flg1==0
   if izz~=6
    clc, disp(' ')
    disp('   LUOGO DELLE RADICI :')
    disp(' ')
    disp('   x poli ad anello aperto (= poli ad anello chiuso per K=0)')
    disp('   o zeri ad anello aperto (= poli ad anello chiuso per K=Inf)')
    disp('   + poli ad anello chiuso per K=1')
    disp(' ')
    disp('   il luogo viene tracciato passo passo per K crescente')
    disp(['   o per K decrescente se il sistema ',eA,' non causale'])
   end
   ins=[ccol(7),'=',deblank(ccols(7,:)),','];
   fprintf(['\n   scegliere il colore del grafico: ',ins,' g=verde,'])
 mest='\n   b=blu, r=rosso, y=giallo, m=magenta, c=celeste, default verde : ';
   s=input(mest,'s');
   if isempty(s), s='g'; end
   s=s(1);
   if strcmp(s,'0'), ordf(1), return, end
   if isempty(get(0,'children')), return, end
   if gcf~=nfig, fprintf(ms1), return, end
   if isempty(vectc)
    rop=0; for kk=1:7, rop=rop|(s==ccol(kk)); end
    if rop, flg1=1; end
   else
    rop=0;
    for kk=1:7
     rop=rop|((s==ccol(kk))&isempty(find(vectc==ccol(kk))));
    end
    if rop, flg1=1; end
   end
  end
  vectc=[vectc;s]; selasym=[selasym;s];
  eval(['TRF',int2str(iitf),'=[gi,s];'])
  if flgmen==0
   if strcmp(str,'s')
    mess='luogo delle radici, tempo continuo';
   else
    mess='luogo delle radici, tempo discreto';
   end
   uimenu(men_opt,'Label',mess); flgmen=1;
  end
  hauim=[0,hauim];
  if length(hauim)==1, ss='on'; else, ss='off'; end
  mess=[gi,', colore ',s];
  hauim(1)=uimenu(men_opt,'Label',mess,'Separator',ss,...
  'Callback',['tfmaux(',int2str(iitf),',1,0)']);
  ABIL=1;
 else
  flg1=1;
 end
 while flg1==1
  if cfl==0
   if (izz==2)|(izz==10), axis(VV), end
   if strcmp(str,'s')
    [rmul,kmul]=eval('rootlc(z,p,k,stp,s,flgd,ndiv)');
   else
    [rmul,kmul]=eval('rootld(z,p,k,stp,s,flgd,ndiv)');
   end
   if islegen
    if gn==0
     if length(gnum)==1
      LABLEG=['''',vectg,''''];
     else
      LABLEG=[LABLEG,',''',...
      vectg(sum(gnum(1:length(gnum)-1))+1:sum(gnum)),''''];
     end
    end
    if legen==1, eval(['legend(HALEG,',LABLEG,',4)']), end
   end
   if (gr==1)&((izz==2)|(izz==10))
    grid on
   end
   if (length(HA)>0)&((izz==2)|(izz==10))
    for kk=1:length(HA), eval('delete(HA(kk))','err=1;'), end
    HA=[]; gridmng(5)
   end
   if (length(hauim)>1) & (izz==2)
    for kk=2:length(hauim), eval('delete(hauim(kk))','err=1;'), end
    hauim=hauim(1); set(hauim(1),'Separator','on')
   end
   xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   AA=axis; flgd=0;
   vrmul=[vrmul;rmul.',zeros(1,50-length(rmul))];
   vkmul=[vkmul;kmul.',zeros(1,50-length(kmul))];
   inx1=[inx1;length(rmul),length(kmul)];
  else
   cfl=0;
  end
  flg2=0;
  while flg2==0
   clc
   disp(' ')
   disp('   MENU :')
   disp(' ')
   disp('   1 - cambiare gli assi di riferimento e ripetere l''ultimo grafico')
   if gr==0
    disp('   2 - inserire reticolo')
   else
    disp('   2 - eliminare il reticolo')
   end
   disp('   3 - informazioni su punti di diramazione e asintoti')
   disp('   4 - aggiungere un grafico in colore diverso')
   disp('   5 - rivedere la figura')
   disp('   6 - informazioni sul luogo con il mouse')
   disp('   7 - luoghi a delta costante (on/off)')
   disp('   8 - tracciare gli asintoti')
   disp('   9 - mostrare la disposizione dei poli per un dato valore di K')
   disp('  10 - cambiare il passo e ripetere l''ultimo grafico')
   zoom off, zoom out, VV=axis;
   if (pbs(22)==1)&(length(HA)>0)
    for kk=1:length(HA), eval('delete(HA(kk))','err=1;'), end
    HA=[]; gridmng(5), pbs(22)=0;
   end
   izz=input('\n   operare una scelta (premere invio per uscire) : ');
   if isempty(get(0,'children')), return, end
   if gcf~=nfig, fprintf(ms1), return, end
   if isempty(izz)
    cc=get(0,'Children');
    if any(cc==nfig)
     FIGLO(5,1:4)=get(nfig,'Position');
     save figlo# FIGLO -v4
    else
     disp(' '), disp(['   LA FIGURA ',EA,' STATA CANCELLATA!'])
    end
    set(0,'DefaultUIControlUnits','pixel')
    eval('delete(men_gr)','err=1;'), eval('delete(men_zoom)','err=1;')
    ordf(1), return
   end
   menupointer=[2,7,4,6,9,3,8,5,1,10]; izz=floor(izz);
   lpointer=length(menupointer);
   if (izz>=1) & (izz<=lpointer)
    izz=menupointer(izz);
   end
   if izz==1
    if length(vectc)>1
     xx=0;
     while xx==0
      c=input('\n   scegliere la funzione specificandone il colore : ','s');
      if isempty(c), c='z'; end
      if c=='0', ordf(1), return, end
      if isempty(get(0,'children')), return, end
      if gcf~=nfig, fprintf(ms1), return, end
      ropc=0; for kk=1:7, ropc=ropc|strcmp(c,ccol(kk)); end
      if ropc
       if length(find(vectc==c))>0
	xx=1;
       end
      end
     end
    else
     c=s;
    end
    q=find(vectc==c);
    zc=vectz(1:inx(q,1),q); pc=vectp(1:inx(q,2),q); kc=vectk(q); tc=vecttc(q);
    [numc,denc]=dezpk(zc,pc,kc); ikc=0;
    while ikc==0
     clc
    Kc=input('\n   specificare un valore di K (premere invio per il menu) : ');
     if isempty(get(0,'children')), return, end
     if gcf~=nfig, fprintf(ms1), return, end
     if length(Kc)==0
      ikc=1;
     else
      poles=roots(sumpol(denc,numc*Kc));
      if str=='z'
       TT=tc;
       fprintf('\n   tempo di campionamento: %.4g sec\n',TT)
       av=(1/TT)*log(poles); x=real(av); y=imag(av);
      else
       x=real(poles); y=imag(poles);
      end
      onn=sqrt(x.^2+y.^2);
      ddp=-x./onn;
      fprintf('\n   POLI                     ')
      fprintf('MODULO         DELTA\n')
      for i=1:length(onn)
       lr=length(sprintf('%+.4g',real(poles(i))));
       li=0; lo=length(sprintf('%+.4g',onn(i)));
       fprintf('   %+.4g',real(poles(i)))
       if imag(poles(i))~=0
	li=length(sprintf('  %+.4g*j',imag(poles(i))));
	fprintf('  %+.4g*j',imag(poles(i)))
       end
       nbl1=25-lr-li; nbl2=15-lo;
       for bl=1:nbl1, fprintf(' '), end
       fprintf('%+.4g',onn(i))
       for bl=1:nbl2, fprintf(' '), end
       fprintf('%+.4g\n',ddp(i))
      end
      pp0=poles;
      pp=roots(sumpol(denc,Kc*.999*numc)); pp=ordvv(pp0,pp);
      VV=axis; hold on
      rx=(VV(2)-VV(1))/(2*25); ry=(VV(4)-VV(3))/(1.5*25);
      fprintf(['\n   la posizione dei poli verr',aA,' evidenziata con tacche'])
      mess='\n   specificare anche il corrispondente valore di K ? (1) : ';
      aa=input(mess); if isempty(aa), aa=0; end
      if aa==1
       cfsize=get(gca,'FontSize'); flgin=0;
       while flgin==0
	fsize=input('\n   corpo del carattere (da 6 a 14, default 12) : ');
	if length(fsize)==0; flfo=0; else, flfo=1; end
	fsize=round(fsize); flgin=1;
	if (fsize<6)|(fsize>14), flgin=0; end
       end
       if flfo==0, fsize=cfsize; end
      end
      for i=1:length(onn)
       x=real(pp0(i)); y=imag(pp0(i));
       x0=real(pp(i)); y0=imag(pp(i));
       if (x0>VV(1))&(x0<VV(2))&(y0>VV(3))&(y0<VV(4))
	arrowl(x0,y0,x,y,rx/3,ry/3,c,1)
	if (y~=0)|(y0~=0), arrowl(x0,-y0,x,-y,rx/3,ry/3,c,1), end
	if aa==1
	 if y~=0
	  nnn=text(x,y,sprintf(' %.3g',Kc)); set(nnn,'FontSize',fsize)
	  nnn=text(x,-y,sprintf(' %.3g',Kc)); set(nnn,'FontSize',fsize)
	 else
	  nnn=text(x,-1.5*(fsize/cfsize)*ry,sprintf('%.3g',Kc));
	  set(nnn,'FontSize',fsize)
	 end
	end
       end
      end
      figure(nfig)
      xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
     end
    end
   elseif izz==2
    clc, VV=axis; xtick=get(gca,'xtick'); ytick=get(gca,'ytick');
    divx=xtick(2)-xtick(1); divy=ytick(2)-ytick(1);
    ndiv=round([(VV(2)-VV(1))/divx,(VV(4)-VV(3))/divy]);
    fprintf(['\n   l''intervallo dell''asse x ',eA,' [%.4g %.4g];'],VV(1),VV(2))
    indin=0; while indin==0
    TA1=input('\n   premere invio o specificare nuovi valori: [xm xM] = ');
    ll1=length(TA1); if (ll1==0)|(ll1==2), indin=1; end, end, TA1=sort(TA1);
    fprintf('   numero di divisioni dell''asse x: %.4g;',ndiv(1))
    if ll1==2
     fprintf('\n   premere invio per la messa in scala automatica')
    else
     fprintf('\n   premere invio per conservare la scala precedente')
    end
    indin=0; while indin==0
    ndivt1=input('\n   o specificare un nuovo valore: ndx = ');
    if (length(ndivt1)==0)|(length(ndivt1)==1), indin=1; end, end
    fprintf(['\n   l''intervallo dell''asse y ',eA,' [%.4g %.4g];'],VV(3),VV(4))
    indin=0; while indin==0
    TA2=input('\n   premere invio o specificare nuovi valori: [ym yM] = ');
    ll2=length(TA2); if (ll2==0)|(ll2==2), indin=1; end, end, TA2=sort(TA2);
    fprintf('   numero di divisioni dell''asse y: %.4g;',ndiv(2))
    if ll2==2
     fprintf('\n   premere invio per la messa in scala automatica')
    else
     fprintf('\n   premere invio per conservare la scala precedente')
    end
    indin=0; while indin==0
    ndivt2=input('\n   o specificare un nuovo valore: ndy = ');
    if (length(ndivt2)==0)|(length(ndivt2)==1), indin=1; end, end
    if ll1==2, VV(1)=TA1(1); VV(2)=TA1(2); fldiv1=0; end
    if ll2==2, VV(3)=TA2(1); VV(4)=TA2(2); fldiv2=0; end
    if length(ndivt1)==1, ndiv(1)=round(abs(ndivt1)); end
    rp1=(length(ndivt1)~=0)|((fldiv1==1)&(ll1==0));
    if rp1, fldiv1=1; else, ndiv(1)=-1; end
    if length(ndivt2)==1, ndiv(2)=round(abs(ndivt2)); end
    rp2=(length(ndivt2)~=0)|((fldiv2==1)&(ll2==0));
    if rp2, fldiv2=1; else, ndiv(2)=-1; end
    ropa=(ll1==2)|(ll2==2);
    ropb=(length(ndivt1)~=0)|(length(ndivt2)~=0);
    if ropb
     flgd=1;
    elseif (ropa==0)&(ropb==0)
     flgd=1;
    else
     flgd=0;
    end
    l=length(vectc);
    vectz=vectz(:,l); vectp=vectp(:,l); vectk=vectk(l); inx=inx(l,:);
    vrmul=[]; vkmul=[]; inx1=[]; vectc=vectc(l); vecttc=vecttc(l);
    selasym=vectc; HALEG=[];
    vectg=vectg(sum(gnum(1:length(gnum)-1))+1:sum(gnum));
    gnum=gnum(length(gnum)); hold off, axis(VV), flg2=1;
    if isempty(get(0,'children')), return, end
    if gcf~=nfig, fprintf(ms1), return, end
   elseif izz==3
    ab=1;
    xyx=input('\n   **** premere invio per abilitare la selezione ','s');
    set(gcf,'Color',colbg), title('')
    set(men_opt,'Enable','off')
    set(men_gr,'Enable','off')
    set(men_zoom,'Enable','off')
    namef='rootlaux(1)'; eval(namef)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
    for rr=1:18, set(pbs(rr),'Visible','off'), end
    if ~isempty(HHAt)
     flgin=0;
     flgin=input('\n   conservare le frecce ? (1) : ');
     if isempty(flgin), flgin=0; end
     if flgin~=1
      for kk=1:length(HHAt)
       eval('delete(HHAt(kk))','err=1;')
      end
      HHAt=[];
     end
    end
    set(gcf,'Color',framesc)
    eval('set(men_opt,''Enable'',''on'')','err=1;')
    eval('set(men_gr,''Enable'',''on'')','err=1;')
    eval('set(men_zoom,''Enable'',''on'')','err=1;')
    title('luogo delle radici')
    eval('set(pbs(20),''Visible'',''off'')','err=1;')
   elseif izz==4
    if length(vectc)>1
     xx=0;
     while xx==0
      c=input('\n   scegliere la funzione specificandone il colore : ','s');
      if isempty(c), c='z'; end
      if c=='0', ordf(1), return, end
      if isempty(get(0,'children')), return, end
      if gcf~=nfig, fprintf(ms1), return, end
      ropc=0; for kk=1:7, ropc=ropc|strcmp(c,ccol(kk)); end
      if ropc
       if length(find(vectc==c))>0
	xx=1;
       end
      end
     end
    else
     c=s;
    end
    q=find(vectc==c);
    rmul=vrmul(q,1:inx1(q,1)); kmul=vkmul(q,1:inx1(q,2));
    clc
    disp(' ')
    if length(rmul)==0
     disp('   nessun punto di diramazione')
    else
     disp('   PUNTI DI DIRAMAZIONE:')
     if rev==1, kmul=1/kmul; end
     du=setstr(32*ones(1,24));
     for kk=1:length(rmul)
      dd=sprintf('   valore: %+.4g %+.4g*j;',real(rmul(kk)),imag(rmul(kk)));
      dd=[dd,du(1:32-length(dd))];
      dd=[dd,sprintf(' guadagno: %.4g\n',kmul(kk))]; fprintf(dd)
     end
    end
    if rev==0
     zc=vectz(1:inx(q,1),q); pc=vectp(1:inx(q,2),q); kc=vectk(q);
    else
     zc=vectp(1:inx(q,2),q); pc=vectz(1:inx(q,1),q); kc=1/vectk(q);
    end
    npz=length(pc)-length(zc);
    if npz>0
     xb=real(sum(pc)-sum(zc))/npz; angles=zeros(npz,1);
     for ki=1:npz
      nu=ki-1;
      if sign(kc)>0
       angles(ki)=(2*nu+1)*180/npz;
      else
       angles(ki)=2*nu*180/npz;
      end
     end
    end
    disp(' ')
    if npz==0
     disp('   nessun asintoto')
    else
     disp('   ASINTOTI:')
     du=sprintf('   centro: %.4g;   angoli: ',xb);
     fprintf(du)
     du=setstr(32*ones(1,length(du)));
     for kk=1:npz
      if kk~=1, fprintf(du), end
      fprintf('%.4g\n',angles(kk))
     end
    end
    disp(' ')
    disp('   **** premere un tasto per proseguire'); pause
   elseif (izz==5)&(length(selasym)~=0)
    if length(selasym)>1
     xx=0;
     while xx==0
      c=input('\n   scegliere la funzione specificandone il colore : ','s');
      if isempty(c), c='z'; end
      if c=='0', ordf(1), return, end
      if isempty(get(0,'children')), return, end
      if gcf~=nfig, fprintf(ms1), return, end
      ropc=0; for kk=1:7, ropc=ropc|strcmp(c,ccol(kk)); end
      if ropc
       if length(find(selasym==c))>0
	xx=1;
       end
      end
     end
    elseif length(selasym)==1
     c=selasym(1);
    end
    q=find(selasym==c);
    selasym=[selasym(1:q-1);selasym(q+1:length(selasym))];
    if isempty(selasym), selasym=[]; end
    q=find(vectc==c);
    [col1,col2,tp1]=coltbl(c);
    if rev==0
     zc=vectz(1:inx(q,1),q); pc=vectp(1:inx(q,2),q); kc=vectk(q);
    else
     zc=vectp(1:inx(q,2),q); pc=vectz(1:inx(q,1),q); kc=1/vectk(q);
    end
    npz=length(pc)-length(zc);
    if npz>0
     xb=real(sum(pc)-sum(zc))/npz; % center
     VV=axis; mm=20*max(abs(VV)); p1=zeros(1,2); p2=zeros(1,2);
     for ki=1:npz
      nu=ki-1;
      if sign(kc)>0
       p1=[xb xb+mm*cos((2*nu+1)*pi/npz)]; p2=[0 mm*sin((2*nu+1)*pi/npz)];
      else
       p1=[xb xb+mm*cos((2*nu)*pi/npz)]; p2=[0 mm*sin((2*nu)*pi/npz)];
      end
      hold on
      plot(p1,p2,'Color',col1,'LineStyle',':'), axis(VV)
     end
     figure(nfig)
     xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
    else
     disp(' ')
     disp('   nessun asintoto')
     disp(' ')
     disp('   **** premere un tasto per proseguire'); pause
    end
   elseif izz==6
    if length(vectc)<7
     hold on
     flg1=2; flg2=1;
    else
     fprintf(['\n   il numero massimo di grafici ',eA,' sette']), pause
    end
   elseif izz==7
    if gr==0
     gr=1; grid on
    else
     gr=0; grid off
    end
    figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   elseif izz==8
    gridmng(5)
    AA=axis; figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   elseif izz==9
    figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   elseif izz==10
    clc, fprintf(['\n   il valore attuale del passo ',eA,': %.4g'],stp)
    fprintf('\n   premere invio per ripetere con lo stesso passo')
    indin=0; while indin==0
    stpn=input('\n   o specificare un nuovo valore : ');
    if isempty(stpn), stpn=stp; end
    if stpn<=0, ordf(1), return, end
    if isempty(get(0,'children')), return, end
    if gcf~=nfig, fprintf(ms1), return, end
    if length(stpn)==1, indin=1; end, end
    stp=abs(stpn);
    l=length(vectc);
    vectz=vectz(:,l); vectp=vectp(:,l); vectk=vectk(l); inx=inx(l,:);
    vrmul=[]; vkmul=[]; inx1=[]; vectc=vectc(l); vecttc=vecttc(l);
    selasym=vectc; HALEG=[];
    vectg=vectg(sum(gnum(1:length(gnum)-1))+1:sum(gnum));
    gnum=gnum(length(gnum));
    VV=axis; xtick=get(gca,'xtick'); ytick=get(gca,'ytick');
    divx=xtick(2)-xtick(1); divy=ytick(2)-ytick(1);
    ndiv=round([(VV(2)-VV(1))/divx,(VV(4)-VV(3))/divy]);
    hold off, axis(VV); flg2=1; flgd=1;
   end
  end
 end
end
% --- last line of rootl ---
