function robpaux(typ)
%ROBPAUX   Auxiliary file for graphic management related to robpar.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global pbs ax VV park parN parD matpar intvpar...
 numc denc numf denf numr denr vcol1 vcol2 gw HA HA1 HA2...
 y t yc tc matn matp matx maty vparact x1p y1p valparam valuepr

if typ==1
 np0=pbs(30); delta=pbs(36); nargs=pbs(38); str='s'; nt=pbs(37);
 title('')
 set(pbs(1),'Visible','off')
 set(pbs(27),'Enable','off')
 set(pbs(28),'Enable','off')
 set(pbs(19),'Visible','off')
 set(pbs(60),'String','Funzioni:')
 mess='ATTENDERE, PREGO';
 set(pbs(1),'String',mess,'ForegroundColor',vcol2(2,:),'Visible','on')
 set(pbs(11),'String','Continua','Enable','off')
 set(pbs(12),'String','Termina','Enable','off','Callback','robpaux(2)')
 mess='Variazioni';
 set(pbs(2),'String',mess,'ForegroundColor',vcol2(2,:),'Visible','on')
 mess=sprintf('Nv = %i',nt);
 set(pbs(3),'String',mess,'ForegroundColor',vcol2(2,:),'Visible','on')
 drawnow
 flgp=0;
 nnx=100; lmatpar=size(matpar); axis(VV), hold on
 x1p=zeros(np0,nnx); y1p=zeros(np0,nnx);
 valuep=zeros(1,lmatpar(1));
 for kk=1:nnx
  for inx=1:lmatpar(1)
   intvpar1=intvpar(inx,1)+rand*(intvpar(inx,2)-intvpar(inx,1));
   valuep(inx)=intvpar1;
  end
  [Npar,Dpar,Kpar,errv]=tfpar(parN,parD,park,matpar,valuep);
  sn=size(Npar); sd=size(Dpar);
  num1=Kpar; den1=1;
  for i=1:sn(1)
   a=(find(Npar(i,:)~=0));
   num1=conv(num1, Npar(i,a(1):sn(2)));
  end
  for i=1:sd(1)
   a=(find(Dpar(i,:)~=0));
   den1=conv(den1, Dpar(i,a(1):sd(2)));
  end
  numpf1=conv(num1,numf); denpf1=conv(den1,denf);
  p1=roots(sumpol(conv(denpf1,denc),conv(numpf1,numc)));
  x1=real(p1); y1=imag(p1);
  x1p(:,kk)=x1; y1p(:,kk)=y1;
  iip=find(imag(p1)>0);
  delta1=min(-real(p1(iip))./abs(p1(iip)));
  if delta1<delta
   delta=delta1; valuepr=valuep; flgp=1;
   Numr=Npar; Denr=Dpar; Kr=Kpar; numr=num1; denr=den1;
  end
 end % for kk
 pbs(36)=delta;
 hh=plot(x1p,y1p,'Color',vcol1(2,:),'LineStyle','none','Marker','.',...
 'MarkerSize',4); HA1=[HA1;hh];
 nt=nt+nnx; pbs(37)=nt;
 mess=sprintf('Nv = %i',nt);
 set(pbs(3),'String',mess)
 set(pbs(11),'Enable','on')
 set(pbs(12),'Enable','on')
 set(pbs(1),'Visible','off')
 mess=['Scegliere "Continua" per ottenere altre 100 variazioni ',...
 'parametriche aleatorie'];
 set(pbs(1),'String',mess,'ForegroundColor',vcol2(9,:),'Visible','on')
 if flgp==1
  if nargs==4, aa=stf(Numr,Denr,Kr,str,gw); end
  for kk=1:length(HA2), eval('delete(HA2(kk))','err=1;'), end, HA2=[];
  xxv=[0 0]; yyv=[-10^4 10^4];
  t1=pbs(31); ym=pbs(32); yM=pbs(33); ycm=pbs(34); ycM=pbs(35);
  hh=plot([0,-delta]*yyv(2),[0,sqrt(1-delta^2)]*yyv(2),...
  'Color',vcol1(9,:),'LineStyle','-.'); HA2=[HA2;hh];
  hh=plot([0,delta]*yyv(1),[0,sqrt(1-delta^2)]*yyv(1),...
  'Color',vcol1(9,:),'LineStyle','-.'); HA2=[HA2;hh];
  hold off
  numpf=conv(numr,numf); denpf=conv(denr,denf);
  den0r=sumpol(conv(denpf,denc),conv(numpf,numc));
  num0r=conv(denf,conv(numr,numc));
  num0cr=conv(denf,conv(denr,numc));
  [z0r,p0r,k0r]=tozpk(num0r,den0r);
% worst-case step responses
  [yr,tr]=prnaux(z0r,[p0r;0],k0r,201,t1); yrm=min(yr); yrM=max(yr);
  [z0cr,p0cr,k0cr]=tozpk(num0cr,den0r);
  [ycr,tcr]=prnaux(z0cr,[p0cr;0],k0cr,201,t1); ycrm=min(ycr); ycrM=max(ycr);
  VA1=zeros(1,4); VA1(2)=t1;
  VA1(3)=min([0,ym,yrm]); VA1(4)=1.2*max([yM,yrM]);
  VA2=zeros(1,4); VA2(2)=t1;
  VA2(3)=min([0,ycm,ycrm]); VA2(4)=1.2*max([ycM,ycrM]);
  axes(ax(2)), reset(gca)
  plot(t,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VA1), hold on
  plot(tr,yr,'Color',vcol1(2,:),'LineStyle','-'), hold off
  set(ax(2),'FontSize',8)
  title('uscita del sistema controllato','FontSize',10);
  axes(ax(3)), reset(gca)
  plot(tc,yc,'Color',vcol1(1,:),'LineStyle','-'), axis(VA2), hold on
  plot(tcr,ycr,'Color',vcol1(2,:),'LineStyle','-'), hold off
  set(ax(3),'FontSize',8)
  title('uscita del regolatore','FontSize',10);
  axes(ax(1))
  mess=sprintf('coeff. di smorzam.: %.3g',delta);
  set(pbs(24),'String',mess,'ForegroundColor',vcol2(2,:),'Visible','on')
  settime=-3/max(real(p0r));
  if settime<0, settime=NaN; end
  mess=sprintf('tempo di assestam.: %.4g sec',settime);
  set(pbs(25),'String',mess,'ForegroundColor',vcol2(2,:),'Visible','on')
 end
 hold off
 set(pbs(27),'Enable','on')
 set(pbs(28),'Enable','on')
elseif typ==2
 set(pbs(11),'Enable','off'), set(pbs(12),'Enable','off')
 nt=0; pbs(37)=nt;
 set(pbs(1),'Visible','off')
 title('analisi di robustezza')
 set(pbs(2),'Visible','off'), set(pbs(3),'Visible','off')
 for kk=1:length(HA1), delete(HA1(kk)), end, HA1=[];
 set(pbs(11),'String','Dispersione poli','Callback','robpaux(1)')
 set(pbs(12),'String','Contorni radici','Callback','robpaux(3)')
 set(pbs(11),'Enable','on'), set(pbs(12),'Enable','on')
 set(pbs(19),'Visible','on')
 set(pbs(60),'String','Funzioni:')
elseif typ==3
 set(pbs(11),'Enable','off'), set(pbs(12),'Enable','off')
 set(pbs(19),'Visible','off'), set(pbs(60),'String','Parametri:')
 np0=pbs(30);
 valparam=intvpar(:,3)'; lmatpar=size(matpar); button=4; paract=-1; index=0;
 matn=[]; matp=[]; matx=[]; maty=[];
 vparact=[]; nnx=100; x1p=zeros(np0,nnx); y1p=zeros(np0,nnx);
 pbs(41)=index; pbs(42)=paract; pbs(43)=nnx; pbs(44)=button;
 [tp1,tp2,repco,repcos]=coltbl;
 vcolorm=vcol2; vcolor=repco; strcolor=repcos;
 for kk=11:18
  set(pbs(kk),'Callback',['robpaux(',int2str(kk+20),')'])
 end
 title('')
 mess='Scegliere un parametro o "Termina" per uscire';
 set(pbs(1),'ForegroundColor',vcol2(9,:),'Visible','on','String',mess)
 for i=1:lmatpar(1)
  mespa=matpar(i,find(matpar(i,:)~=' '));
  set(pbs(10+i),'String',mespa,'Visible','on','Enable','on')
  mess=[mespa,sprintf('=%.3g',valparam(i))];
  set(pbs(1+i),'Visible','on','ForegroundColor',vcolorm(i,:),'String',mess)
 end
 mess='Termina';
 set(pbs(10+lmatpar(1)+1),'String',mess,'Visible','on',...
 'Callback','robpaux(4)')
 pbs(39)=1;
elseif typ==4
 flgrip=pbs(29); nnx=pbs(43);
 if (flgrip==0)&(length(HA1)>nnx)
  for kk=1:length(HA1)-nnx, eval('delete(HA1(kk))','err=1;'), end
 end
 for kk=11:18, set(pbs(kk),'Enable','off'), end
 nt=0; pbs(37)=nt;
 set(pbs(1),'Visible','off')
 title('analisi di robustezza')
 for kk=1:length(HA1), eval('delete(HA1(kk))','err=1;'), end, HA1=[];
 set(pbs(11),'String','Dispersione poli','Callback','robpaux(1)',...
 'Visible','on')
 set(pbs(12),'String','Contorni radici','Callback','robpaux(3)',...
 'Visible','on')
 for kk=11:18, set(pbs(kk),'Enable','on'), end
 for kk=2:10, set(pbs(kk),'Visible','off'), end
 for kk=13:18, set(pbs(kk),'Visible','off'), end
 set(pbs(27),'Enable','on')
 set(pbs(28),'Enable','on')
 set(pbs(19),'Visible','on')
 set(pbs(60),'String','Funzioni:')
end
if ((typ>=31)&(typ<=37))
 np0=pbs(30); index=pbs(41); paract=pbs(42); nnx=pbs(43); button=pbs(44);
 nargs=pbs(38); flgrip=pbs(29); delta=pbs(36); str='s';
 set(pbs(1),'Visible','off')
 set(pbs(27),'Enable','off')
 set(pbs(28),'Enable','off')
 mess='ATTENDERE, PREGO';
 set(pbs(1),'String',mess,'ForegroundColor',vcol2(2,:),'Visible','on')
 for kk=11:18, set(pbs(kk),'Enable','off'), end
 if pbs(39)==1, drawnow, pbs(39)=0; end
 lmatpar=size(matpar);
 [tp1,tp2,repco,repcos]=coltbl;
 vcolorm=vcol2; vcolor=repco; strcolor=repcos;
 SEL=typ-30; flgg2=1;
 if (flgrip==0)&(length(HA1)>nnx)
  for kk=1:length(HA1)-nnx, eval('delete(HA1(kk))','err=1;'), end
 end
 while flgg2==1
  if button==4
   ibut=0;
   if lmatpar(1)>1 | ((index==1)&(lmatpar(1)==1))
    mm=SEL;
   else
    mm=1;
   end % if lmatpar
   if paract~=-1
    if isempty(matn), matn1=-5; else, matn1=matn; end
    if length(find(paract==matn1))==0
     matx=[matx,x1p']; maty=[maty,y1p'];
     matp=[matp,vparact]; matn=[matn,paract];
     fnd=find(paract==matn);
    else
     fnd=find(paract==matn);
     matx(:,np0*(fnd-1)+1:np0*fnd)=x1p';
     maty(:,np0*(fnd-1)+1:np0*fnd)=y1p';
     matp(:,fnd)=vparact; matn(fnd)=paract;
    end
    if index==1 & length(matn)>1
     sxx=size(matx);
     i=find(paract==matn);
     vcol=vcolor(matn(i));
     ii=find(repco==vcol); vcol=vcol1(ii,:);
    end % if index
   end	% if paract
  end	% if button==4
  if paract~=-1
   button=0;
   if ibut==0, paract1=paract; end
   bb=strcolor(paract1,:); bb=bb(find(bb~=' '));
   set(pbs(1),'Visible','off')
   mess=['Scegliere un punto sul grafico ',bb,...
   ' (premere il pulsante 2 per ritornare al menu)'];
   set(pbs(1),'ForegroundColor',vcolorm(paract1,:),'String',mess,...
   'Visible','on')
   for i=1:(lmatpar(1)+1)
    set(pbs(10+i),'Enable','off')
   end
   [xx,yy,button]=ginput(1);
   if button==1
    idff=zeros(nnx,np0);
    for i=1:np0
     idff(:,i)=((matx(:,np0*(fnd-1)+i)-xx).^2+(maty(:,np0*(fnd-1)+i)-yy).^2);
    end
    [yd,id]=min(idff); [kd,jd]=min(yd); id=id(jd);
    ppar=matp(id,fnd);	 % parameter value
    valparam(matn(fnd))=ppar;
    ii1=matn(fnd);
    mespa=matpar(ii1,find(matpar(ii1,:)~=' '));
    mess=[mespa,sprintf('=%.3g',valparam(ii1))];
    set(pbs(1+ii1),'Visible','on','ForegroundColor',vcolorm(ii1,:),...
    'String',mess)
   end
  end % if paract
  if (button==1)|(paract==-1)
   paract=mm;
   if (button==1)|(index==0)
    vparact=[]; inx=paract; flgp=0;
    valpar1=linspace(intvpar(inx,1),intvpar(inx,2),nnx);
    for kk=1:nnx
     vparact=[vparact;valpar1(kk)];
     valuep=zeros(1,lmatpar(1));
     for i=1:lmatpar(1)
      if i~=inx
       valuep(i)=valparam(i);
      else
       valuep(i)=valpar1(kk);
      end
     end
     [Npar,Dpar,Kpar,errv]=tfpar(parN,parD,park,matpar,valuep);
     sn=size(Npar); sd=size(Dpar);
     num1=Kpar; den1=1;
     for i=1:sn(1)
      a=(find(Npar(i,:)~=0));
      num1=conv(num1, Npar(i,a(1):sn(2)));
     end
     for i=1:sd(1)
      a=(find(Dpar(i,:)~=0));
      den1=conv(den1, Dpar(i,a(1):sd(2)));
     end
     numpf1=conv(num1,numf); denpf1=conv(den1,denf);
     p1=roots(sumpol(conv(denpf1,denc),conv(numpf1,numc)));
     x1=real(p1); y1=imag(p1);
     x1p(:,kk)=x1; y1p(:,kk)=y1;
     iip=find(imag(p1)>0);
     delta1=min(-real(p1(iip))./abs(p1(iip)));
     if delta1<delta
      delta=delta1; valuepr=valuep; flgp=1;
      Numr=Npar; Denr=Dpar; Kr=Kpar; numr=num1; denr=den1;
     end
    end
    vcol=vcolor(paract);
    ii=find(repco==vcol); vcol=vcol1(ii,:);
    axis(VV), hold on
    HH=plot(x1p,y1p,'Color',vcol,'LineStyle','none','Marker','.',...
    'MarkerSize',4); HA1=[HA1;HH];
    if index==0, index=1; end
    if flgp==1
     if nargs==4, aa=stf(Numr,Denr,Kr,str,gw); end
     for kk=1:length(HA2), eval('delete(HA2(kk))','err=1;'), end, HA2=[];
     xxv=[0 0]; yyv=[-10^4 10^4];
     hh=plot([0,-delta]*yyv(2),[0,sqrt(1-delta^2)]*yyv(2),...
     'Color',vcol1(9,:),'LineStyle','-.'); HA2=[HA2;hh];
     hh=plot([0,delta]*yyv(1),[0,sqrt(1-delta^2)]*yyv(1),...
     'Color',vcol1(9,:),'LineStyle','-.'); HA2=[HA2;hh];
     hold off
     t1=pbs(31); ym=pbs(32); yM=pbs(33); ycm=pbs(34); ycM=pbs(35);
     numpf=conv(numr,numf); denpf=conv(denr,denf);
     den0r=sumpol(conv(denpf,denc),conv(numpf,numc));
     num0r=conv(denf,conv(numr,numc));
     num0cr=conv(denf,conv(denr,numc));
     [z0r,p0r,k0r]=tozpk(num0r,den0r);
     % worst-case step responses
     [yr,tr]=prnaux(z0r,[p0r;0],k0r,201,t1); yrm=min(yr); yrM=max(yr);
     [z0cr,p0cr,k0cr]=tozpk(num0cr,den0r);
     [ycr,tcr]=prnaux(z0cr,[p0cr;0],k0cr,201,t1); ycrm=min(ycr); ycrM=max(ycr);
     VA1=zeros(1,4); VA1(2)=t1;
     VA1(3)=min([0,ym,yrm]); VA1(4)=1.2*max([yM,yrM]);
     VA2=zeros(1,4); VA2(2)=t1;
     VA2(3)=min([0,ycm,ycrm]); VA2(4)=1.2*max([ycM,ycrM]);
     axes(ax(2)), reset(gca)
     plot(t,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VA1), hold on
     plot(tr,yr,'Color',vcol1(2,:),'LineStyle','-'), hold off
     set(ax(2),'FontSize',8)
     title('uscita del sistema controllato','FontSize',10);
     axes(ax(3)), reset(gca)
     plot(tc,yc,'Color',vcol1(1,:),'LineStyle','-'), axis(VA2), hold on
     plot(tcr,ycr,'Color',vcol1(2,:),'LineStyle','-'), hold off
     set(ax(3),'FontSize',8)
     title('uscita del regolatore','FontSize',10);
     axes(ax(1))
     mess=sprintf('coeff. di smorzam.: %.3g',delta);
     set(pbs(24),'String',mess,'ForegroundColor',vcol2(2,:),'Visible','on')
     settime=-3/max(real(p0r));
     if settime<0, settime=NaN; end
     mess=sprintf('tempo di assestam.: %.4g sec',settime);
     set(pbs(25),'String',mess,'ForegroundColor',vcol2(2,:),'Visible','on')
    end
   end % if button
  end % if button==1
  if button~=1, button=4; else, ibut=1; end
  if button~=1, flgg2=0; end
 end % while flgg2
 pbs(41)=index; pbs(42)=paract; pbs(44)=button; pbs(36)=delta;
 set(pbs(27),'Enable','on')
 set(pbs(28),'Enable','on')
 if lmatpar(1)>1 | ((index==1)&(lmatpar(1)==1))
  for kk=1:lmatpar(1)+1, set(pbs(10+kk),'Enable','off'), end
  mess='Scegliere un altro parametro o "Termina" per uscire';
  if lmatpar(1)==1
   mess='Non ci sono altri parametri: cliccare su "Termina"';
  end
  set(pbs(1),'ForegroundColor',vcol2(9,:),'Visible','on','String',mess,...
  'Visible','on')
  for i=1:lmatpar(1)
   mespa=matpar(i,find(matpar(i,:)~=' '));
   mess=[mespa,sprintf('=%.3g',valparam(i))];
   set(pbs(1+i),'Visible','on','ForegroundColor',vcolorm(i,:),'String',mess)
   if (index~=1)|(i~=paract)
    set(pbs(10+i),'Enable','on')
   end
  end
  set(pbs(10+lmatpar(1)+1),'Enable','on')
 end % if lmatpar
 hold off
end
if (typ>=11)&(typ<=24)
 if length(HA)~=0
  for kk=1:length(HA), eval('delete(HA(kk))','err=1;'), end
  HA=[]; flg=1;
 else
  flg=0;
 end
end
if typ==11
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(1)=VV(1)-dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==12
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(1)=VV(1)+dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==13
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(2)=VV(2)+dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==14
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(2)=VV(2)-dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==15
 ytick=get(gca,'Ytick');
 if length(ytick)>3
  dd=ytick(2)-ytick(1); VV(4)=VV(4)+dd; VV(3)=-VV(4);
  ytick=VV(3):dd:VV(4); set(gca,'Ytick',ytick), axis(VV)
 end
elseif typ==16
 ytick=get(gca,'Ytick');
 if length(ytick)>3
  dd=ytick(2)-ytick(1); VV(4)=VV(4)-dd; VV(3)=-VV(4);
  ytick=VV(3):dd:VV(4); set(gca,'Ytick',ytick), axis(VV)
 end
elseif typ==17
 VVV=VV(1)*2;
 if VVV<VV(2), VV(1)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==18
 VVV=VV(1)/2;
 if VVV<VV(2), VV(1)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==19
 VVV=VV(2)*2;
 if VVV>VV(1), VV(2)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==20
 VVV=VV(2)/2;
 if VVV>VV(1), VV(2)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==21
 VV(4)=VV(4)*2; VV(3)=-VV(4); set(gca,'YTickMode','auto'), axis(VV)
elseif typ==22
 VV(4)=VV(4)/2; VV(3)=-VV(4); set(gca,'YTickMode','auto'), axis(VV)
elseif typ==23
 VV=VV/2; set(gca,'XTickMode','auto'), set(gca,'YTickMode','auto'), axis(VV)
elseif typ==24
 VV=VV*2; set(gca,'XTickMode','auto'), set(gca,'YTickMode','auto'), axis(VV)
end
if (typ>=11)&(typ<=24)
 if flg==1
  HA=rgrid;
 end
end
if typ==40
 for kk=11:18, set(pbs(kk),'Enable','off'), end
 set(pbs(19),'Visible','off'), set(pbs(20),'Visible','on')
end
% --- last line of robpaux ---
