function robpar(arg1,arg2,arg3,arg4)
%ROBPAR   Analisi di robustezza in presenza di variazioni parametriche (TFI).
%   Usi possibili:
%   ROBPAR,gj - da TFI
%   ROBPAR('gj') - da Matlab
%     gj : funzione di trasferimento cui ci si riferisce per definire una
%	   funzione di trasferimento parametrica gj_p; se l'argomento e'gia'
%	   una f.d.t. parametrica, essa puo' essere cambiata in interattivo.
%   ROBPAR,gi,gj_p,h,[gw] - da TFI
%   ROBPAR('gi','gj_p','h'[,'gw']) - da Matlab
%     gi: f.d.t. non parametrica nel percorso di segnale diretto
%     gj_p: f.d.t. parametrica nel percorso di segnale diretto
%     h : f.d.t. del collegamento di retroazione
%     gw: f.d.t. corrispondente a gj_p nel caso peggiore (uscita opzionale)
%   NOTA: le stringhe gi ed h possono contenere anche numeri reali positivi.
%
%   Modalita' d'uso:
%   1 - Per una qualunque funzione di trasferimento gj, si puo' definire una
%   "forma parametrica" gj_p, i cui coefficienti sono espressioni valutabili
%   in Matlab di un numero qualunque di parametri simbolici, caratterizzati
%   ciascuno da un valore nominale e da un intervallo di incertezza; gj_p
%   viene memorizzata sul disco rigido e puo' essere usata in ROBPAR o, per
%   i valori nominali dei parametri, in qualunque applicazione di TFI.
%   2 - Vengono mostrate le posizioni dei poli ad anello chiuso in presenza
%   di variazioni estremali o aleatorie di tutti i parametri nei loro
%   intervalli di incertezza.
%   3 - Viene tracciato il contorno delle radici corrispondente alla
%   variazione di un qualunque parametro nel suo intervallo di incertezza,
%   a partire da un punto (scelto con il mouse) del precedente contorno.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global ABIL TRF1 TRF2 TRF3 TRF4 SEL gr HA VV pbs ax park parN parD...
 matpar intvpar numc denc numf denf numr denr vcol1 vcol2 gw HA HA1 HA2...
 y t yc tc matn matp matx maty vparact x1p y1p valparam valuepr...
 HALEG FIGLEG LABLEG SUBPLEG

eA=setstr(232); oA=setstr(242); EA=setstr(200);
ABIL=0; fluim1=0; fluim3=0; HA=[]; gr=0; Tc=0; flg=0; HA=[]; HA1=[]; HA2=[];
nfig=gcf; nfigs=int2str(nfig); err='err'; errv=0; FIGLO=resfiglo;
FIGLEG=0; HALEG=[]; LABLEG=[]; SUBPLEG=0;
flgrip=0; % if flgrip is not zero, the root contours are not cancelled
pbs=zeros(1,60); pbs(29)=flgrip;
ms1=['\n **** errore: non si pu',oA,' cambiare figura durante l''esecuzione\n'];
if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
nargs=nargin; pbs(38)=nargs;
if (nargs~=1)&(nargs~=3)&(nargs~=4)
 disp(' **** errore: numero di argomenti in ingresso non ammesso'), return
end
if nargs==1
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1; [numc,denc,str1]=exportf(gi,1); if isempty(denc), return, end
 end
 if str1=='z'
  disp('   robpar si applica solo a sistemi a tempo continuo'), return
 end
%
%  Definition of a parametric transfer function
%
 tfg1(gi), eval(['load ',gi]), rob=-1;
 Num=Numc; Den=Denc; k=kc; str=strc;
 if exist('parkc')
  gj=gi; park=parkc; parN=parNc; parD=parDc; matpar=matparc; intvpar=intvparc;
 else
  gj=[gi,'_p'];
 end
 while (rob~=0)&(rob~=1)&(rob~=2)&(rob~=3)
  if ~exist('parkc')
   mess=['\n   definire la f.d.t. parametrica ',gj,' ? (1/0) : '];
   rob=input(mess); if rob~=1, rob=0; end
  else
   disp(' ')
   disp(['   1 - definire una nuova forma parametrica di ',gj])
   disp('   2 - cambiare le espressioni parametriche dei coefficienti')
   disp('   3 - cambiare gli intervalli di incertezza dei parametri')
   mess='\n   operare una scelta (invio per uscire) : ';
   rob=input(mess);
  end
  if isempty(rob), rob=0; end
 end
 if rob==0, return, end
 if rob==1
  disp(' ')
  disp('   ELENCO DI TUTTI I PARAMETRI :')
  matpar=[]; intvpar=[]; par=' ';
  simat=size(matpar);
  while (length(par)~=0)&(simat(1)<7)
   par=input('\n   parametro (invio per terminare l''elenco) : ','s');
   if length(par)~=0
    valnom=[];
    while length(valnom)~=1
     valnom=input('\n   valore nominale : ');
    end
    intv=[];
    while length(intv)~=2
     intv=input('\n   intervallo di variazione [min max] : ');
     if length(intv)~=0
      if valnom<intv(1) | valnom>intv(2), intv=[]; end
     end
    end
    sp=size(matpar);
    if length(par)>=sp(2)
     matpar=[' '*ones(sp(1),(length(par)-sp(2))),matpar;par];
    else
     matpar=[matpar;' '*ones(1,(sp(2)-length(par))),par];
    end
    simat=size(matpar);
    intvpar=[intvpar;intv,valnom];
   end
  end
  if simat(1)==7
   disp(' '), disp(['   il numero massimo ',eA,' sette']), disp(' ')
  end
 end
 if ((rob==1)|(rob==2))&(~isempty(matpar))
  parN=[]; parD=[];
  sn=size(Num); sd=size(Den);
  fprintf('\n   NUMERATORE :\n\n')
  fprintf('   guadagno = %.4g',k)
  park=input('\n   espressione parametrica : ','s');
  if length(park)==0, park=sprintf('%.4g',k); end
  for i=1:sn(1)
   hh=find(Num(i,:)==1);
   for j=1:sn(2)
    if j==hh(1)&hh(1)>1
     vparN=[vparN,',',sprintf('%.4g',Num(i,j))];
    elseif j==hh(1)&hh(1)==1
     vparN=sprintf('%.4g',Num(i,j));
    else
     if Num(i,j)~=0
      fprintf('   coefficiente: %.4g',Num(i,j))
      esp=input('\n   espressione parametrica : ','s');
      if length(esp)~=0
       if esp(1)=='-'
	vparN=[vparN,',(',esp,')'];
       else
	vparN=[vparN,',',esp];
       end
      else
       vparN=[vparN,',',sprintf('%.4g',Num(i,j))];
      end
     else
      if j>1, vparN=[vparN,',0']; else, vparN='0'; end
     end
    end
   end
   spN=size(parN);
   if length(vparN)<spN(2)
    vparN=[vparN,' '*ones(1,spN(2)-length(vparN))];
   else
    parN=[parN,' '*ones(spN(1),length(vparN)-spN(2))];
   end
   parN=[parN;vparN];
  end
  fprintf('\n   DENOMINATORE :\n\n')
  for i=1:sd(1)
   hh=find(Den(i,:)==1);
   for j=1:sd(2)
    if j==hh(1)&hh(1)>1
     vparD=[vparD,',',sprintf('%.4g',Den(i,j))];
    elseif j==hh(1)&hh(1)==1
     vparD=sprintf('%.4g',Den(i,j));
    else
     if Den(i,j)~=0
      fprintf('   coefficiente: %.4g',Den(i,j))
      esp=input('\n   espressione parametrica : ','s');
      if length(esp)~=0
       if esp(1)=='-'
	vparD=[vparD,',(',esp,')'];
       else
	vparD=[vparD,',',esp];
       end
      else
       vparD=[vparD,',',sprintf('%.4g',Den(i,j))];
      end
     else
      if j>1, vparD=[vparD,',0']; else, vparD='0'; end
     end
    end
   end
   spD=size(parD);
   if length(vparD)<spD(2)
    vparD=[vparD,' '*ones(1,spD(2)-length(vparD))];
   else
    parD=[parD,' '*ones(spD(1),length(vparD)-spD(2))];
   end
   parD=[parD;vparD];
  end
 end % (if rob==1)|(rob==2)
 if (rob==3)&(~isempty(matpar))
  sp=size(matpar);
  for kk=1:sp(1)
   disp(' ')
   mespa=matpar(kk,find(matpar(kk,:)~=' '));
   disp(['   parametro ',mespa,' :'])
   valnom=[];
   while length(valnom)~=1
    fprintf(['   il valore nominale attuale ',eA,' %.4g'],intvpar(kk,3))
    valnom=input('\n   nuovo valore nominale o invio : ');
    if length(valnom)==0, valnom=intvpar(kk,3); end
   end
   intvpar(kk,3)=valnom;
   intv=[];
   while length(intv)~=2
    fprintf(['   l''intervallo di variazione attuale ',eA,' [%.4g %.4g];'],...
    intvpar(kk,1),intvpar(kk,2))
    intv=input('\n   nuovo intervallo di variazione [min max] o invio : ');
    if length(intv)==0, intv=intvpar(kk,1:2); end
    if (valnom<intv(1))|(valnom>intv(2)), intv=[]; end
   end
   intvpar(kk,1:2)=intv;
  end
 end % if rob==3
 if isempty(matpar), return, end
 valuep=intvpar(:,3); valuepr=valuep;
 [Numc,Denc,kc,errv]=tfpar(parN,parD,park,matpar,valuep);
 if errv~=0, return, end
 parkc=park; parNc=parN; parDc=parD; matparc=matpar; intvparc=intvpar;
 sxx=['save ',gj,...
 ' Numc Denc kc strc Tc parkc parNc parDc matparc intvparc -v4'];
 sxx=[sxx,' -v4']; eval(sxx), tfg1(gj), disp(' ')
 return
end
%
st1=arg1(1);
rop=(abs(st1)>=48)&(abs(st1)<=57);
if rop
 st=eval(arg1,'err');
 if isstr(st), disp(' **** errore di ingresso in robpar'), return, end
else
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 end
 st=arg1; fluim1=1;
end
if isstr(st)
 [numc,denc,str1]=exportf(arg1,1); if isempty(denc), return, end
else
 numc=abs(st); denc=1; str1='s';
end
if ~exist([arg2,'.mat'])
 disp([' **** errore: ',arg2,'.mat non esiste']), return
end
[z,p,k,str2]=exportf(arg2,1); if isempty(k), return, end
[num,den]=dezpk(z,p,k); gi=arg2; st1=arg3(1);
rop=(abs(st1)>=48)&(abs(st1)<=57);
if rop
 st=eval(arg3,'err');
 if isstr(st), disp(' **** errore di ingresso in robpar'), return, end
else
 if ~exist([arg3,'.mat'])
  disp([' **** errore: ',arg3,'.mat non esiste']), return
 end
 st=arg3; fluim3=1;
end
if isstr(st)
 [numf,denf,str3]=exportf(arg3,1); if isempty(denf), return, end
else
 numf=abs(st); denf=1; str3='s';
end
if (str1=='z')|(str2=='z')|(str3=='z')
 disp('   il programma robpar si applica solo a sistemi a tempo continuo:')
 disp('   si suggerisce di usare l''equivalenza al piano w.'), return
end
%
tfblocks(4,arg1,arg2,arg3,'','','','','','')
%
tfg1(gi), eval(['load ',gi])
disp(' ')
disp('   **** premere un tasto per proseguire'), pause
Num=Numc; Den=Denc; k=kc; str=strc;
if exist('parkc')
 gj=gi; park=parkc; parN=parNc; parD=parDc; matpar=matparc; intvpar=intvparc;
else
 disp(' ')
 disp(['   ',gi,' non ',eA,' una funzione di trasferimento parametrica']);
 disp(['   richiamare robpar con ',gi,' come argomento per definire ',gi,'_p']);
 return
end
%
% execution of ROBPAR
%
clc, clf, ordf(3),
VFULL=get(gcf,'Position'); PO=get(gca,'Position'); framesc=get(gcf,'Color');
SC=diag([1/VFULL(3);1/VFULL(4);1/VFULL(3);1/VFULL(4)]);
if any(FIGLO(9,:))
 eval('set(nfig,''Position'',FIGLO(9,1:4))','erx=1;') %5.3
end
set(0,'DefaultUIControlUnits','normalized')
[vcol1,vcol2,repco,repcos]=coltbl;
colbg=vcol1(8,:); set(gcf,'Color',colbg)
%
men_opt=uimenu(nfig,'Label','Memo');
mess='analisi di robustezza parametrica';
uimenu(men_opt,'Label',mess);
mess=['regolatore : ',arg1];
if fluim1==0
 uimenu(men_opt,'Label',mess,'Separator','on');
else
 TRF1=[arg1,repco(1)];
 uimenu(men_opt,'Label',mess,'Separator','on',...
 'Callback','tfmaux(1,.96,0)');
end
mess=['sistema controllato : ',arg2];
TRF2=[arg2,repco(1)];
uimenu(men_opt,'Label',mess,...
'Callback','tfmaux(2,.9601,0)');
mess=['collegamento di retroazione : ',arg3];
if fluim3==0
 uimenu(men_opt,'Label',mess);
else
 TRF3=[arg3,repco(1)];
 uimenu(men_opt,'Label',mess,...
 'Callback','tfmaux(3,.96,0)');
end
if nargs==4
 gw=arg4; aa=stf(0,0,1,str,gw);
 TRF4=[gw,repco(2)];
 mess=['il sistema meno smorzato : ',gw];
 uimenu(men_opt,'Label',mess,...
 'Callback','tfmaux(4,.96,0)');
end
%
%  TOP MENU
%
mens=uimenu(gcf,'Label','Cambio assi'); pbs(27)=mens;
mens1=uimenu(mens,'Label','x sinistra');
mens2=uimenu(mens,'Label','x destra');
mens3=uimenu(mens,'Label','y, alto e basso','Separator','on');
%
men_gr=uimenu(nfig,'Label','Reticoli'); pbs(28)=men_gr;
uimenu(men_gr,'Label','Reticolo on/off','Callback','gridmng(1)');
uimenu(men_gr,'Label','Luoghi a delta costante on/off',...
'Callback','gridmng(4)');
%
uimenu(mens1,...
'Label','ingrandire di 1 divisione',...
'Callback','robpaux(11)');
uimenu(mens1,...
'Label','ingrandire x 2',...
'Callback','robpaux(17)');
uimenu(mens1,...
'Label','ridurre di 1 divisione',...
'Callback','robpaux(12)');
uimenu(mens1,...
'Label','ridurre x 2',...
'Callback','robpaux(18)');
uimenu(mens2,...
'Label','ingrandire di 1 divisione',...
'Callback','robpaux(13)');
uimenu(mens2,...
'Label','ingrandire x 2',...
'Callback','robpaux(19)');
uimenu(mens2,...
'Label','ridurre di 1 divisione',...
'Callback','robpaux(14)');
uimenu(mens2,...
'Label','ridurre x 2',...
'Callback','robpaux(20)');
%
uimenu(mens3,...
'Label','ingrandire di 1 divisione',...
'Callback','robpaux(15)');
uimenu(mens3,...
'Label','ingrandire x 2',...
'Callback','robpaux(21)');
uimenu(mens3,...
'Label','ridurre di 1 divisione',...
'Callback','robpaux(16)');
uimenu(mens3,...
'Label','ridurre x 2',...
'Callback','robpaux(22)');
uimenu(mens,...
'Label','zoom ad avvicinare','Separator','on',...
'Callback','robpaux(23)');
uimenu(mens,...
'Label','zoom ad allontanare',...
'Callback','robpaux(24)');
%
BB=VFULL(4)-19;
Pos=[4+120 BB 500 15]*SC;
pbs(1)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'Visible','off');
%
BB=VFULL(4)-24;
%
for kk=2:10
 Pos=[14 BB-175-15*(kk-1) 110 15]*SC;
 pbs(kk)=uicontrol(gcf,...
 'Style','text',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'BackgroundColor',colbg,...
 'Visible','off');
end
%
Pos=[4 BB 110 20]*SC;
pbs(60)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'String','Funzioni:',...
'Visible','off');
%
for kk=11:18
 Pos=[4 BB-20*(kk-10) 110 20]*SC;
 pbs(kk)=uicontrol(gcf,...
 'Style','push',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'Visible','off');
end
%
BB=VFULL(4);
Pos=[20 5 50 20]*SC;
pbs(19)=uicontrol(gcf,...
'Style','push',...
'Position',Pos,...
'String','Esci',...
'Callback','robpaux(40)');
%
Pos=[10 5 180 15]*SC;
pbs(20)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'ForegroundColor',vcol2(9,:),...
'Visible','off',...
'String','PREMERE INVIO PER USCIRE');
%
wwdth=186;
lskip=round(VFULL(4)*30/480);
for kk=21:26
 Pos=[14 lskip+(5.8-kk+20)*15 wwdth 15]*SC;
 pbs(kk)=uicontrol(gcf,...
 'Style','text',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'BackgroundColor',colbg,...
 'Visible','off');
end
%
% definition of the axes
%
delete(gca)
ax=zeros(3,1);
ax(1)=axes('Position',[0.25,.32,.675,.595],'Box','on');
set(ax(1),'FontSize',10)
ax(2)=axes('Position',[0.37,.05,.24,.18],'Box','on');
set(ax(2),'FontSize',8)
title('uscita del sistema controllato','FontSize',10);
ax(3)=axes('Position',[0.685,.05,.24,.18],'Box','on');
set(ax(3),'FontSize',8)
title('uscita del regolatore','FontSize',10);
axes(ax(1))
%
set(pbs(11),'String','Dispersione poli','Visible','on','Callback','robpaux(1)')
set(pbs(12),'String','Contorni radici','Visible','on','Callback','robpaux(3)')
set(pbs(60),'Visible','on')
%
nz=length(z); np=length(p);
% nominal closed-loop poles
numpf=conv(num,numf); denpf=conv(den,denf);
den0=sumpol(conv(denpf,denc),conv(numpf,numc));
num0=conv(denf,conv(num,numc));
num0c=conv(denf,conv(den,numc));
[z0,p0,k0]=tozpk(num0,den0);
iip=find(imag(p0)>0);
deltap=min(-real(p0(iip))./abs(p0(iip)));
np0=length(p0); x0=real(p0); y0=imag(p0); pbs(30)=np0;
%
% nominal step responses
%
[y,t]=prnaux(z0,[p0;0],k0,201,-1); ym=min(y); yM=max(y);
t1=t(length(t));
[z0c,p0c,k0c]=tozpk(num0c,den0);
[yc,tc]=prnaux(z0c,[p0c;0],k0c,201,t1); ycm=min(yc); ycM=max(yc);
pbs(31)=t1; pbs(32)=ym; pbs(33)=yM; pbs(34)=ycm; pbs(35)=ycM;
%
lmatpar=size(matpar);
iind=zeros(1,lmatpar(1));
delta=100;
Numr=Num; Denr=Den;
%
% the first plot with robustness bounds
%
if gcf~=nfig, fprintf(ms1), return, end
x1p=[]; y1p=[]; flg=1; valuep=zeros(1,lmatpar(1));
while flg==1
 iind1=iind+1;
 for inx=1:lmatpar(1)
  intvpar1=intvpar(inx,iind1(inx));
  valuep(inx)=intvpar1;
 end
 [Npar,Dpar,Kpar,errv]=tfpar(parN,parD,park,matpar,valuep);
 sn=size(Npar); sd=size(Dpar);
 num1=Kpar; den1=1;
 for i=1:sn(1)
  a=(find(Npar(i,:)~=0));
  num1=conv(num1, Npar(i,a(1):sn(2)));
 end
 for i=1:sd(1)
  a=(find(Dpar(i,:)~=0));
  den1=conv(den1, Dpar(i,a(1):sd(2)));
 end
%
 numpf1=conv(num1,numf); denpf1=conv(den1,denf);
 p1=roots(sumpol(conv(denpf1,denc),conv(numpf1,numc)));
 x1=real(p1); y1=imag(p1);
 x1p=[x1p,x1]; y1p=[y1p,y1];
 iip=find(imag(p1)>0);
 delta1=min(-real(p1(iip))./abs(p1(iip)));
 if delta1<delta
  delta=delta1; valuepr=valuep;
  Numr=Npar; Denr=Dpar; Kr=Kpar; numr=num1; denr=den1;
 end
 rr=1;
 if all(iind)==1
  flg=0;
 else
  for kk=1:length(iind)
   if rr==1
    rr=0; iind(kk)=~iind(kk);
    if iind(kk)==0, rr=1; end
   end
  end
 end
end
if nargs==4, aa=stf(Numr,Denr,Kr,str,gw); end
xxv=[0 0]; yyv=[-10^4 10^4];
VV=axis; pbs(36)=delta;
dvx=VV(2)-VV(1); dvy=VV(4)-VV(3);
mx1=min(x1p)-.1*dvx; mx2=max(x1p)+.1*dvx;
my1=min(y1p)-.1*dvy; my2=max(y1p)+.1*dvy;
bbx=[mx1,mx2,mx2,mx1]; bby=[my1,my1,my2,my2];
plot(bbx,bby,'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
plot(x0,y0,'Color',vcol1(1,:),'LineStyle','none','Marker','x',...
'MarkerSize',10,'LineWidth',2), hold on
plot(x1p,y1p,'Color',vcol1(2,:),'LineStyle','none','Marker','+')
plot(xxv,yyv,'Color',vcol1(7,:),'LineStyle',':')
hh=plot([0,-delta]*yyv(2),[0,sqrt(1-delta^2)]*yyv(2),...
'Color',vcol1(9,:),'LineStyle','-.'); HA2=[HA2;hh];
hh=plot([0,delta]*yyv(1),[0,sqrt(1-delta^2)]*yyv(1),...
'Color',vcol1(9,:),'LineStyle','-.'); HA2=[HA2;hh];
hold off, axis(VV)
title('analisi di robustezza')
%
numpf=conv(numr,numf); denpf=conv(denr,denf);
den0r=sumpol(conv(denpf,denc),conv(numpf,numc));
num0r=conv(denf,conv(numr,numc));
num0cr=conv(denf,conv(denr,numc));
[z0r,p0r,k0r]=tozpk(num0r,den0r);
% worst-case step responses
[yr,tr]=prnaux(z0r,[p0r;0],k0r,201,t1); yrm=min(yr); yrM=max(yr);
[z0cr,p0cr,k0cr]=tozpk(num0cr,den0r);
[ycr,tcr]=prnaux(z0cr,[p0cr;0],k0cr,201,t1); ycrm=min(ycr); ycrM=max(ycr);
VA1=zeros(1,4); VA1(2)=t1;
VA1(3)=min([0,ym,yrm]); VA1(4)=1.2*max([yM,yrM]);
VA2=zeros(1,4); VA2(2)=t1;
VA2(3)=min([0,ycm,ycrm]); VA2(4)=1.2*max([ycM,ycrM]);
axes(ax(2)), reset(gca)
plot(t,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VA1), hold on
plot(tr,yr,'Color',vcol1(2,:),'LineStyle','-'), hold off
set(ax(2),'FontSize',8)
title('uscita del sistema controllato','FontSize',10);
axes(ax(3)), reset(gca)
plot(tc,yc,'Color',vcol1(1,:),'LineStyle','-'), axis(VA2), hold on
plot(tcr,ycr,'Color',vcol1(2,:),'LineStyle','-'), hold off
set(ax(3),'FontSize',8)
title('uscita del regolatore','FontSize',10);
axes(ax(1))
mess=sprintf('coeff. di smorzam.: %.4g',deltap);
set(pbs(22),'String',mess,'ForegroundColor',vcol2(1,:),'Visible','on')
settime=-3/max(real(p0));
if settime<0, settime=NaN; end
mess=sprintf('tempo di assestam.: %.4g sec',settime);
set(pbs(23),'String',mess,'ForegroundColor',vcol2(1,:),'Visible','on')
mess=sprintf('coeff. di smorzam.: %.3g',delta);
set(pbs(24),'String',mess,'ForegroundColor',vcol2(2,:),'Visible','on')
settime=-3/max(real(p0r));
if settime<0, settime=NaN; end
mess=sprintf('tempo di assestam.: %.4g sec',settime);
set(pbs(25),'String',mess,'ForegroundColor',vcol2(2,:),'Visible','on')
mess='poli nominali';
set(pbs(2),'String',mess,'ForegroundColor',vcol2(1,:),'Visible','on')
mess='poli estremali';
set(pbs(3),'String',mess,'ForegroundColor',vcol2(2,:),'Visible','on')
figure(nfig), ABIL=1;
xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
cc=get(0,'Children');
if any(cc==nfig)
 FIGLO(9,1:4)=get(nfig,'Position');
 save figlo# FIGLO -v4
else
 disp(' '), disp(['   ',EA,' STATA CANCELLATA LA FIGURA!'])
end
hold off
clc
delta=pbs(36);
fprintf('\n   IL SISTEMA MENO SMORZATO :\n\n')
fprintf('   (delta = %.4g)\n\n',delta)
for i=1:lmatpar(1)
 parameter=[matpar(i,:),' = ',sprintf('%.4g',valuepr(i))];
 fprintf('   '), fprintf(parameter), fprintf('\n')
end
if nargs==4, tfg1(gw), end
eval('delete(ax(2))','err=1;'), eval('delete(ax(3))','err=1;'), ABIL=0;
for kk=1:28, eval('delete(pbs(kk))','err=1;'), end
eval('delete(pbs(60))','err=1;')
set(gca,'Position',PO), set(gcf,'Color',framesc)
set(0,'DefaultUIControlUnits','pixel'), ordf(1)
% --- last line of robpar ---
