function [Num,Den,k]=ridg(Numc,Denc,kc)
%RIDG	  Cancellation of common factors (aux for TFI).
%   [Num,Den,k]=RIDG(Numc,Denc,kc) cancels the common factors of Numc,Denc.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(3,3,nargs));
if kc==0|isfinite(kc)==0
 Num=1; Den=1; k=kc;
else
 ln=size(Numc); ld=size(Denc);
 x=max([ln(2),ld(2)]);
 if (x-ln(2))==0
  Denc=[zeros(ld(1),x-ld(2)) Denc];
 elseif (x-ln(2))>0
  Numc=[zeros(ln(1),x-ln(2)) Numc];
 end
 a=ones(1,ln(1)); b=ones(1,ld(1));
 for i=1:ln(1)
  q=find(Numc(i,:)~=0);
  if length(q)~=0
   if Numc(i,q(1))~=1
    kc=kc*Numc(i,q(1)); Numc(i,:)=Numc(i,:)/Numc(i,q(1));
   end
  end
 end
 for j=1:ld(1)
  q=find(Denc(j,:)~=0);
  if length(q)~=0
   if Denc(j,q(1))~=1
    kc=kc/Denc(j,q(1)); Denc(j,:)=Denc(j,:)/Denc(j,q(1));
   end
  end
 end
 for i=1:ln(1)
  for j=1:ld(1)
   if ~(any(Numc(i,:)-Denc(j,:)))
    a(i)=0; b(j)=0; Denc(j,:)=zeros(1,x); break
   end
  end
 end
 k=kc;
 for i=1:ln(1)
  if Numc(i,:)==[zeros(1,x-1),1], a(i)=0; end
 end
 for i=1:ld(1)
  if Denc(i,:)==[zeros(1,x-1),1], b(i)=0; end
 end
 snc=size(Numc(find(a),:)); kk=0;
 if all(a==0)|all(snc==[0,0])
  Num=1;
 else
  for ii=1:snc(2)
   if Numc(find(a),ii)==zeros(snc(1),1), kk=kk+1; else, break, end
  end
  Num=Numc(find(a),kk+1:snc(2));
 end
 sdc=size(Denc(find(b),:)); kk=0;
 if all(b==0)|all(sdc==[0,0])
  Den=1;
 else
  for ii=1:sdc(2)
   if Denc(find(b),ii)==zeros(sdc(1),1), kk=kk+1; else, break, end
  end
  Den=Denc(find(b),kk+1:sdc(2));
 end
end
% --- last line of ridg ---
