function out1=rgrid(s)
%RGRID	  Constant damping factor loci for a root locus plot.
%   RGRID(1) clears the graphics screen and sets HOLD ON so that the
%   root locus can be plot over the grid.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

[tp1,tp2,tp3,tp4]=coltbl;
if tp1(7,1)==1, BW='w'; else, BW='k'; end
status=ishold;
if nargin==1
 VV=[-2 2 -1.5 1.5]; hold off
else
 VV=axis; hold on
end
fsize=get(gca,'FontSize'); fsize=fsize-2;
%
i=sqrt(-1); ha=[];
%
% Plot constant delta lines
%
delta=[.1 .2 .3 .4 .5 .6 .7 .8 .9];
%
Om=VV(3);
omv=[0 Om];
[d,om]=meshgrid(delta,omv);
sig=om.*d./(sqrt(1-d.^2));
xx=sig; yy=om;
ha1=plot(xx,yy,[BW,':']);
ha=[ha;ha1];
hold on
Om=VV(4);
omv=[0 Om];
[d,om]=meshgrid(delta,omv);
sig=-om.*d./(sqrt(1-d.^2));
xx=sig; yy=om;
ha1=plot(xx,yy,[BW,':']);
ha=[ha;ha1];
%
% Label the plotted lines
%
ddx=VV(2)-VV(1);
xx1=VV(1)+.03*ddx;
ddy=VV(4)-VV(3);
yy1=VV(4)-.05*ddy;
for k=1:length(delta)
 xp=max(xx(2,k),xx1)+.003*ddx;
 yp=min(-xp*sqrt(1-delta(k)^2)/delta(k),yy1);
 if (xp>=VV(1))&(xp<=VV(2))&(yp>=VV(3))&(yp<=VV(4))
  ha1=text(xp,yp,sprintf('.%1.0f',delta(k)*10),'FontSize',fsize);
  ha=[ha;ha1];
 end
end
%
% Plot constant omega_n lines
%
%Om=max(abs([VV(3),VV(4)]));
%omv=[.1 .2 .3 .4 .5 .6 .7 .8 .9 1]*10^(ceil(log10(Om)));
ytick=get(gca,'Ytick'); yym=ytick(find(ytick<0)); yyp=ytick(find(ytick>0));
if length(yym)>length(yyp)
 omv=abs(yym);
else
 omv=yyp;
end
delta=linspace(0,.9,24);
%
[d,om]=meshgrid(delta,omv);
sig=-om.*d;
xx=sig; yy=om.*(sqrt(1-d.^2));
for kk=1:2
 ha1=plot(xx',-yy'*(-1)^kk,[BW,':']);
 ha=[ha;ha1];
end
%
if nargin==1
 axis([-2 2 -1.5 1.5])
else
 axis(axis)
end
%
if (nargin==0)&(~status), hold off, end %  return hold to previous status
if nargout==0
 return
else
 out1=ha;
end
% --- last line of rgrid ---
