function regrootl(arg1,arg2,arg3,arg4)
%REGROOTL Progetto di regolatori con il luogo delle radici (TFI).
%    REGROOTL,gp,gc - da TFI
%    REGROOTL('gp','gc') - da Matlab
%    gp: funzione di trasferimento del sistema controllato (ingresso)
%    gc: funzione di trasferimento del regolatore (uscita)
%    Se REGROOTL viene chiamato senza alcun argomento, le f.d.t. gp e gc
%    possono essere specificate in interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global pbs VV ABIL TRF1 TRF2 gr HA str repco HA1 HA2 zdata pdata kdata...
 zcomp pcomp kcomp TT gi gj vcol1 vcol2 flgdph...
 stkn1 stkd1 stkn2 stkd2 stkn3 stkd3 stkn4 stkd4 stkn5 stkd5 stkn6 stkd6...
 messd1 messd2 messd3 messd4 messd5 messd6 NPKK polcl HA3 minpol...
 HALEG FIGLEG LABLEG SUBPLEG

nfig=gcf; nfigs=int2str(nfig); ABIL=1; flg1=0; gr=0; HA=[]; frame=.1;
flgdph=0; polcl=[]; HA1=[]; HA2=[]; HA3=[]; minpol=0; pbs=zeros(1,100);
zcomp=[]; pcomp=[]; kcomp=1; FIGLO=resfiglo; uA=setstr(249); EA=setstr(200);
stkn1=1; stkd1=1; stkn2=1; stkd2=1; stkn3=1; stkd3=1; stkn4=1; stkd4=1;
stkn5=1; stkd5=1; stkn6=1; stkd6=1;
FIGLEG=nfig; HALEG=[]; LABLEG=[]; SUBPLEG=0;
NPKK=0; err='err'; flgdis=0; str=[]; strc='s';
if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
pbs(58)=legen; pbs(59)=islegen;
if nargin==0
 arg1='xx'; flg=0;
 while flg==0
  mess='\n   funzione di trasferimento del sistema controllato (ingresso) : ';
  gi=input(mess,'s');
  if isempty(gi), gi='0'; end, if gi=='0', return, end
  if ~isempty(gi)
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1; flgdis=1;
   end
  end
 end
 [zdata,pdata,kdata,str]=exportf(gi,1); if isempty(kdata), return, end
 while flg==1
  mess='\n   funzione di trasferimento del regolatore (uscita) : ';
  gj=input(mess,'s');
  if isempty(gj), gj='0'; end, if gj=='0', return, end
  if ~isempty(gj), flg=2; end
 end
elseif nargin>=2
 st1=arg1(1);
 rop=(abs(st1)>=48)&(abs(st1)<=57);
 if rop
  st=eval(arg1,'err');
  if isstr(st), disp(' **** errore di ingresso in regrootl'), return, end
  if err==1, disp(' **** errore di ingresso in regrootl'), return, end
 else
  if ~exist([arg1,'.mat'])
   disp([' **** errore: ',arg1,'.mat non esiste']), return
  end
  st=arg1; flgdis=1;
 end
 if isstr(st)
  gi=arg1;
  [zdata,pdata,kdata,str]=exportf(gi,1); if isempty(kdata), return, end
 else
  zdata=[];, pdata=[]; kdata=abs(st); gi='--';
 end
 gj=arg2;
else
 disp(' **** errore: numero di argomenti non sufficiente'), return
end
zcomp=[]; pcomp=[]; kcomp=1;
%
pbs(53)=flgdis;
if flgdis==1, tfblocks(3,gj,gi,'','','','','','','',''), end
if isempty(str)&(~isempty(strc)), str=strc; end
%
flgmod=0;
if isempty([zdata;pdata;zcomp;pcomp])
 flgmod=1;
 ddd=input('\n   tempo discreto ? (1) : ');
 if isempty(ddd), ddd=0; end
 if ddd==1
  str='z';
 else
  str='s';
 end
end
%
clf, ordf(3), hold off, framesc=get(0,'DefaultFigureColor');
VFULL=get(gcf,'Position');
SC=diag([1/VFULL(3);1/VFULL(4);1/VFULL(3);1/VFULL(4)]);
set(0,'DefaultUIControlUnits','normalized')
if any(FIGLO(4,:))
 eval('set(nfig,''Position'',FIGLO(4,1:4))','erx=1;') %5.3
end
[vcol1,vcol2,repco,repcos]=coltbl; colbg=vcol1(8,:); set(gcf,'Color',colbg)
%
nfig1=nfig+1; figure(nfig1), clf, ordf(6) %5.3
if any(FIGLO(4,:))
 eval('set(nfig1,''Position'',FIGLO(4,5:8))','erx=1;')
end
pbs(51)=uimenu(gcf,'Label','Memo');
men1=uimenu(gcf,'Label','Asse tempi'); pbs(92)=men1;
uimenu(men1,'Label','ingrandire x 2',...
'Callback','regroaux(25)');
uimenu(men1,'Label','ingrandire x 5','Separator','on',...
'Callback','regroaux(26)');
uimenu(men1,'Label','ingrandire x 10','Separator','on',...
'Callback','regroaux(27)');
uimenu(men1,'Label','ingrandire x 20','Separator','on',...
'Callback','regroaux(28)');
uimenu(men1,'Label','ripristinare la scala iniziale','Separator','on',...
'Callback','regroaux(29)');
pbs(93)=uimenu(gcf,'Label','Reticolo on/off','Callback','gridmng(13)');
pbs(94)=uimenu(gcf,'Label','Zoom on/off','Callback','gridmng(7)');
set(pbs(51),'Enable','off')
for kk=92:94, set(pbs(kk),'Enable','off'), end
BB=VFULL(4);
Pos=[150 BB-120 200 20]*SC;
pbs(47)=uicontrol(gcf,...
'Style','Text',...
'Position',Pos,...
'BackgroundColor',colbg,...
'ForegroundColor',vcol2(2,:),...
'Visible','off',...
'String','ATTENDERE, PREGO');
Pos=[20 5 50 20]*SC;
pbs(48)=uicontrol(gcf,...
'Style','push',...
'Position',Pos,...
'Visible','off',...
'String','Menu',...
'Callback','regroaux(39)');
%
nfig2=nfig+2; figure(nfig2), clf, ordf(7) %5.3
if any(FIGLO(4,:))
 eval('set(nfig2,''Position'',FIGLO(4,9:12))','erx=1;')
end
pbs(52)=uimenu(gcf,'Label','Memo');
men2=uimenu(gcf,'Label','Asse omega'); pbs(97)=men2;
men2_1=uimenu(men2,'Label','Sinistra');
uimenu(men2_1,'Label',['pi',uA,' una decade'],'Callback','regroaux(45)')
uimenu(men2_1,'Label','meno una decade','Callback','regroaux(46)')
men2_2=uimenu(men2,'Label','Destra','Separator','on');
uimenu(men2_2,'Label',['pi',uA,' una decade'],'Callback','regroaux(47)')
uimenu(men2_2,'Label','meno una decade','Callback','regroaux(48)')
pbs(98)=uimenu(gcf,'Label','Reticolo on/off','Callback','gridmng(14)');
pbs(99)=uimenu(gcf,'Label','Zoom on/off','Callback','gridmng(8)');
set(pbs(52),'Enable','off')
for kk=97:99, set(pbs(kk),'Enable','off'), end
BB=VFULL(4);
Pos=[150 BB-120 200 20]*SC;
pbs(49)=uicontrol(gcf,...
'Style','Text',...
'Position',Pos,...
'BackgroundColor',colbg,...
'ForegroundColor',vcol2(2,:),...
'Visible','off',...
'String','ATTENDERE, PREGO');
Pos=[20 5 50 20]*SC;
pbs(50)=uicontrol(gcf,...
'Style','push',...
'Position',Pos,...
'Visible','off',...
'String','Menu',...
'Callback','regroaux(39)');
figure(nfig1), figure(nfig), set(gca,'Box','on')
%
j=sqrt(-1); flmain=0; pbs(27)=1; pbs(28)=nfig;
%
TRF1=[gi,repco(7)];
men_opt=uimenu(gcf,'Label','Memo');
mess=[gi,', sistema controllato'];
if flgdis==0, clb=''; else, clb='tfmaux(1,0,1)'; end
uimenu(men_opt,'Label',mess,...
'Callback',clb);
TRF2=[gj,repco(1)];
mess=[gj,', regolatore'];
men_optt=uimenu(men_opt,'Label',mess);
uimenu(men_optt,'Label','zeri-poli',...
'Callback','tfmaux(2,0,1)');
uimenu(men_optt,'Label','costanti di tempo',...
'Callback','tfmaux(2,0,1,1)');
%
%  TOP MENU
%
pbs(25)=uimenu(gcf,'Label','Cambio assi'); % mens
mens1=uimenu(pbs(25),'Label','x sinistra');
mens2=uimenu(pbs(25),'Label','x destra');
mens3=uimenu(pbs(25),'Label','y, alto e basso','Separator','on');
%
pbs(26)=uimenu(nfig,'Label','Reticoli');
uimenu(pbs(26),'Label','Reticolo on/off','Callback','gridmng(1)');
uimenu(pbs(26),'Label','Luoghi a delta costante on/off',...
'Callback','gridmng(5)');
%
uimenu(mens1,...
'Label','ingrandire di 1 divisione',...
'Callback','regroaux(11)');
uimenu(mens1,...
'Label','ingrandire x 2',...
'Callback','regroaux(17)');
uimenu(mens1,...
'Label','ridurre di 1 divisione',...
'Callback','regroaux(12)');
uimenu(mens1,...
'Label','ridurre x 2',...
'Callback','regroaux(18)');
uimenu(mens2,...
'Label','ingrandire di 1 divisione',...
'Callback','regroaux(13)');
uimenu(mens2,...
'Label','ingrandire x 2',...
'Callback','regroaux(19)');
uimenu(mens2,...
'Label','ridurre di 1 divisione',...
'Callback','regroaux(14)');
uimenu(mens2,...
'Label','ridurre x 2',...
'Callback','regroaux(20)');
%
uimenu(mens3,...
'Label','ingrandire di 1 divisione',...
'Callback','regroaux(15)');
uimenu(mens3,...
'Label','ingrandire x 2',...
'Callback','regroaux(21)');
uimenu(mens3,...
'Label','ridurre di 1 divisione',...
'Callback','regroaux(16)');
uimenu(mens3,...
'Label','ridurre x 2',...
'Callback','regroaux(22)');
uimenu(pbs(25),...
'Label','zoom ad avvicinare','Separator','on',...
'Callback','regroaux(23)');
uimenu(pbs(25),...
'Label','zoom ad allontanare',...
'Callback','regroaux(24)');
%
BB=VFULL(4)-24;
%
Pos=[4 BB 114 20]*SC;
pbs(1)=uicontrol(gcf,...
'Style','text',...
'String','Funzioni:',...
'Visible','off',...
'Position',Pos);
%
for kk=0:9 % 2->11
 Pos=[4 BB-20*(kk+1) 114 20]*SC;
 pbs(2+kk)=uicontrol(gcf,...
 'Style','push',...
 'Position',Pos,...
 'Visible','off');
end
%
for kk=0:1 % 29->30
 Pos=[118 BB-180-kk*20 120 20]*SC;
 pbs(29+kk)=uicontrol(gcf,...
 'Style','push',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'Visible','off');
end
Pos=[118 BB-220 120 20]*SC; % 83 = Sens.fnct.
pbs(83)=uicontrol(gcf,...
'Style','push',...
'Position',Pos,...
'HorizontalAlignment','left',...
'Visible','off');
%
for kk=0:1 % 31->32
 Pos=[118 BB-120-kk*20 80 20]*SC;
 pbs(31+kk)=uicontrol(gcf,...
 'Style','push',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'Visible','off');
end
set(pbs(31),'String','Positivo'), set(pbs(32),'String','Negativo')
%
Pos=[20 5 50 20]*SC;
pbs(81)=uicontrol(gcf,...
'Style','push',...
'Position',Pos,...
'String','Esci',...
'Visible','on',...
'Callback','regroaux(40)');
%
BB=VFULL(4)-14;
%
for kk=0:1 % 23->24
 Pos=[128 BB-15*kk 500 15]*SC;
 pbs(23+kk)=uicontrol(gcf,...
 'Style','text',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'BackgroundColor',colbg,...
 'Visible','off');
end
%
Pos=[190 BB-120 350 15]*SC;
pbs(82)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'Visible','off');
%
Pos=[10 BB-240 108 15]*SC;
pbs(12)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'Visible','off');
%
for kk=0:2 % 13->15
 Pos=[10 BB-262-15*kk 110 15]*SC;
 pbs(13+kk)=uicontrol(gcf,...
 'Style','text',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'BackgroundColor',colbg,...
 'Visible','off');
end
%
for kk=0:3 % 16->19
 Pos=[10 BB-312-kk*15 140 15]*SC;
 pbs(16+kk)=uicontrol(gcf,...
 'Style','text',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'BackgroundColor',colbg,...
 'Visible','off');
end
%
Pos=[10 5 500 15]*SC;
pbs(20)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'ForegroundColor',vcol2(9,:),...
'Visible','off');...
%
Pos=[180 BB-55 90 20]*SC;
pbs(21)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'Visible','off');
%
Pos=[14 28 60 20]*SC;
pbs(22)=uicontrol(gcf,...
'Style','push',...
'String','Annulla',...
'Position',Pos,...
'Visible','off');
%
set(pbs(1),'Visible','on')
set(pbs(2),'String','Aggiungi zeri','Visible','on','Callback','regroaux(1)')
set(pbs(3),'String','Elimina zeri','Visible','on','Callback','regroaux(2)')
if isempty(zcomp), set(pbs(3),'Enable','off'), end
set(pbs(4),'String','Aggiungi poli','Visible','on','Callback','regroaux(3)')
set(pbs(5),'String','Elimina poli','Visible','on','Callback','regroaux(4)')
if isempty(pcomp), set(pbs(5),'Enable','off'), end
set(pbs(6),'String','Azzera mappa','Visible','on','Callback','regroaux(5)')
set(pbs(7),'String','Luogo radici','Visible','on','Callback','regroaux(41)')
set(pbs(8),'String','Altro regolatore','Visible','on',...
'Callback','regroaux(10)')
set(pbs(9),'String','Eq. diofantea','Visible','on',...
'Callback','regroaux(7)')
set(pbs(10),'String','Risp. gradino','Visible','on','Callback','regroaux(31)')
set(pbs(11),'String','Diag. di Bode','Visible','on','Callback','regroaux(32)')
mess1='Introdurre con il mouse la mappa zeri-poli del regolatore';
set(pbs(23),'String',mess1,'ForegroundColor',vcol2(9,:),'Visible','on')
mess2='Assegnare il guadagno scegliendo un punto sul luogo delle radici';
set(pbs(24),'String',mess2,'ForegroundColor',vcol2(9,:),'Visible','on')
mess='Regolatore N. 1';
set(pbs(12),'String',mess,'ForegroundColor',vcol2(1,:),'Visible','on')
mess=sprintf('K = %.3g',kdata);
set(pbs(13),'String',mess,'ForegroundColor',vcol2(1,:),'Visible','on')
%set(pbs(20),'Visible','on')
mess=sprintf('Kc = %.3g',kcomp);
set(pbs(14),'String',mess,'ForegroundColor',vcol2(1,:),'Visible','on')
nz=length(zcomp); np=length(pcomp);
mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
set(pbs(15),'String',mess,'ForegroundColor',vcol2(1,:),'Visible','on')
%
if flgmod==0
 zp=[zdata;pdata;zcomp;pcomp]; xxx=real(zp); yyy=imag(zp);
 xi=min(xxx); xs=max(xxx); yi=min(yyy); ys=max(yyy);
 if yyy==0, ys=1*(xs-xi)/2; yi=-ys; end
 dx=(xs-xi)*frame; dy=(ys-yi)*frame;
 xi=xi-dx; xs=xs+dx; yi=yi-dy; ys=ys+dy;
 plot([xi,xi,xs,xs],[yi,ys,ys,yi],'Color',vcol1(8,:),'LineStyle','none',...
 'Marker','.')
 VV=axis; axis(VV), hold on
 if ~isempty(zdata)
  ha=plot(real(zdata),imag(zdata),'Color',vcol1(7,:),'LineStyle','none',...
  'Marker','o','LineWidth',2); HA1=[HA1;ha];
 end
 if ~isempty(pdata)
  ha=plot(real(pdata),imag(pdata),'Color',vcol1(7,:),'LineStyle','none',...
  'Marker','x','MarkerSize',10,'LineWidth',2); HA1=[HA1;ha];
 end
else
 if str=='s'
  VV=[-5 1 -2 2];
 else
  VV=[-2 2 -1.5 1.5];
 end
end
%
if str=='s'
 aa=importf(zcomp,pcomp,kcomp,gj);
else
 aa=importf(zcomp,pcomp,kcomp,gj,1);
end
%
if str=='z', pbs(54)=lsamp; end
%
hold on
plot([0,0],[-10^8,10^8],'Color',vcol1(7,:),'LineStyle',':')
plot([-10^8,10^8],[0,0],'Color',vcol1(7,:),'LineStyle',':')
if str=='z'
 ang=2*pi*linspace(0,1,200); circ=cos(ang)+j*sin(ang);
 plot(circ,'Color',vcol1(7,:),'LineStyle',':')
end
axis(VV), set(gca,'Box','on'), ax1=gca;
PO=get(ax1,'Position');
pp(1)=PO(1)+.12; pp(2)=PO(2); pp(3)=PO(3)-.1; pp(4)=PO(4)-.02;
set(ax1,'Position',pp)
hold off
if islegen
 VV=axis; xx=2*VV(1)-VV(2); yy=2*VV(3)-VV(4);
 LABLEG=['''',gi,''',''',gj,''''];
 hold on, HAL=plot(xx,yy,xx,yy);
 set(HAL(1),'Color',vcol1(7,:)), set(HAL(2),'Color',vcol1(1,:)), hold off
 if legen==1, eval(['legend(HAL,',LABLEG,',3)']); end
end
xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
if islegen
 VV=axis; xx=2*VV(1)-VV(2); yy=2*VV(3)-VV(4); flcomp=pbs(27);
 hold on, HAL=plot(xx,yy,xx,yy);
 set(HAL(1),'Color',vcol1(7,:)), set(HAL(2),'Color',vcol1(flcomp,:))
 hold off
end
HALEG=HAL;
cc=get(0,'Children');
if (any(cc==nfig))&(any(cc==nfig1))&(any(cc==nfig2))
 FIGLO(4,1:4)=get(nfig,'Position');
 FIGLO(4,5:8)=get(nfig1,'Position');
 FIGLO(4,9:12)=get(nfig2,'Position');
 save figlo# FIGLO -v4
else
 disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), ordf, return
end
if pbs(55)==0
 eval('delete(nfig1)','err=1;'), eval('delete(nfig2)','err=1;')
 clf, ordf(1), return
end
flcomp=pbs(27);
clc
if flcomp>1
 xx=0;
 while xx==0
  col=input('\n   scegliere la funzione specificandone il colore : ','s');
  if isempty(col), col='z'; end
  if col=='0', return, end
  ropc=0; for kk=1:6, ropc=ropc|strcmp(col,repco(kk)); end
  if ropc
   if find(repco==col)<=flcomp
    xx=1;
   end
  end
 end
else
 col=repco(1);
end
q=find(repco==col);
eval(['numc=stkn',int2str(q),';'])
eval(['denc=stkd',int2str(q),';'])
[zregt,pregt,kregt]=tozpk(numc,denc);
if str=='s'
 aa=importf(zregt,pregt,kregt,gj);
else
 aa=importf(zregt,pregt,kregt,gj,1);
end
disp(' ')
disp('   IL REGOLATORE OTTENUTO :')
if aa==1, tfg(gj), end
eval('delete(nfig1)','err=1;'), eval('delete(nfig2)','err=1;'), ABIL=0;
for kk=1:26, eval('delete(pbs(kk))','err=1;'), end
for kk=29:32, eval('delete(pbs(kk))','err=1;'), end
for kk=81:83, eval('delete(pbs(kk))','err=1;'), end
set(nfig,'Color',framesc)
set(ax1,'Position',PO)
set(0,'DefaultUIControlUnits','pixel'), ordf(1), return
% --- last line of regrootl ---
