function regroaux(arg1)
%REGROAUX  Auxiliary file for graphic management related to reglocus.
%     **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global pbs VV gr HA str repco HA1 HA2 zdata pdata kdata zcomp pcomp kcomp...
 TT gi gj TRF1 TRF2 vcol1 vcol2 flgdph...
 stkn1 stkd1 stkn2 stkd2 stkn3 stkd3 stkn4 stkd4 stkn5 stkd5 stkn6 stkd6...
 messd1 messd2 messd3 messd4 messd5 messd6 NPKK polcl HA3 minpol...
 HALEG LABLEG

aA=setstr(224); eA=setstr(232); oA=setstr(242); EA=setstr(200);
typ=arg1; flg=0; stp=1; flgd=[0,0]; ndiv=[0,0]; HH1=[]; tol=10^(-8);
nfig=pbs(28); flcomp=pbs(27); TSAMP=pbs(54); pbs(55)=1; flaxis=0;
mess1='Introdurre con il mouse la mappa zeri-poli del regolatore.';
mess2='Assegnare il guadagno scegliendo un punto sul luogo delle radici.';
mess3=['Scegliere i poli ad anello chiuso da assegnare con l''equazione',...
' diofantea.'];
mess4=['Il minimo numero di poli da assegnare ',eA];
mess4=[mess4,sprintf(' %i',minpol)];
mess4=[mess4,' (per ottenere la causalit',aA,').'];
mx1='PREMERE INVIO PER USCIRE';
mx2='PULSANTE 1 PER RIPETERE, 2 PER ACCETTARE';
%
if (typ<=10)|(typ>=25)
 set(pbs(20),'Visible','off'), set(pbs(81),'Visible','off')
end
%
if ((typ>=1)&(typ<=4))|(typ==6)|(typ==9)
 set(pbs(26),'Enable','off')
 set(pbs(25),'Enable','off')
 set(pbs(22),'Visible','on')
end
if typ==1
 mess=['Scegliere la posizione di uno zero reale o una coppia di zeri ',...
 'complessi.'];
 set(pbs(23),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 mess=['Si pu',oA,' ripetere la scelta col pulsante 1 del mouse. ',...
 'Il pulsante 2 la conferma.'];
 set(pbs(24),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 bb=1; hh=0; hold on
 while bb==1
  [x1s,y1s,bb]=ginput(1);
  if isempty(bb), bb=2; end
  if (x1s<VV(1))&(bb==1)
   if hh~=0
    eval('delete(ha)','err=1;')
   end
   set(pbs(25),'Enable','on')
   set(pbs(26),'Enable','on')
   set(pbs(22),'Visible','off')
   set(pbs(23),'String',mess1,'ForegroundColor',vcol2(9,:))
   set(pbs(24),'String',mess2,'ForegroundColor',vcol2(9,:))
   set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
   set(pbs(81),'Visible','on'), set(pbs(20),'Visible','off')
   for kk=2:11, set(pbs(kk),'Enable','on'), end
   if isempty(zcomp), set(pbs(3),'Enable','off'), end
   if isempty(pcomp), set(pbs(5),'Enable','off'), end
   return
  end
  if isempty(bb), bb=2; end
  if hh==0, bb=1; end
  if bb==1
   x1=x1s; y1=y1s;
   if hh~=0
    for kk=1:length(ha)
     delete(ha(kk))
    end
   end
   set(pbs(81),'Visible','off')
   set(pbs(20),'String',mx2,'ForegroundColor',vcol2(9,:),'Visible','on')
   if y1<=0
    ha=plot(x1,0,'Color',vcol1(flcomp,:),'LineStyle','none',...
    'Marker','o','LineWidth',2);
    if (abs(x1)<4*10^(-3)*(VV(2)-VV(1))), x1=0; end
    if str=='z'
     if (abs(x1-1)<4*10^(-3)*(VV(2)-VV(1))), x1=1; end
    end
    zcomp1=x1;
    mess=sprintf('z = %.3g',x1);
    set(pbs(16),'ForegroundColor',vcol2(flcomp,:),'Visible','on',...
    'String',mess), set(pbs(17),'Visible','off')
   else
    ha=plot([x1,x1],[-y1,y1],'Color',vcol1(flcomp,:),'LineStyle','none',...
    'Marker','o','LineWidth',2);
    zcomp1=[x1+j*y1;x1-j*y1];
    mess=sprintf('z1 = j*%.3g',x1); mess=[mess,sprintf('+j*%.3g',y1)];
    set(pbs(16),'ForegroundColor',vcol2(flcomp,:),'Visible','on',...
    'String',mess)
    mess=sprintf('z2 = j*%.3g',x1); mess=[mess,sprintf('-j*%.3g',y1)];
    set(pbs(17),'ForegroundColor',vcol2(flcomp,:),'Visible','on',...
    'String',mess)
   end
  end
  hh=1;
 end
 zcomp=[zcomp;zcomp1]; HA2=[HA2;ha];
 set(pbs(3),'Enable','on')
 set(pbs(22),'Visible','off')
 set(pbs(23),'String',mess1,'ForegroundColor',vcol2(9,:))
 set(pbs(24),'String',mess2,'ForegroundColor',vcol2(9,:))
 set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
 nz=length(zcomp); np=length(pcomp);
 mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
 set(pbs(15),'String',mess)
elseif typ==2
 mess=[' Scegliere uno zero reale o una coppia di zeri complessi ',...
 'da eliminare.'];
 set(pbs(23),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 set(pbs(24),'Visible','off')
 set(pbs(22),'Visible','on')
 xtick=get(gca,'Xtick'); ytick=get(gca,'Ytick');
 bb=1; hh=0; hold on
 [x1s,y1s,bb]=ginput(1);
 if isempty(bb), bb=2; end
 if (x1s<VV(1))|(bb~=1)
  set(pbs(25),'Enable','on')
  set(pbs(26),'Enable','on')
  set(pbs(22),'Visible','off')
  set(pbs(23),'String',mess1,'ForegroundColor',vcol2(9,:))
  set(pbs(24),'Visible','on')
  set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
  set(pbs(81),'Visible','on'), set(pbs(20),'Visible','off')
  return
 end
 x1=x1s; y1=y1s;
 zcomp1=x1+j*y1;
 ii=ones(1,length(zcomp));
 [zzz,iim]=min(abs(zcomp-zcomp1)); ii(iim)=0;
 if imag(zcomp(iim))~=0
  [zzz,iim]=min(abs(zcomp-conj(zcomp(iim)))); ii(iim)=0;
 end
 ii=find(ii); zcomp=zcomp(ii);
 for kk=1:length(HA2), eval('delete(HA2(kk))','err=1;'), end, HA2=[];
 if ~isempty(zcomp)
  ha=plot(real(zcomp),imag(zcomp),'Color',vcol1(flcomp,:),'LineStyle',...
  'none','Marker','o','LineWidth',2); HA2=[HA2;ha];
 end
 if ~isempty(pcomp)
  ha=plot(real(pcomp),imag(pcomp),'Color',vcol1(flcomp,:),'LineStyle',...
  'none','Marker','x','MarkerSize',10,'LineWidth',2); HA2=[HA2;ha];
 end
 if isempty(zcomp), set(pbs(3),'Enable','off'), end
 set(pbs(22),'Visible','off')
 set(pbs(23),'String',mess1,'ForegroundColor',vcol2(9,:))
 set(pbs(24),'Visible','on')
 set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
 nz=length(zcomp); np=length(pcomp);
 mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
 set(pbs(15),'String',mess)
elseif typ==3
 xcol=vcol2(flcomp,:);
 if flgdph==1
  if length(polcl)<1, set(pbs(9),'Enable','off'), end
 else
  set(pbs(9),'Enable','on')
 end
 mess=['Scegliere la posizione di un polo reale o una coppia di poli ',...
 'complessi.'];
 set(pbs(23),'String',mess,'ForegroundColor',xcol,'Visible','on')
 mess=['Si pu',oA,' ripetere la scelta col pulsante 1 del mouse. ',...
 'Il pulsante 2 la conferma.'];
 set(pbs(24),'String',mess,'ForegroundColor',xcol,'Visible','on')
 bb=1; hh=0; hold on
 while bb==1
  [x1s,y1s,bb]=ginput(1);
  if isempty(bb), bb=2; end
  if (x1s<VV(1))&(bb==1)
   if hh~=0
    eval('delete(ha)','err=1;')
   end
   set(pbs(25),'Enable','on')
   set(pbs(26),'Enable','on')
   set(pbs(22),'Visible','off')
   if flgdph==0
    for kk=2:11, set(pbs(kk),'Enable','on'), end
   end
   if isempty(zcomp), set(pbs(3),'Enable','off'), end
   if isempty(pcomp), set(pbs(5),'Enable','off'), end
   if flgdph==0 mess=mess1; ccol=vcol2(9,:);
   else, mess=mess3; ccol=vcol2(flcomp,:); end
   set(pbs(23),'String',mess,'ForegroundColor',ccol)
   if flgdph==0 mess=mess2; ccol=vcol2(9,:);
   else, mess=mess4; ccol=vcol2(flcomp,:); end
   set(pbs(24),'String',mess,'ForegroundColor',ccol)
   set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
   set(pbs(81),'Visible','on'), set(pbs(20),'Visible','off')
   return
  end
  if isempty(bb), bb=2; end
  if hh==0, bb=1; end
  if bb==1
   x1=x1s; y1=y1s;
   if hh~=0
    for kk=1:length(ha)
     delete(ha(kk))
    end
   end
   set(pbs(81),'Visible','off')
   set(pbs(20),'String',mx2,'ForegroundColor',vcol2(9,:),'Visible','on')
   if y1<=0
    if flgdph==0
     ha=plot(x1,0,'Color',vcol1(flcomp,:),'LineStyle','none',...
     'Marker','x','MarkerSize',10,'LineWidth',2); y1=0;
    else
     ha=plot(x1,0,'Color',vcol1(flcomp,:),'LineStyle','none',...
     'Marker','+','LineWidth',2); y1=0;
    end
    if (abs(x1)<4*10^(-3)*(VV(2)-VV(1))), x1=0; end
    if str=='z'
     if (abs(x1-1)<4*10^(-3)*(VV(2)-VV(1))), x1=1; end
    end
    pcomp1=x1;
    mess=sprintf('p = %.3g',x1);
    set(pbs(16),'ForegroundColor',xcol,'Visible','on','String',mess)
    set(pbs(17),'Visible','off')
   else
    if flgdph==0
     ha=plot([x1,x1],[-y1,y1],'Color',vcol1(flcomp,:),'LineStyle',...
     'none','Marker','x','MarkerSize',10,'LineWidth',2);
    else
     ha=plot([x1,x1],[-y1,y1],'Color',vcol1(flcomp,:),'LineStyle',...
     'none','Marker','+','LineWidth',2);
    end
    pcomp1=[x1+j*y1;x1-j*y1];
    mess=sprintf('p1 = j*%.3g',x1); mess=[mess,sprintf('+j*%.3g',y1)];
    set(pbs(16),'ForegroundColor',xcol,'Visible','on','String',mess)
    mess=sprintf('p2 = j*%.3g',x1); mess=[mess,sprintf('-j*%.3g',y1)];
    set(pbs(17),'ForegroundColor',xcol,'Visible','on','String',mess)
   end
  end
  hh=1;
 end
 if flgdph==0
  pcomp=[pcomp;pcomp1]; HA2=[HA2;ha];
 else
  polcl=[polcl;pcomp1]; HA3=[HA3;ha];
  if length(polcl)>=1, set(pbs(9),'Enable','on'), end
 end
 set(pbs(5),'Enable','on')
 set(pbs(22),'Visible','off')
 if flgdph==0 mess=mess1; ccol=vcol2(9,:);
 else, mess=mess3; ccol=vcol2(flcomp,:); end
 set(pbs(23),'String',mess,'ForegroundColor',ccol)
 if flgdph==0 mess=mess2; ccol=vcol2(9,:);
 else, mess=mess4; ccol=vcol2(flcomp,:); end
 set(pbs(24),'String',mess,'ForegroundColor',ccol)
 set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
 if flgdph==0
  nz=length(zcomp); np=length(pcomp);
  mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
  set(pbs(15),'String',mess)
 else
  np=length(polcl);
  mess=sprintf('npa = %i',np);
  set(pbs(18),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 end
elseif typ==4
 xcol=vcol2(flcomp,:);
 mess=[' Scegliere un polo reale o una coppia di poli complessi ',...
 'da eliminare.'];
 set(pbs(23),'String',mess,'ForegroundColor',xcol,'Visible','on')
 set(pbs(24),'Visible','off')
 set(pbs(22),'Visible','on')
 xtick=get(gca,'Xtick'); ytick=get(gca,'Ytick');
 bb=1; hh=0; hold on
 [x1s,y1s,bb]=ginput(1);
 if isempty(bb), bb=2; end
 if (x1s<VV(1))|(bb~=1)
  set(pbs(25),'Enable','on')
  set(pbs(26),'Enable','on')
  set(pbs(22),'Visible','off')
  if flgdph==0 mess=mess1; ccol=vcol2(9,:);
  else, mess=mess3; ccol=vcol2(flcomp,:); end
  set(pbs(23),'String',mess,'ForegroundColor',ccol)
  if flgdph==0 mess=mess2; ccol=vcol2(9,:);
  else, mess=mess4; ccol=vcol2(flcomp,:); end
  set(pbs(24),'String',mess,'ForegroundColor',ccol)
  set(pbs(81),'Visible','on'), set(pbs(20),'Visible','off')
  return
 end
 x1=x1s; y1=y1s;
 pcomp1=x1+j*y1;
 if flgdph==0
  ii=ones(1,length(pcomp));
  [zzz,iim]=min(abs(pcomp-pcomp1)); ii(iim)=0;
  if imag(pcomp(iim))~=0
   [zzz,iim]=min(abs(pcomp-conj(pcomp(iim)))); ii(iim)=0;
  end
  ii=find(ii); pcomp=pcomp(ii);
  for kk=1:length(HA2), eval('delete(HA2(kk))','err=1;'), end, HA2=[];
  if ~isempty(zcomp)
   ha=plot(real(zcomp),imag(zcomp),'Color',vcol1(flcomp,:),'LineStyle',...
   'none','Marker','o','LineWidth',2); HA2=[HA2;ha];
  end
  if ~isempty(pcomp)
   ha=plot(real(pcomp),imag(pcomp),'Color',vcol1(flcomp,:),'LineStyle',...
   'none','Marker','x','MarkerSize',10,'LineWidth',2); HA2=[HA2;ha];
  end
  if isempty(pcomp), set(pbs(5),'Enable','off'), end
 else
  ii=ones(1,length(polcl));
  [zzz,iim]=min(abs(polcl-pcomp1)); ii(iim)=0;
  if imag(polcl(iim))~=0
   [zzz,iim]=min(abs(polcl-conj(polcl(iim)))); ii(iim)=0;
  end
  ii=find(ii); polcl=polcl(ii);
  for kk=1:length(HA3), eval('delete(HA3(kk))','err=1;'), end, HA3=[];
  if ~isempty(polcl)
   ha=plot(real(polcl),imag(polcl),'Color',vcol1(3,:),'LineStyle','none',...
   'Marker','+','LineWidth',2); HA3=[HA3;ha];
  end
  if isempty(polcl), set(pbs(5),'Enable','off'), end
 end
 set(pbs(22),'Visible','off')
 if flgdph==0 mess=mess1; ccol=vcol2(9,:);
 else, mess=mess4; ccol=vcol2(flcomp,:); end
 set(pbs(23),'String',mess,'ForegroundColor',ccol)
 if flgdph==0 mess=mess2; ccol=vcol2(9,:);
 else, mess=mess4; ccol=vcol2(flcomp,:); end
 set(pbs(24),'String',mess2,'ForegroundColor',ccol,'Visible','on')
 set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
 if flgdph==0
  nz=length(zcomp); np=length(pcomp);
  mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
  set(pbs(15),'String',mess)
 else
  np=length(polcl);
  mess=sprintf('npa = %i',np);
  set(pbs(18),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 end
end
if typ==5 % Regulator reset
 for kk=1:length(HA2), eval('delete(HA2(kk))','err=1;'), end, HA2=[];
 for kk=1:length(HA3), eval('delete(HA3(kk))','err=1;'), end, HA3=[];
 zcomp=[]; pcomp=[]; kcomp=1; polcl=[];
 set(pbs(9),'String','Eq. diofantea','Callback','regroaux(7)')
 for kk=2:11, set(pbs(kk),'Enable','on'), end
 set(pbs(3),'Enable','off'), set(pbs(5),'Enable','off'),
 mess=sprintf('K = %.3g',kdata*kcomp);
 set(pbs(13),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 mess=sprintf('Kc = %.3g',kcomp);
 set(pbs(14),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 nz=length(zcomp); np=length(pcomp);
 mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
 set(pbs(15),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 flgdph=0; polcl=[];
 set(pbs(18),'Visible','off')
 set(pbs(23),'String',mess1,'ForegroundColor',vcol2(9,:))
 set(pbs(24),'String',mess2,'ForegroundColor',vcol2(9,:))
end
if (typ==6)|(typ==9) % Root locus
 set(pbs(31),'Visible','off'), set(pbs(32),'Visible','off')
 if flgdph==0
  mess=['Scegliere un punto sul luogo delle radici per definire il ',...
  'guadagno del regolatore.'];
  set(pbs(23),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
  mess=['Si pu',oA,' ripetere la scelta col pulsante 1 del mouse. ',...
  'Il pulsante 2 la conferma.'];
  set(pbs(24),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 else
  mess=['Controllare il luogo delle radici corrispondente al regolatore',...
  ' determinato.'];
  set(pbs(23),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
  mess=['Quindi selezionare "Annulla" per uscire dalla sessione di',...
  ' allocazione dei poli.'];
  set(pbs(24),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 end
 for kk=2:11
  set(pbs(kk),'Enable','off')
 end
 set(pbs(81),'Visible','off')
 set(pbs(22),'Visible','off')
 if typ==6, strret='regroaux(33)'; elseif typ==9, strret='regroaux(34)'; end
 set(pbs(21),'Style','popup','BackgroundColor',vcol2(8,:),...
 'ForegroundColor',vcol2(flcomp,:),'Visible','on','String',...
 'passo=1|passo=0.5|passo=0.2|passo=0.1|passo=0.05|passo=0.02|passo=0.01',...
 'Callback',strret)
 return
end
%
if arg1==33, typ=6; elseif arg1==34, typ=9; end
%
if (typ==6)|(typ==9) % Root locus
 set(pbs(21),'Visible','off')
 popm=get(pbs(21),'Value');
 if popm==1
  stp=1; mess='passo=1';
 elseif popm==2
  stp=.5; mess='passo=0.5';
 elseif popm==3
  stp=.2; mess='passo=0.2';
 elseif popm==4
  stp=.1; mess='passo=0.1';
 elseif popm==5
  stp=.05; mess='passo=0.05';
 elseif popm==6
  stp=.02; mess='passo=0.02';
 elseif popm==7
  stp=.01; mess='passo=0.01';
 end
 set(pbs(21),'Style','text','Visible','on','BackgroundColor',vcol2(8,:),...
 'String',mess)
 pause(1)
 if typ==9, kcomp=-kcomp; end
 if length([zdata;pdata;zcomp;pcomp])==0, return, end
 cc=repco(flcomp); kp=[];
 set(pbs(21),'Visible','off')
 set(pbs(22),'Visible','on')
 if length(HA)~=0, flg=1; end
 xtick=get(gca,'Xtick'); ytick=get(gca,'Ytick');
 hold on
 set(pbs(22),'Visible','on')
 zl=[zdata;zcomp]; pl=[pdata;pcomp]; kl=kdata*kcomp;
%
%   elimination of common zeros and poles
%
 zd=zl; pd=pl;
 md=length(zd); nd=length(pd);
 iz=ones(md,1); ip=ones(nd,1);
 for kk=1:md
  for kh=1:nd
   if (abs(zd(kk)-pd(kh))<=tol)&(ip(kh)~=0)
    iz(kk)=0; ip(kh)=0; break
   end
  end
 end
 zd=zd(find(iz)); pd=pd(find(ip));
 if str=='s'
  [rmul,kmul]=eval('rootlc(zd,pd,kl,stp,cc,flgd,ndiv,1)');
 else
  [rmul,kmul]=eval('rootld(zd,pd,kl,stp,cc,flgd,ndiv,1)');
 end
 if flgdph==0
  [numc,denc]=dezpk(zl,pl,kl);
  bb1=1; hh1=0;
  while bb1==1
   [x1s,y1s,bb1]=ginput(1);
   if isempty(bb1), bb1=2; end
   if (x1s<VV(1))&(bb1==1)
    hold off
    if typ==9, kcomp=-kcomp; end
    % dummy plot for restoring axes and hold
    plot(VV(1),VV(3),'Color',vcol1(8,:),'LineStyle','none','Marker','.')
    axis(VV), hold on
    if ~isempty(zdata)
     ha=plot(real(zdata),imag(zdata),'Color',vcol1(7,:),'LineStyle','none',...
     'Marker','o','LineWidth',2); HA1=[HA1;ha];
    end
    if ~isempty(pdata)
     ha=plot(real(pdata),imag(pdata),'Color',vcol1(7,:),'LineStyle','none',...
     'Marker','x','MarkerSize',10,'LineWidth',2); HA1=[HA1;ha];
    end
    if ~isempty(zcomp)
     ha=plot(real(zcomp),imag(zcomp),'Color',vcol1(flcomp,:),'LineStyle',...
     'none','Marker','o','LineWidth',2); HA2=[HA2;ha];
    end
    if ~isempty(pcomp)
     ha=plot(real(pcomp),imag(pcomp),'Color',vcol1(flcomp,:),'LineStyle',...
     'none','Marker','x','MarkerSize',10,'LineWidth',2); HA2=[HA2;ha];
    end
    plot([0,0],[-10^8,10^8],'Color',vcol1(7,:),'LineStyle',':')
    plot([-10^8,10^8],[0,0],'Color',vcol1(7,:),'LineStyle',':')
    set(gca,'Xtick',xtick), set(gca,'Ytick',ytick)
    if str=='z'
     ang=2*pi*linspace(0,1,200); circ=cos(ang)+j*sin(ang);
     plot(circ,'Color',vcol1(7,:),'LineStyle',':')
    end
    figure(gcf), hold off
    if flg==1
     if strcmp(str,'s')
      HA=rgrid;
     else
      HA=drgrid;
     end
     if gr==1, grid on, end
    end
    set(pbs(22),'Visible','off')
    for kk=2:8
     set(pbs(kk),'Enable','on')
    end
    if isempty(zcomp), set(pbs(3),'Enable','off'), end
    if isempty(pcomp), set(pbs(5),'Enable','off'), end
    set(pbs(81),'Visible','on'), set(pbs(20),'Visible','off')
    set(pbs(25),'Enable','on')
    set(pbs(26),'Enable','on')
    for kk=2:11, set(pbs(kk),'Enable','on'), end
    if isempty(zcomp), set(pbs(3),'Enable','off'), end
    if isempty(pcomp), set(pbs(5),'Enable','off'), end
    set(pbs(81),'Visible','on'), set(pbs(20),'Visible','off')
    set(pbs(23),'String',mess1,'ForegroundColor',vcol2(9,:))
    set(pbs(24),'String',mess2,'ForegroundColor',vcol2(9,:))
    mess=sprintf('K = %.3g',kdata*kcomp);
    set(pbs(13),'String',mess,'ForegroundColor',vcol2(flcomp,:),...
    'Visible','on')
    mess=sprintf('Kc = %.3g',kcomp);
    set(pbs(14),'ForegroundColor',vcol2(flcomp,:),...
    'Visible','on','String',mess)
    set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
    set(pbs(18),'Visible','off'), set(pbs(19),'Visible','off')
    set(pbs(81),'Visible','on'), set(pbs(20),'Visible','off')
    return
   end
   if bb1==1
    x=x1s; y=y1s;
    if hh1~=0
     eval('delete(HH1)','err=1;')
    end
    set(pbs(81),'Visible','off')
    set(pbs(20),'String',mx2,'ForegroundColor',vcol2(9,:),'Visible','on')
    mess=sprintf('x: %.3g',x); mess=[mess,sprintf(', y: %.3g',y)];
    set(pbs(16),'ForegroundColor',vcol2(flcomp,:),...
    'Visible','on','String',mess)
    av=x+j*y; kp=-polyval(denc,av)/polyval(numc,av); kp=real(kp);
    if ~isempty(kp), kkv=kp*kcomp; else, kkv=kcomp; end
    mess=sprintf('K = %.3g',kdata*kkv);
    set(pbs(13),'String',mess,'ForegroundColor',vcol2(flcomp,:),...
    'Visible','on')
    mess=sprintf('Kc = %.3g',kkv);
    set(pbs(14),'ForegroundColor',vcol2(flcomp,:),...
    'Visible','on','String',mess)
    pp=roots(sumpol(denc,kp*numc)); ppv=pp;
    [ww,ii]=min(abs(av-pp)); pp0=pp(ii); x=real(pp0); y=imag(pp0);
    xt=real(pp); yt=imag(pp);
    VV=axis; hold on
    HH1=plot(xt,yt,'Color',vcol1(flcomp,:),'LineStyle','none',...
    'Marker','o','LineWidth',2,'MarkerSize',5);
    if str=='z'
     zz=x+j*y;
     ss1=(1/TSAMP)*log(zz); x=real(ss1); y=imag(ss1);
    end
    onn=sqrt(x^2+y^2); ddp=-x/onn;
    mess=sprintf('omega_n: %.3g rad/sec',onn);
    set(pbs(17),'ForegroundColor',vcol2(flcomp,:),...
    'Visible','on','String',mess)
    mess=sprintf('delta: %.4g',ddp);
    set(pbs(18),'ForegroundColor',vcol2(flcomp,:),...
    'Visible','on','String',mess)
    if str=='z', ppv=(1/TSAMP)*log(ppv); end
    settime=-3/max(real(ppv));
    if settime<0, settime=NaN; end
    if str=='z', settime=TSAMP*ceil(settime/TSAMP); end
    mess=sprintf('tempo ass.: %.4g sec',settime);
    set(pbs(19),'ForegroundColor',vcol2(flcomp,:),...
    'Visible','on','String',mess)
   end % if bb1==1
   hh1=1;
  end % while bb1
  if ~isempty(kp), kcomp=kp*kcomp; end
  hold off
 else
  xy=waitforbuttonpress; flgdph=0;
 end % if flgdph
% dummy plot for restoring axes and hold
 plot(VV(1),VV(3),'Color',vcol1(8,:),'LineStyle','none','Marker','.')
 axis(VV), hold on
 if ~isempty(zdata)
  ha=plot(real(zdata),imag(zdata),'Color',vcol1(7,:),'LineStyle','none',...
  'Marker','o','LineWidth',2); HA1=[HA1;ha];
 end
 if ~isempty(pdata)
  ha=plot(real(pdata),imag(pdata),'Color',vcol1(7,:),'LineStyle','none',...
  'Marker','x','MarkerSize',10,'LineWidth',2); HA1=[HA1;ha];
 end
 if ~isempty(zcomp)
  ha=plot(real(zcomp),imag(zcomp),'Color',vcol1(flcomp,:),'LineStyle',...
  'none','Marker','o','LineWidth',2); HA2=[HA2;ha];
 end
 if ~isempty(pcomp)
  ha=plot(real(pcomp),imag(pcomp),'Color',vcol1(flcomp,:),'LineStyle',...
  'none','Marker','x','MarkerSize',10,'LineWidth',2); HA2=[HA2;ha];
 end
 plot([0,0],[-10^8,10^8],'Color',vcol1(7,:),'LineStyle',':')
 plot([-10^8,10^8],[0,0],'Color',vcol1(7,:),'LineStyle',':')
 set(gca,'Xtick',xtick), set(gca,'Ytick',ytick)
 if str=='z'
  ang=2*pi*linspace(0,1,200); circ=cos(ang)+j*sin(ang);
  plot(circ,'Color',vcol1(7,:),'LineStyle',':')
 end
 figure(gcf), hold off
 if flg==1
  if strcmp(str,'s')
   HA=rgrid;
  else
   HA=drgrid;
  end
 end
 if gr==1, grid on, end
 set(pbs(22),'Visible','off')
 for kk=2:11, set(pbs(kk),'Enable','on'), end
 if isempty(zcomp), set(pbs(3),'Enable','off'), end
 if isempty(pcomp), set(pbs(5),'Enable','off'), end
 set(pbs(81),'Visible','on'), set(pbs(20),'Visible','off')
 set(pbs(23),'String',mess1,'ForegroundColor',vcol2(9,:))
 set(pbs(24),'String',mess2,'ForegroundColor',vcol2(9,:))
 mess=sprintf('K = %.3g',kdata*kcomp);
 set(pbs(13),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 mess=sprintf('Kc = %.3g',kcomp);
 set(pbs(14),'ForegroundColor',vcol2(flcomp,:),'Visible','on','String',mess)
 set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
 set(pbs(18),'Visible','off'), set(pbs(19),'Visible','off')
 legen=pbs(58); islegen=pbs(59);
 if islegen
  VV=axis; xx=2*VV(1)-VV(2); yy=2*VV(3)-VV(4);
  hold on, HAL=plot(xx,yy,xx,yy);
  set(HAL(1),'Color',vcol1(7,:)), set(HAL(2),'Color',vcol1(flcomp,:))
  hold off
  if legen==1, eval(['legend(HAL,',LABLEG,',3)']); end
 end
end
if ((typ>=1)&(typ<=4))|(typ==5)|(typ==6)|(typ==9)
 nz=length(zcomp); np=length(pcomp);
 [numc,denc]=dezpk(zcomp,pcomp,kcomp);
 eval(['stkn',int2str(flcomp),'=numc;'])
 eval(['stkd',int2str(flcomp),'=denc;'])
 messx1=[int2str(nz),' zero(i), ',int2str(np),' polo(i)'];
 eval(['messd',int2str(flcomp),'=messx1;'])
 if str=='s'
  aa=importf(zcomp,pcomp,kcomp,gj);
 else
  aa=importf(zcomp,pcomp,kcomp,gj,1);
 end
 TRF2=[gj,repco(flcomp)];
 set(pbs(25),'Enable','on')
 set(pbs(26),'Enable','on')
 set(pbs(81),'Visible','on'), set(pbs(20),'Visible','off')
end
if (typ==2)|(typ==4)
 axis(VV); set(gca,'Xtick',xtick), set(gca,'Ytick',ytick)
 figure(gcf)
end
if (typ==7)|(typ==8) % Diophantine eq. & Compute
%
%   selection of common factors
%
 z5=[]; p5=[];
 z1=zdata; p1=pdata; k1=kdata; z2=zcomp; p2=pcomp; k2=kcomp;
 [num1,den1]=dezpk(z1,p1,k1);
 [num2,den2]=dezpk(z2,p2,k2);
 md=length(z2); nd=length(p1);
 iz=ones(md,1); ip=ones(nd,1);
 for kk=1:md
  for kh=1:nd
   if (abs(z2(kk)-p1(kh))<=tol)&(ip(kh)~=0)
    iz(kk)=0; ip(kh)=0; z5=[z5;z2(kk)]; break
   end
  end
 end
 z2=z2(find(iz)); p1=p1(find(ip));
 md=length(p2); nd=length(z1);
 iz=ones(md,1); ip=ones(nd,1);
 for kk=1:md
  for kh=1:nd
   if (abs(p2(kk)-z1(kh))<=tol)&(ip(kh)~=0)
    iz(kk)=0; ip(kh)=0; p5=[p5;p2(kk)]; break
   end
  end
 end
 p2=p2(find(iz)); z1=z1(find(ip));
end
if typ==7 % Diophantine eq.
 flgdph=1;
 set(pbs(23),'String',mess3,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 set(pbs(24),'Visible','off')
 np=length(polcl);
 mess=sprintf('npa = %i',np);
 set(pbs(18),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 for kk=2:11, if kk~=4, set(pbs(kk),'Enable','off'), end, end
 set(pbs(9),'String','Calcolo','Callback','regroaux(8)','Enable','off')
 set(pbs(81),'Visible','off')
 set(pbs(6),'Enable','on')
 %
 np=length(p1); nz2=length(z2); np2=length(p2); np3=length(polcl);
 nz5=length(z5); np5=length(p5); minpol=2*np+nz2+np2-1+nz5-np5;
 mess4=['Il minimo numero di poli da assegnare ',eA];
 mess4=[mess4,sprintf(' %i',minpol)];
 mess4=[mess4,' (per ottenere la causalit',aA,').'];
 set(pbs(24),'String',mess4,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
end
if typ==8 % Compute
 if (length(z5)>0)|(length(p5)>0)
  [num1,den1]=dezpk(z1,p1,k1);
  [num2,den2]=dezpk(z2,p2,k2);
 end
 den3=poly(polcl);
%
%   Solution of the Diophantine equation
%
 aa=conv(den1,den2); bb=conv(num1,num2); cc=den3;
 [xx,yy]=diopha(aa,bb,cc);
 if ~any(xx)
  set(pbs(82),'String','SOLUZIONE IMPOSSIBILE: AGGIUNGERE ALTRI POLI',...
  'Visible','on','ForegroundColor',vcol2(2,:))
  xy=waitforbuttonpress;
  set(pbs(82),'Visible','off')
  return
 end
 [tp1,tp2,tp3,repcos]=coltbl;
 mess=['Gli zeri e i poli del regolatore determinato sono mostrati in ',...
 deblank(repcos(flcomp,:)),'.'];
 set(pbs(23),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 mess=['Si pu',oA,' esaminare il luogo delle radici: ci',oA,...
 ' completa il progetto.'];
 set(pbs(24),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 set(pbs(4),'Enable','off'), set(pbs(5),'Enable','off')
 set(pbs(7),'Enable','on')
 set(pbs(9),'String','Eq. diofantea','Callback','regroaux(7)',...
 'Enable','off')
 xtick=get(gca,'Xtick'); ytick=get(gca,'Ytick');
 num4=conv(yy,num2); den4=conv(xx,den2); % the complete regulator
 [z4,p4,k4]=tozpk(num4,den4);
%
% recovering the selected common factors
%
 zcomp=[z4;z5]; pcomp=[p4;p5]; kcomp=k4;
 nz=length(zcomp); np=length(pcomp);
 [numc,denc]=dezpk(zcomp,pcomp,kcomp);
 eval(['stkn',int2str(flcomp),'=numc;'])
 eval(['stkd',int2str(flcomp),'=denc;'])
 messx1=[int2str(nz),' zero(i), ',int2str(np),' polo(i)'];
 eval(['messd',int2str(flcomp),'=messx1;'])
 if str=='s'
  aa=importf(zcomp,pcomp,kcomp,gj);
 else
  aa=importf(zcomp,pcomp,kcomp,gj,1);
 end
 TRF2=[gj,repco(flcomp)];
 for kk=1:length(HA2), eval('delete(HA2(kk))','err=1;'), end, HA2=[];
 polcl=[];
 if ~isempty(zcomp)
  ha=plot(real(zcomp),imag(zcomp),'Color',vcol1(flcomp,:),'LineStyle',...
  'none','Marker','o','LineWidth',2); HA2=[HA2;ha];
 end
 if ~isempty(pcomp)
  ha=plot(real(pcomp),imag(pcomp),'Color',vcol1(flcomp,:),'LineStyle',...
  'none','Marker','x','MarkerSize',10,'LineWidth',2); HA2=[HA2;ha];
 end
 axis(VV); set(gca,'Xtick',xtick), set(gca,'Ytick',ytick)
 figure(gcf)
 if isempty(zcomp), set(pbs(3),'Enable','off'), end
 set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
 mess=sprintf('K = %.3g',kdata*kcomp);
 set(pbs(13),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 mess=sprintf('Kc = %.3g',kcomp);
 set(pbs(14),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 nz=length(zcomp); np=length(pcomp);
 mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
 set(pbs(15),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
end
if typ==10 % Another regulator
 polcl=[];
 for kk=1:length(HA2), eval('delete(HA2(kk))','err=1;'), end, HA2=[];
 for kk=1:length(HA3), eval('delete(HA3(kk))','err=1;'), end, HA3=[];
 zcomp=[]; pcomp=[]; kcomp=1;
 set(pbs(3),'Enable','off')
 set(pbs(5),'Enable','off')
 if flcomp<6, flcomp=flcomp+1; end, pbs(27)=flcomp;
 legen=pbs(58); islegen=pbs(59);
 if islegen
  VV=axis; xx=2*VV(1)-VV(2); yy=2*VV(3)-VV(4);
  hold on, HAL=plot(xx,yy,xx,yy);
  set(HAL(1),'Color',vcol1(7,:)), set(HAL(2),'Color',vcol1(flcomp,:))
  hold off
  if legen==1, eval(['legend(HAL,',LABLEG,',3)']); end
 end
 set(pbs(12),'ForegroundColor',vcol2(flcomp,:),...
 'String',['Regolatore N. ',int2str(flcomp)])
 mess=sprintf('K = %.3g',kdata*kcomp);
 set(pbs(13),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 mess=sprintf('Kc = %.3g',kcomp);
 set(pbs(14),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
 nz=length(zcomp); np=length(pcomp);
 mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
 set(pbs(15),'String',mess,'ForegroundColor',vcol2(flcomp,:),'Visible','on')
end
if (typ>=11)&(typ<=24)
 if length(HA)~=0
  for kk=1:length(HA), eval('delete(HA(kk))','err=1;'), end
  HA=[]; flg=1;
 end
end
if typ==11
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(1)=VV(1)-dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==12
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(1)=VV(1)+dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==13
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(2)=VV(2)+dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==14
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(2)=VV(2)-dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==15
 ytick=get(gca,'Ytick');
 if length(ytick)>3
  dd=ytick(2)-ytick(1); VV(4)=VV(4)+dd; VV(3)=-VV(4);
  ytick=VV(3):dd:VV(4); set(gca,'Ytick',ytick), axis(VV)
 end
elseif typ==16
 ytick=get(gca,'Ytick');
 if length(ytick)>3
  dd=ytick(2)-ytick(1); VV(4)=VV(4)-dd; VV(3)=-VV(4);
  ytick=VV(3):dd:VV(4); set(gca,'Ytick',ytick), axis(VV)
 end
elseif typ==17
 if VV(1)<0
  VVV=VV(1)*2;
 else
  VVV=VV(1)-(VV(2)-VV(1))/2;
 end
 if VVV<VV(2), VV(1)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==18
 VVV=VV(1)/2;
 if VVV<VV(2), VV(1)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==19
 if VV(2)>0
  VVV=VV(2)*2;
 else
  VVV=VV(2)+(VV(2)-VV(1))/2;
 end
 if VVV>VV(1), VV(2)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==20
 VVV=VV(2)/2;
 if VVV>VV(1), VV(2)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==21
 VV(4)=VV(4)*2; VV(3)=-VV(4); set(gca,'YTickMode','auto'), axis(VV)
elseif typ==22
 VV(4)=VV(4)/2; VV(3)=-VV(4); set(gca,'YTickMode','auto'), axis(VV)
elseif typ==23
 VV=VV/2; set(gca,'XTickMode','auto'), set(gca,'YTickMode','auto'), axis(VV)
elseif typ==24
 VV=VV*2; set(gca,'XTickMode','auto'), set(gca,'YTickMode','auto'), axis(VV)
elseif typ==25
 TT1=TT; TT1(2)=TT1(2)/2+.001*(TT1(2)/2-TT1(1)); flaxis=1;
elseif typ==26
 TT1=TT; TT1(2)=TT1(2)/5+.001*(TT1(2)/5-TT1(1)); flaxis=1;
elseif typ==27
 TT1=TT; TT1(2)=TT1(2)/10+.001*(TT1(2)/10-TT1(1)); flaxis=1;
elseif typ==28
 TT1=TT; TT1(2)=TT1(2)/20+.001*(TT1(2)/20-TT1(1)); flaxis=1;
elseif typ==29
 TT1=TT; flaxis=1;
end
if (typ>=11)&(typ<=24)
 if flg==1
  if strcmp(str,'s')
   HA=rgrid;
  else
   HA=drgrid;
  end
 end
end
if typ==31
 for kk=2:11, set(pbs(kk),'Enable','off'), end
 set(pbs(81),'Visible','off')
 set(pbs(29),'Style','push','String','Uscita sistema','Visible','on',...
 'Callback','regroaux(35)')
 set(pbs(30),'Style','push','String','Uscita regolatore','Visible','on',...
 'Callback','regroaux(36)')
elseif typ==32
 for kk=2:11, set(pbs(kk),'Enable','off'), end
 set(pbs(81),'Visible','off')
 set(pbs(29),'Style','push','String','Anello aperto','Visible','on',...
 'Callback','regroaux(37)')
 set(pbs(30),'Style','push','String','Anello chiuso','Visible','on',...
 'Callback','regroaux(38)')
 set(pbs(83),'Style','push','String',['Funz. di sensibilit',aA],...
 'Visible','on','Callback','regroaux(42)')
end
if (typ==35)|(typ==36)|((typ>=25)&(typ<=29))
 if typ==35, is1=0; elseif typ==36, is1=1; end
 if (typ==35)|(typ==36), pbs(84)=is1; else, is1=pbs(84); end
 if (typ>=25)&(typ<=29), flaxis=1; end
 nfig1=nfig+1; cc=get(0,'Children');
 if ~any(cc==nfig1)
  disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), ordf, return
 end
 figure(nfig1), zoom off, cla, set(gca,'Box','on')
 if pbs(95)==0
  set(pbs(51),'Enable','on')
  for kk=92:94, set(pbs(kk),'Enable','on'), pbs(95)=1; end
 end
 set(pbs(47),'Visible','on'), set(pbs(48),'Visible','on')
 for kk=1:flcomp
  rr=pbs(60+kk); eval('delete(rr)','err=1;')
  eval(['messx1=messd',int2str(kk),';'])
  mess=[gj,', colore ',repco(kk),', ',messx1];
  if str=='s'
   pbs(60+kk)=uimenu(pbs(51),'Label',mess,...
   'Callback',['ccregaux(6,',int2str(kk),',.1)']);
  else
   pbs(60+kk)=uimenu(pbs(51),'Label',mess,...
   'Callback',['ccregaux(6,',int2str(kk),',.1,1)']);
  end
 end
 drawnow, reset(gca), NPKK=0;
 [num,den]=dezpk(zdata,pdata,kdata);
 if flcomp==1
  [numc,denc]=dezpk(zcomp,pcomp,kcomp);
  if is1==0
   num0=conv(num,numc);
  else
   num0=conv(numc,den);
  end
  den0=sumpol(conv(num,numc),conv(den,denc));
  [z0,p0,k0]=tozpk(num0,den0);
  if str=='s'
   if flaxis==0
    [y,t]=trespc(z0,[p0;0],k0,repco(flcomp)); TT=axis;
   else
    [y,t]=trespc(z0,[p0;0],k0,TT1(2),repco(flcomp));
   end
  else
   if flaxis==0
    [y,t]=trespd([z0;0],[p0;1],k0,repco(flcomp)); TT=axis;
    TT(2)=TT(2)*TSAMP; axis(TT)
    [y,t]=trespd([z0;0],[p0;1],k0,TSAMP,TT(2),repco(flcomp)); TT=axis;
   else
    [y,t]=trespd([z0;0],[p0;1],k0,TSAMP,TT1(2),repco(flcomp));
   end
  end
  if is1==0
   title('risposta al gradino ad anello chiuso')
  else
   title('uscita del regolatore')
  end
 else % flcomp~=1
  if flaxis==0
   TTM=0; YYm=0; YYM=0;
   for kk=1:flcomp
    eval(['numc=stkn',int2str(kk),';'])
    eval(['denc=stkd',int2str(kk),';'])
    if is1==0
     num0=conv(num,numc);
    else
     num0=conv(numc,den);
    end
    den0=sumpol(conv(num,numc),conv(den,denc));
    [z0,p0,k0]=tozpk(num0,den0);
    if str=='s'
     [y,t]=trespc(z0,[p0;0],k0,repco(kk)); TT=axis; reset(gca)
     TTM=max([TTM,TT(2)]);
    else
     [y,t]=trespd([z0;0],[p0;1],k0,repco(kk)); TT=axis; reset(gca)
     TTM=max([TTM,TT(2)*TSAMP]);
    end
    YYm=min([YYm,TT(3)]); YYM=max([YYM,TT(4)]);
   end
   TT=[0,TTM,YYm,YYM]; axis(TT), TT2=TT;
  else
   TT2=TT1;
  end
  for kk=1:flcomp
   eval(['numc=stkn',int2str(kk),';'])
   eval(['denc=stkd',int2str(kk),';'])
   if is1==0
    num0=conv(num,numc);
   else
    num0=conv(numc,den);
   end
   den0=sumpol(conv(num,numc),conv(den,denc));
   [z0,p0,k0]=tozpk(num0,den0);
   if kk==1, axis(TT2), end
   if str=='s'
    [y,t]=trespc(z0,[p0;0],k0,repco(kk));
   else
    [y,t]=trespd([z0;0],[p0;1],k0,TSAMP,TT2(2),repco(kk));
   end
   if kk==1
    if is1==0
     title('risposta al gradino ad anello chiuso')
    else
     title('uscita del regolatore')
    end
    axis(TT2)
   end
   hold on
  end
  hold off
 end
 if pbs(85)==1, grid on, end
 for kk=2:11, set(pbs(kk),'Enable','on'), end
 set(pbs(81),'Visible','on'), set(pbs(20),'Visible','off')
 set(pbs(29),'Visible','off'), set(pbs(30),'Visible','off')
 set(pbs(47),'Visible','off'), set(pbs(83),'Visible','off')
end
if (typ==37)|(typ==38)|(typ==42)|((typ>=45)&(typ<=48))
 if typ==37, if1=0; elseif typ==38, if1=1; elseif typ==42, if1=2; end
 if (typ==37)|(typ==38)|(typ==42), pbs(84)=if1; else, if1=pbs(84); end
 if (typ>=45)&(typ<=48), flaxis=1; end
 nfig2=nfig+2; cc=get(0,'Children');
 if ~any(cc==nfig2)
  disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), ordf, return
 end
 figure(nfig2)
 if pbs(100)==0
  set(pbs(52),'Enable','on')
  for kk=97:99, set(pbs(kk),'Enable','on'), pbs(100)=1; end
 end
 set(pbs(49),'Visible','on'), set(pbs(50),'Visible','on')
 subplot(2,1,1), GG=axis; zoom off, cla, set(gca,'Box','on')
 subplot(2,1,2), PP=axis; zoom off, cla, set(gca,'Box','on')
 for kk=1:flcomp
  rr=pbs(70+kk); eval('delete(rr)','err=1;')
  eval(['messx1=messd',int2str(kk),';'])
  mess=[gj,', colore ',repco(kk),', ',messx1];
  if str=='s'
   pbs(70+kk)=uimenu(pbs(52),'Label',mess,...
   'Callback',['ccregaux(8,',int2str(kk),',.1)']);
  else
   pbs(70+kk)=uimenu(pbs(52),'Label',mess,...
   'Callback',['ccregaux(8,',int2str(kk),',.1,1)']);
  end
 end
 drawnow, subplot(2,1,1), reset(gca), subplot(2,1,2), reset(gca)
 [num,den]=dezpk(zdata,pdata,kdata);
 if flaxis==1
  rrr=(1.001); if typ==45, GG(1)=10^(round(log10(GG(1)/10)))/rrr;
  elseif typ==46, GG(1)=10^(round(log10(GG(1)*10)))/rrr;
  elseif typ==47, GG(2)=10^(round(log10(GG(2)*10)))*rrr;
  elseif typ==48, GG(2)=10^(round(log10(GG(2)/10)))*rrr; end
  PP(1)=GG(1); PP(2)=GG(2); OMm=GG(1); OMM=GG(2);
 end
 if flcomp==1
  [numc,denc]=dezpk(zcomp,pcomp,kcomp);
  if if1~=2, num0=conv(num,numc); else, num0=conv(den,denc); end
  if if1==0
   den0=conv(den,denc);
  else
   den0=sumpol(conv(num,numc),conv(den,denc));
  end
  [z0,p0,k0]=tozpk(num0,den0);
  if flaxis==0
   if str=='s'
    [mag,phi,om]=frespc(z0,p0,k0,3,repco(flcomp));
   else
    ii=find(abs(z0-1)<10^(-8)); z0(ii)=ones(1,length(ii))';
    ii=find(abs(p0-1)<10^(-8)); p0(ii)=ones(1,length(ii))';
    [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3,repco(flcomp));
   end
  else
   if str=='s'
    [mag,phi,om]=frespc(z0,p0,k0,3,OMm,OMM,repco(flcomp));
   else
    ii=find(abs(z0-1)<10^(-8)); z0(ii)=ones(1,length(ii))';
    ii=find(abs(p0-1)<10^(-8)); p0(ii)=ones(1,length(ii))';
    [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3,OMm,repco(flcomp));
   end
  end
  subplot(2,1,1), GG=axis; GG(1)=om(1); GG(2)=om(length(om)); axis(GG)
  subplot(2,1,2), PP=axis; PP(1)=om(1); PP(2)=om(length(om)); axis(PP)
 else % flcomp~=1
  GGm=10^8; GGM=-10^8; PPm=10^8; PPM=-10^8;
  if flaxis==0, OMm=10^30; OMM=0; end
  for kk=1:flcomp
   eval(['numc=stkn',int2str(kk),';'])
   eval(['denc=stkd',int2str(kk),';'])
   if if1~=2, num0=conv(num,numc); else, num0=conv(den,denc); end
   if if1==0
    den0=conv(den,denc);
   else
    den0=sumpol(conv(num,numc),conv(den,denc));
   end
   [z0,p0,k0]=tozpk(num0,den0);
   if str=='s'
    if flaxis==0
     [mag,phi,om]=frespc(z0,p0,k0,3,repco(flcomp));
    else
     [mag,phi,om]=frespc(z0,p0,k0,3,OMm,OMM,repco(flcomp));
    end
   else
    ii=find(abs(z0-1)<10^(-8)); z0(ii)=ones(1,length(ii))';
    ii=find(abs(p0-1)<10^(-8)); p0(ii)=ones(1,length(ii))';
    if flaxis==0
     [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3,repco(flcomp));
    else
     [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3,OMm,repco(flcomp));
    end
   end
   subplot(2,1,1), GG=axis; subplot(2,1,2), PP=axis;
   GGm=min([GGm,GG(3)]); GGM=max([GGM,GG(4)]);
   PPm=min([PPm,PP(3)]); PPM=max([PPM,PP(4)]);
   if flaxis==0, OMm=min([OMm,GG(1)]); OMM=max([OMM,GG(2)]); end
   subplot(2,1,1), reset(gca), subplot(2,1,2), reset(gca)
  end % for kk
  GG=[OMm,OMM,GGm,GGM]; PP=[OMm,OMM,PPm,PPM];
  for hh=1:2
   for kk=1:flcomp
    eval(['numc=stkn',int2str(kk),';'])
    eval(['denc=stkd',int2str(kk),';'])
    if if1~=2, num0=conv(num,numc); else, num0=conv(den,denc); end
    if if1==0
     den0=conv(den,denc);
    else
     den0=sumpol(conv(num,numc),conv(den,denc));
    end
    [z0,p0,k0]=tozpk(num0,den0);
    if str=='s'
     [mag,phi,om]=frespc(z0,p0,k0,3.5,OMm,OMM,repco(1));
    else
     ii=find(abs(z0-1)<10^(-8)); z0(ii)=ones(1,length(ii))';
     ii=find(abs(p0-1)<10^(-8)); p0(ii)=ones(1,length(ii))';
     [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3.5,OMm,repco(1));
    end
    ssn=[0 0]; ss2=[-180 -180];
    aat=setstr(32*ones(1,120)); aam=sprintf('rad/sec');
    mess=[aat(1:120-length(aam)),aam];
    if hh==1
     if kk==1, subplot(2,1,1), end
     mag1=20*log10(mag);
     semilogx(om,mag1,'Color',vcol1(kk,:),'LineStyle','-')
     if kk==1, axis(GG), hold on, end
     if kk==flcomp
      rr=[GG(1),GG(2)];
      semilogx(rr,ssn,'Color',vcol1(7,:),'LineStyle','--'), title('ampiezza')
      xlabel(mess)
      aat=setstr(32*ones(1,40)); aam=sprintf('db');
      mess1=[aat(1:40-length(aam)),aam]; ylabel(mess1), hold off
     end
    else
     if kk==1, subplot(2,1,2), end
     semilogx(om,phi,'Color',vcol1(kk,:),'LineStyle','-')
     if kk==1, axis(PP), hold on, end
     if kk==flcomp
      rr=[PP(1),PP(2)];
      semilogx(rr,ss2,'Color',vcol1(7,:),'LineStyle','--'), title('fase')
      xlabel(mess)
      aat=setstr(32*ones(1,40)); aam=sprintf('gradi');
      mess1=[aat(1:40-length(aam)),aam]; ylabel(mess1), hold off
     end
    end
   end % for kk
  end  % for hh
 end   % if flcomp==1
 if pbs(86)==1, subplot(2,1,1), grid on, subplot(2,1,2), grid on, end
 for kk=2:11, set(pbs(kk),'Enable','on'), end
 set(pbs(81),'Visible','on'), set(pbs(20),'Visible','off')
 set(pbs(29),'Visible','off'), set(pbs(30),'Visible','off')
 set(pbs(49),'Visible','off'), set(pbs(83),'Visible','off')
end
%
if typ==39 % Exit
% set(pbs(48),'Visible','off'), set(pbs(50),'Visible','off')
 set(pbs(81),'Visible','on')
 figure(nfig)
elseif typ==40 % End
 for kk=2:11, set(pbs(kk),'Enable','off'), end
 set(pbs(81),'Visible','off')
 set(pbs(20),'String',mx1,'ForegroundColor',vcol2(9,:),'Visible','on')
elseif typ==41
 for kk=2:11, set(pbs(kk),'Enable','off'), end
 set(pbs(81),'Visible','off')
 set(pbs(31),'Visible','on','Callback','regroaux(6)')
 if flgdph==0
  set(pbs(32),'Visible','on','Callback','regroaux(9)')
 end
end
% --- last line of regroaux ---
