function regnich(arg1,arg2,arg3,arg4)
%REGNICH  Progetto di reti correttrici con il diagramma di Nichols (TFI).
%    REGNICH,gp,gc - da TFI
%    REGNICH('gp','gc') - da Matlab
%    gp: funzione di trasferimento del sistema controllato (ingresso)
%    gc: funzione di trasferimento del regolatore (uscita)
%    Se REGNICH viene chiamato senza alcun argomento, le f.d.t. gp e gc
%    possono essere specificate in interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global pbs gr MAG PHI OM VV repco gi gj NPKK datacar datacar1...
 prfx prfy ABIL TRF1 TRF2 zpl ppl kpl zcomp pcomp kcomp TT stkn1 stkd1...
 stkn2 stkd2 stkn3 stkd3 stkn4 stkd4 stkn5 stkd5 stkn6 stkd6 stktype...
 had hha1 vcol1 vcol2 ax str car car1 HALEG FIGLEG LABLEG SUBPLEG

aA=setstr(224); eA=setstr(232); uA=setstr(249); EA=setstr(200);
nfig=gcf; nfigs=int2str(nfig); ABIL=1; izz=0; car=0; car1=[]; xxtt=0; gr=0;
zcomp=[]; pcomp=[]; kcomp=1; stkn1=1; stkd1=1; stkn2=1; stkd2=1;
stkn3=1; stkd3=1; stkn4=1; stkd4=1; stkn5=1; stkd5=1; stkn6=1; stkd6=1;
FIGLEG=nfig; HALEG=[]; LABLEG=[]; SUBPLEG=0;
NPKK=0; pbs=zeros(1,100); had=[]; FIGLO=resfiglo;
datacar=0; datacar1=[]; stktype=zeros(6,60); TSAMP=lsamp;
if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
pbs(54)=xxtt; pbs(55)=TSAMP; pbs(58)=legen; pbs(59)=islegen;
if nargin==0
 arg1='xx'; flg=0;
 while flg==0
 mess='\n   funzione di trasferimento del sistema controllato (ingresso) : ';
  gi=input(mess,'s');
  if isempty(gi), gi='0'; end, if gi=='0', return, end
  if ~isempty(gi)
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1;
   end
  end
 end
 while flg==1
  mess='\n   funzione di trasferimento del regolatore (uscita) : ';
  gj=input(mess,'s');
  if isempty(gj), gj='0'; end, if gj=='0', return, end
  if ~isempty(gj), flg=2; end
 end
elseif nargin>=2
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1; gj=arg2;
 end
else
 disp(' **** errore: numero di argomenti non sufficiente'), return
end
[zdata,pdata,kdata,str]=exportf(gi,1); if isempty(kdata), return, end
zdatap=zdata; pdatap=pdata; kdatap=kdata; % true input data
if str=='z'
 disp(' ')
 disp(['   Il sistema ',eA,' a tempo discreto: si user',aA,' il piano w'])
 zdatad=zdata; pdatad=pdata; kdatad=kdata;
 [zdata,pdata,kdata]=diwplane(zdata,pdata,kdata,TSAMP);
end
zpl=zdata; ppl=pdata; kpl=kdata;
figure(nfig)
tfblocks(3,gj,gi,'','','','','','','','')
%
flgll=0;
ll=input('\n   informazioni sul metodo di progetto ? (1) : ');
if isempty(ll), ll=0; end
if ll==1
 ccc='prninfo(2)';
 eval(ccc)
 flgin=0;
 while flgin==0
  mess='\n   inviare 1 per proseguire con il progetto, 0 per uscire : ';
  xxx=input(mess);
  figure(nfig)
  if isempty(xxx), xxx=2; end
  if xxx==1, flgin=1; elseif xxx==0, ordf(1), return, end
 end
end
%
clf, ordf(3), hold off, framesc=get(0,'DefaultFigureColor');
VFULL=get(gcf,'Position'); PO=get(gca,'Position');
SC=diag([1/VFULL(3);1/VFULL(4);1/VFULL(3);1/VFULL(4)]);
set(0,'DefaultUIControlUnits','normalized')
if any(FIGLO(4,:))
 eval('set(nfig,''Position'',FIGLO(4,1:4))','erx=1;') %5.3
end
[vcol1,vcol2,repco,repcos]=coltbl;
colbg=vcol1(8,:); set(gcf,'Color',colbg)
%
nfig1=nfig+1; figure(nfig1), clf, ordf(6) %5.3
if any(FIGLO(4,:))
 eval('set(nfig1,''Position'',FIGLO(4,5:8))','erx=1;')
end
pbs(51)=uimenu(gcf,'Label','Memo');
men1=uimenu(gcf,'Label','Asse tempi'); pbs(92)=men1;
uimenu(men1,'Label','ingrandire x 2',...
'Callback','regniaux(25)');
uimenu(men1,'Label','ingrandire x 5','Separator','on',...
'Callback','regniaux(26)');
uimenu(men1,'Label','ingrandire x 10','Separator','on',...
'Callback','regniaux(27)');
uimenu(men1,'Label','ingrandire x 20','Separator','on',...
'Callback','regniaux(28)');
uimenu(men1,'Label','ripristinare la scala iniziale','Separator','on',...
'Callback','regniaux(29)');
pbs(93)=uimenu(gcf,'Label','Reticolo on/off','Callback','gridmng(13)');
pbs(94)=uimenu(gcf,'Label','Zoom on/off','Callback','gridmng(7)');
set(pbs(51),'Enable','off')
for kk=92:94, set(pbs(kk),'Enable','off'), end
BB=VFULL(4);
Pos=[150 BB-120 200 20]*SC;
pbs(47)=uicontrol(gcf,...
'Style','Text',...
'Position',Pos,...
'BackgroundColor',colbg,...
'ForegroundColor',vcol2(2,:),...
'Visible','off',...
'String','ATTENDERE, PREGO');
Pos=[20 5 50 20]*SC;
pbs(48)=uicontrol(gcf,...
'Style','push',...
'Position',Pos,...
'Visible','off',...
'String','Menu',...
'Callback','regniaux(39)');
%
nfig2=nfig+2; figure(nfig2), clf, ordf(7) %5.3
if any(FIGLO(4,:))
 eval('set(nfig2,''Position'',FIGLO(4,9:12))','erx=1;')
end
pbs(52)=uimenu(gcf,'Label','Memo');
men2=uimenu(gcf,'Label','Asse omega'); pbs(97)=men2;
men2_1=uimenu(men2,'Label','Sinistra');
uimenu(men2_1,'Label',['pi',uA,' una decade'],'Callback','regniaux(45)')
uimenu(men2_1,'Label','meno una decade','Callback','regniaux(46)')
men2_2=uimenu(men2,'Label','Destra','Separator','on');
uimenu(men2_2,'Label',['pi',uA,' una decade'],'Callback','regniaux(47)')
uimenu(men2_2,'Label','meno una decade','Callback','regniaux(48)')
pbs(98)=uimenu(gcf,'Label','Reticolo on/off','Callback','gridmng(14)');
pbs(99)=uimenu(gcf,'Label','Zoom on/off','Callback','gridmng(8)');
set(pbs(52),'Enable','off')
for kk=97:99, set(pbs(kk),'Enable','off'), end
BB=VFULL(4);
Pos=[150 BB-120 200 20]*SC;
pbs(49)=uicontrol(gcf,...
'Style','Text',...
'Position',Pos,...
'BackgroundColor',colbg,...
'ForegroundColor',vcol2(2,:),...
'Visible','off',...
'String','ATTENDERE, PREGO');
Pos=[20 5 50 20]*SC;
pbs(50)=uicontrol(gcf,...
'Style','push',...
'Position',Pos,...
'Visible','off',...
'String','Menu',...
'Callback','regniaux(39)');
figure(nfig1), figure(nfig), set(gca,'Box','on')
%
aa=importf([],[],1,gj);
j=sqrt(-1); pbs(28)=0; pbs(29)=nfig; pbs(1)=0;
zregt=[]; pregt=[]; kregt=1;
%
TRF1=[gi,repco(7)];
men_opt=uimenu(gcf,'Label','Memo');
mess='progetto di regolatore';
uimenu(men_opt,'Label',mess);
mess=[gi,', sistema controllato'];
uimenu(men_opt,'Label',mess,'Separator','on',...
'Callback','tfmaux(1,1,0)');
TRF2=[gj,repco(1)];
mess=[gj,', regolatore'];
men_optt=uimenu(men_opt,'Label',mess);
uimenu(men_optt,'Label','zeri-poli',...
'Callback','tfmaux(2,1,0)');
uimenu(men_optt,'Label','costanti di tempo',...
'Callback','tfmaux(2,1,0,1)');
%
%  TOP MENU
%
pbs(2)=uimenu(gcf,'Label','Cambio assi');
mens1=uimenu(pbs(2),'Label','y alto');
mens2=uimenu(pbs(2),'Label','y basso');
mens3=uimenu(pbs(2),'Label','x sinistra','Separator','on');
mens4=uimenu(pbs(2),'Label','x destra');
pbs(3)=uimenu(gcf,'Label','Reticolo on/off','Callback','gridmng(1)');
%
uimenu(mens3,...
'Label',['pi',uA,' 30 gradi'],...
'Callback','regniaux(11)');
uimenu(mens3,...
'Label','meno 30 gradi',...
'Callback','regniaux(12)');
uimenu(mens4,...
'Label',['pi',uA,' 30 gradi'],...
'Callback','regniaux(13)');
uimenu(mens4,...
'Label','meno 30 gradi',...
'Callback','regniaux(14)');
%
uimenu(mens1,...
'Label',['pi',uA,' 20 db'],...
'Callback','regniaux(15)');
uimenu(mens1,...
'Label','meno 20 db',...
'Callback','regniaux(16)');
uimenu(mens2,...
'Label',['pi',uA,' 20 db'],...
'Callback','regniaux(17)');
uimenu(mens2,...
'Label','meno 20 db',...
'Callback','regniaux(18)');
%
uimenu(pbs(2),...
'Label','standard',...
'Separator','on',...
'Callback','regniaux(19)');
uimenu(pbs(2),...
'Label','luoghi a M e N costanti on/off',...
'Separator','on',...
'Callback','regniaux(20)');
%
BB=VFULL(4)-24;
%
for kk=1:11 % 30->40
 Pos=[4 BB-20*(kk-1) 114 20]*SC;
 pbs(29+kk)=uicontrol(gcf,...
 'Visible','off',...
 'Position',Pos);
end
%
Pos=[200 BB-120 200 20]*SC;
pbs(60)=uicontrol(gcf,...
'Style','Text',...
'Position',Pos,...
'BackgroundColor',colbg,...
'ForegroundColor',vcol2(2,:),...
'Visible','off',...
'String','ATTENDERE, PREGO');
%
set(pbs(39),'Position',[118 BB-140 120 20]*SC)
set(pbs(40),'Position',[118 BB-160 120 20]*SC)
Pos=[118 BB-180 120 20]*SC;
pbs(81)=uicontrol(gcf,'Visible','off','Position',Pos);
%
set(pbs(30),'Style','text','String','Funzioni:','Visible','on')
set(pbs(31),'Style','push','String','Anticipo','CallBack','regniaux(21)')
set(pbs(32),'Style','push','String','Ritardo','CallBack','regniaux(22)')
set(pbs(33),'Style','push','String','Guadagno','CallBack','regniaux(23)')
set(pbs(34),'Style','push','String','Continuare','CallBack','regniaux(1)')
set(pbs(35),'Style','push','String','Altra sezione',...
'CallBack','regniaux(3)')
set(pbs(36),'Style','push','String','Alto regolatore',...
'CallBack','regniaux(4)')
set(pbs(37),'Style','push','String','Risp. gradino',...
'CallBack','regniaux(31)')
set(pbs(38),'Style','push','String','Diagr. di Bode',...
'CallBack','regniaux(32)')
%
wwdth=186;
lskip=round(VFULL(4)*30/480);
for kk=21:25
 Pos=[14 lskip+(5.5-kk+20)*15 wwdth 15]*SC;
 pbs(kk)=uicontrol(gcf,...
 'Style','text',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'BackgroundColor',colbg,...
 'Visible','off');
end
%
BB=VFULL(4)-14; llth=400;
%
Pos=[128 BB llth 15]*SC;
pbs(5)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'Visible','off');
%
Pos=[128 BB-15 llth 15]*SC;
pbs(6)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'Visible','off');
%
llth=110;
for kk=1:10 % 7->16
 Pos=[4 BB-(kk-1)*15 llth 15]*SC;
 pbs(6+kk)=uicontrol(gcf,...
 'Style','text',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'BackgroundColor',colbg,...
 'Visible','off');
end
%
Pos=[14 BB-14*15 110 15]*SC;
pbs(27)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'Visible','off');
Pos=[14 150 60 20]*SC;
pbs(20)=uicontrol(gcf,...
'Style','push',...
'Position',Pos,...
'HorizontalAlignment','left',...
'Visible','off',...
'String','Annulla');
Pos=[204 BB-120 200 15]*SC;
pbs(17)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'Visible','off',...
'String','SCELTA NON ACCETTABILE');
Pos=[10 5 180 15]*SC;
pbs(18)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'ForegroundColor',vcol2(9,:),...
'Visible','off',...
'String','PREMERE INVIO PER USCIRE');
BB=VFULL(4);
Pos=[20 5 50 20]*SC;
pbs(53)=uicontrol(gcf,...
'Style','push',...
'Position',Pos,...
'String','Esci',...
'Callback','regniaux(40)');
%
% definition of the axes
%
delete(gca)
ax=zeros(3,1);
ax(1)=axes('Position',[0.25,.32,.675,.595],'Box','on');
set(ax(1),'FontSize',10)
ax(2)=axes('Position',[0.37,.05,.24,.18],'Box','on');
set(ax(2),'FontSize',8)
title('uscita del sistema controllato','FontSize',10);
ax(3)=axes('Position',[0.685,.05,.24,.18],'Box','on');
set(ax(3),'FontSize',8)
title('uscita del regolatore','FontSize',10)
axes(ax(1))
%
%  computation of acos
%
prfx=linspace(0,pi/2,200); prfy=-20*log10(cos(prfx));
prfx=180/pi*prfx;
%
datacar=zeros(1,6); datacar1=[];
datacar(1)=kdatap; datacar(2)=kregt;
datacar1=[datacar1;zdatap]; datacar(3)=length(datacar1);
datacar1=[datacar1;pdatap]; datacar(4)=length(datacar1);
datacar1=[datacar1;zregt]; datacar(5)=length(datacar1);
datacar1=[datacar1;pregt]; datacar(6)=length(datacar1);
%
regniaux(0)
figure(nfig)
xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
if islegen
 VV=axis; xx=2*VV(1)-VV(2); yy=2*VV(3)-VV(4);
 hold on, HAL=plot(xx,yy,xx,yy);
 set(HAL(1),'Color',vcol1(7,:)), set(HAL(2),'Color',vcol1(pbs(1),:))
 hold off
end
HALEG=HAL;
cc=get(0,'Children');
if (any(cc==nfig))&(any(cc==nfig1))&(any(cc==nfig2))
 FIGLO(4,1:4)=get(nfig,'Position');
 FIGLO(4,5:8)=get(nfig1,'Position');
 FIGLO(4,9:12)=get(nfig2,'Position');
 save figlo# FIGLO -v4
else
 disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), ordf, return
end
if stktype(1,1)==0
 eval('delete(nfig1)','err=1;'), eval('delete(nfig2)','err=1;')
 clf, ordf(1), return
end
flcomp=pbs(1);
clc
if stktype(flcomp,1)==0, flcomp=flcomp-1; end
if flcomp>1
 xx=0;
 while xx==0
  col=input('\n   scegliere la funzione specificandone il colore : ','s');
  if isempty(col), col='z'; end
  if col=='0', return, end
  ropc=0; for kk=1:6, ropc=ropc|strcmp(col,repco(kk)); end
  if ropc
   if find(repco==col)<=flcomp
    xx=1;
   end
  end
 end
else
 col=repco(1);
end
q=find(repco==col);
eval(['numc=stkn',int2str(q),';'])
eval(['denc=stkd',int2str(q),';'])
[zregt,pregt,kregt]=tozpk(numc,denc);
if str=='s'
 aa=importf(zregt,pregt,kregt,gj);
else
 aa=importf(zregt,pregt,kregt,gj,1);
end
disp(' ')
disp('   IL REGOLATORE OTTENUTO :')
if aa==1, tfg(gj), end
eval('delete(ax(2))','err=1;'), eval('delete(ax(3))','err=1;')
eval('delete(nfig1)','err=1;'), eval('delete(nfig2)','err=1;'), ABIL=0;
eval('delete(pbs(2))','err=1;'), eval('delete(pbs(3))','err=1;')
for kk=5:25, eval('delete(pbs(kk))','err=1;'), end
eval('delete(pbs(27))','err=1;')
for kk=30:40, eval('delete(pbs(kk))','err=1;'), end
eval('delete(pbs(45))','err=1;'), eval('delete(pbs(53))','err=1;')
eval('delete(pbs(60))','err=1;'), eval('delete(pbs(81))','err=1;')
set(nfig,'Color',framesc), set(ax(1),'Position',PO)
set(0,'DefaultUIControlUnits','pixel'), ordf(1)
% --- last line of regnich ---
